/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

public class MathTool {
    public static float decayingOscillation(float a, float t, float c, float elapsedTime) {
        if (elapsedTime >= t) {
            return 0.0f;
        }
        float decayFactor = (float)Math.exp(-3.0f * elapsedTime / t);
        float oscillation = (float)Math.sin(Math.PI * 2 * (double)c * (double)elapsedTime);
        return a * decayFactor * oscillation;
    }

    public static float decayingOscillation(float a, float t, float c, int ticks) {
        float elapsedTime = (float)ticks / 20.0f;
        return MathTool.decayingOscillation(a, t, c, elapsedTime);
    }

    public static int getGradientColor(int startColor, int endColor, int progress, int mode) {
        progress = Math.max(0, Math.min(100, progress));
        float ratio = (float)progress / 100.0f;
        if (mode == 2) {
            return MathTool.hsvGradient(startColor, endColor, ratio);
        }
        return MathTool.hslGradient(startColor, endColor, ratio);
    }

    private static int hsvGradient(int startColor, int endColor, float ratio) {
        float[] startHSV = MathTool.rgbToHsv(startColor);
        float[] endHSV = MathTool.rgbToHsv(endColor);
        float h = MathTool.interpolateHue(startHSV[0], endHSV[0], ratio);
        float s = startHSV[1] + (endHSV[1] - startHSV[1]) * ratio;
        float v = startHSV[2] + (endHSV[2] - startHSV[2]) * ratio;
        return MathTool.hsvToRgb(h, s, v);
    }

    private static int hslGradient(int startColor, int endColor, float ratio) {
        float[] startHSL = MathTool.rgbToHsl(startColor);
        float[] endHSL = MathTool.rgbToHsl(endColor);
        float h = MathTool.interpolateHue(startHSL[0], endHSL[0], ratio);
        float s = startHSL[1] + (endHSL[1] - startHSL[1]) * ratio;
        float l = startHSL[2] + (endHSL[2] - startHSL[2]) * ratio;
        return MathTool.hslToRgb(h, s, l);
    }

    private static float interpolateHue(float startH, float endH, float ratio) {
        float diff = (endH %= 1.0f) - (startH %= 1.0f);
        if (Math.abs(diff) > 0.5f) {
            if (diff > 0.0f) {
                startH += 1.0f;
            } else {
                endH += 1.0f;
            }
        }
        return (startH + (endH - startH) * ratio) % 1.0f;
    }

    private static float[] rgbToHsv(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        float rNorm = (float)r / 255.0f;
        float gNorm = (float)g / 255.0f;
        float bNorm = (float)b / 255.0f;
        float max = Math.max(rNorm, Math.max(gNorm, bNorm));
        float min = Math.min(rNorm, Math.min(gNorm, bNorm));
        float delta = max - min;
        float h = 0.0f;
        if (delta != 0.0f) {
            h = max == rNorm ? (gNorm - bNorm) / delta % 6.0f : (max == gNorm ? (bNorm - rNorm) / delta + 2.0f : (rNorm - gNorm) / delta + 4.0f);
            if ((h /= 6.0f) < 0.0f) {
                h += 1.0f;
            }
        }
        float s = max == 0.0f ? 0.0f : delta / max;
        float v = max;
        return new float[]{h, s, v};
    }

    private static int hsvToRgb(float h, float s, float v) {
        float g;
        float r;
        if ((h %= 1.0f) < 0.0f) {
            h += 1.0f;
        }
        int hi = (int)(h * 6.0f);
        float f = h * 6.0f - (float)hi;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        return (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)((switch (hi) {
            case 0 -> {
                r = v;
                g = t;
                yield p;
            }
            case 1 -> {
                r = q;
                g = v;
                yield p;
            }
            case 2 -> {
                r = p;
                g = v;
                yield t;
            }
            case 3 -> {
                r = p;
                g = q;
                yield v;
            }
            case 4 -> {
                r = t;
                g = p;
                yield v;
            }
            default -> {
                r = v;
                g = p;
                yield q;
            }
        }) * 255.0f);
    }

    private static float[] rgbToHsl(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        float rNorm = (float)r / 255.0f;
        float gNorm = (float)g / 255.0f;
        float bNorm = (float)b / 255.0f;
        float max = Math.max(rNorm, Math.max(gNorm, bNorm));
        float min = Math.min(rNorm, Math.min(gNorm, bNorm));
        float delta = max - min;
        float h = 0.0f;
        if (delta != 0.0f) {
            h = max == rNorm ? (gNorm - bNorm) / delta % 6.0f : (max == gNorm ? (bNorm - rNorm) / delta + 2.0f : (rNorm - gNorm) / delta + 4.0f);
            if ((h /= 6.0f) < 0.0f) {
                h += 1.0f;
            }
        }
        float l = (max + min) / 2.0f;
        float s = delta == 0.0f ? 0.0f : delta / (1.0f - Math.abs(2.0f * l - 1.0f));
        return new float[]{h, s, l};
    }

    private static int hslToRgb(float h, float s, float l) {
        if ((h %= 1.0f) < 0.0f) {
            h += 1.0f;
        }
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float x = c * (1.0f - Math.abs(h * 6.0f % 2.0f - 1.0f));
        float m = l - c / 2.0f;
        if ((double)h < 0.16666666666666666) {
            r = c;
            g = x;
            b = 0.0f;
        } else if ((double)h < 0.3333333333333333) {
            r = x;
            g = c;
            b = 0.0f;
        } else if ((double)h < 0.5) {
            r = 0.0f;
            g = c;
            b = x;
        } else if ((double)h < 0.6666666666666666) {
            r = 0.0f;
            g = x;
            b = c;
        } else if ((double)h < 0.8333333333333334) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        return (int)((r += m) * 255.0f) << 16 | (int)((g += m) * 255.0f) << 8 | (int)((b += m) * 255.0f);
    }

    public static int getGradientColor(int startColor, int endColor, int progress) {
        return MathTool.getGradientColor(startColor, endColor, progress, 1);
    }

    public static String toHexString(int color) {
        return String.format("#%06X", 0xFFFFFF & color);
    }
}

