/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.annotation.ServerOnly;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class BufferSerializer {
    private static final Gson GSON = DataLoader.createCommonBuilder().addSerializationExclusionStrategy(new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(ServerOnly.class) != null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }).create();

    public static List<Field> sortedFields(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(ServerOnly.class) && !f.getType().isAssignableFrom(Annotation.class)).sorted(Comparator.comparing(Field::getName)).toList();
    }

    public static List<Field> sortedFields(Object object) {
        return BufferSerializer.sortedFields(object.getClass());
    }

    public static List<Pair<Object, Field>> fieldValuesList(Object object) {
        ArrayList<Pair<Object, Field>> fields = new ArrayList<Pair<Object, Field>>();
        for (Field field : BufferSerializer.sortedFields(object)) {
            try {
                field.setAccessible(true);
                Object value = field.get(object);
                fields.add((Pair<Object, Field>)new Pair(value, (Object)field));
            }
            catch (IllegalAccessException e) {
                Mod.LOGGER.error("BufferSerializer read error: {}", (Object)e.getMessage());
            }
        }
        return fields;
    }

    public static FriendlyByteBuf serialize(Object object) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        BufferSerializer.fieldValuesList(object).forEach(fieldValue -> {
            Object value = fieldValue.getFirst();
            Field field = (Field)fieldValue.getSecond();
            if (value instanceof Byte) {
                Byte b = (Byte)value;
                buffer.writeByte((int)b.byteValue());
            } else if (value instanceof Integer) {
                Integer i = (Integer)value;
                buffer.m_130130_(i.intValue());
            } else if (value instanceof Long) {
                Long l = (Long)value;
                buffer.writeLong(l.longValue());
            } else if (value instanceof Float) {
                Float f = (Float)value;
                buffer.writeFloat(f.floatValue());
            } else if (value instanceof Double) {
                Double d = (Double)value;
                buffer.writeDouble(d.doubleValue());
            } else if (value instanceof String) {
                String s = (String)value;
                buffer.m_130070_(s);
            } else if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                buffer.writeBoolean(b.booleanValue());
            } else {
                buffer.m_130070_(GSON.toJson(value, field.getGenericType()));
            }
        });
        return buffer;
    }

    public static <T> T deserialize(FriendlyByteBuf buffer, T object) {
        BufferSerializer.sortedFields(object).forEach(field -> {
            Class<?> classType = field.getType();
            if (Byte.TYPE.isAssignableFrom(classType) || Byte.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.readByte());
            } else if (Integer.TYPE.isAssignableFrom(classType) || Integer.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.m_130242_());
            } else if (Long.TYPE.isAssignableFrom(classType) || Long.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.readLong());
            } else if (Float.TYPE.isAssignableFrom(classType) || Float.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, Float.valueOf(buffer.readFloat()));
            } else if (Double.TYPE.isAssignableFrom(classType) || Double.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.readDouble());
            } else if (Boolean.TYPE.isAssignableFrom(classType) || Boolean.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.readBoolean());
            } else if (String.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.m_130277_());
            } else {
                BufferSerializer.setField(object, field, GSON.fromJson(buffer.m_130277_(), field.getGenericType()));
            }
        });
        return object;
    }

    public static void setField(Object object, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            Mod.LOGGER.error("BufferSerializer write error: {}", (Object)e.getMessage());
        }
    }
}

