/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.menu.ChargingStationMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class ShowChargingRangeMessage {
    private final boolean operation;

    public ShowChargingRangeMessage(boolean operation) {
        this.operation = operation;
    }

    public static ShowChargingRangeMessage decode(FriendlyByteBuf buffer) {
        return new ShowChargingRangeMessage(buffer.readBoolean());
    }

    public static void encode(ShowChargingRangeMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.operation);
    }

    public static void handler(ShowChargingRangeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() == null) {
                return;
            }
            ServerPlayer player = context.getSender();
            AbstractContainerMenu menu = player.f_36096_;
            if (menu instanceof ChargingStationMenu) {
                ChargingStationMenu chargingStationMenu = (ChargingStationMenu)menu;
                if (!chargingStationMenu.m_6875_((Player)player)) {
                    return;
                }
                chargingStationMenu.setShowRange(message.operation);
            }
        });
        context.setPacketHandled(true);
    }
}

