/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.api.event.ShootEvent;
import com.atsuishio.superbwarfare.capability.energy.ItemEnergyProvider;
import com.atsuishio.superbwarfare.capability.energy.ItemEnergyStorage;
import com.atsuishio.superbwarfare.client.particle.BulletDecalOption;
import com.atsuishio.superbwarfare.client.screens.WeaponEditScreen;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.data.CustomData;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunPropertyModifier;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.data.gun.SeekType;
import com.atsuishio.superbwarfare.data.gun.ShootParameters;
import com.atsuishio.superbwarfare.data.gun.SoundInfo;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.data.launchable.LaunchableEntityTool;
import com.atsuishio.superbwarfare.data.launchable.ShootData;
import com.atsuishio.superbwarfare.entity.mixin.ICustomKnockback;
import com.atsuishio.superbwarfare.entity.projectile.CannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.CustomDamageProjectile;
import com.atsuishio.superbwarfare.entity.projectile.CustomGravityEntity;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.MissileProjectile;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.SwarmDroneEntity;
import com.atsuishio.superbwarfare.entity.projectile.WireGuideMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.PrismTankEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.ItemScreenProvider;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.resource.gun.GunResource;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.world.phys.EntityResult;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoItem;

@Mod.EventBusSubscriber
public abstract class GunItem
extends Item
implements ItemScreenProvider,
GunPropertyModifier {
    protected static final ResourceLocation DEFAULT_ICON = Mod.loc("textures/gun_icon/default_icon.png");
    protected final RandomSource random = RandomSource.m_216327_();
    public final Map<Integer, Consumer<GunData>> reloadTimeBehaviors = new HashMap<Integer, Consumer<GunData>>();
    public final Map<Integer, Consumer<GunData>> boltTimeBehaviors = new HashMap<Integer, Consumer<GunData>>();
    private boolean isDamageable = false;

    public GunItem(Item.Properties properties) {
        super(properties.m_41487_(1));
        this.addReloadTimeBehavior(this.reloadTimeBehaviors);
        this.addBoltTimeBehavior(this.boltTimeBehaviors);
    }

    @Override
    public DefaultGunData computeProperties(GunData gunData, DefaultGunData rawData) {
        rawData.damage += this.getCustomDamage(gunData);
        rawData.headshot += this.getCustomHeadshot(gunData);
        rawData.bypassesArmor += this.getCustomBypassArmor(gunData);
        rawData.magazine += this.getCustomMagazine(gunData);
        rawData.defaultZoom += this.getCustomZoom(gunData);
        rawData.rpm += this.getCustomRPM(gunData);
        rawData.weight += this.getCustomWeight(gunData);
        rawData.velocity += this.getCustomVelocity(gunData);
        rawData.soundRadius += this.getCustomSoundRadius(gunData);
        return rawData;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        ItemEnergyStorage cap = new ItemEnergyStorage(stack, s -> GunData.compute((ItemStack)stack).maxEnergy, s -> GunData.compute((ItemStack)stack).maxReceiveEnergy, s -> GunData.compute((ItemStack)stack).maxExtractEnergy);
        return new ItemEnergyProvider(stack, (LazyOptional<IEnergyStorage>)LazyOptional.of(() -> cap));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        GunData data = GunData.from(stack);
        if (data.compute().maxDurability > 0) {
            return super.m_142522_(stack);
        }
        return stack.getCapability(ForgeCapabilities.ENERGY).map(cap -> cap.getEnergyStored() > 0 && cap.getMaxEnergyStored() > 0).orElse(false);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        GunData data = GunData.from(stack);
        if (data.compute().maxDurability > 0) {
            return super.m_142158_(stack);
        }
        if (GunData.compute((ItemStack)stack).maxEnergy > 0) {
            Integer energy = stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
            return Math.round((float)((float)energy.intValue() * 13.0f / (float)GunData.compute((ItemStack)stack).maxEnergy));
        }
        return super.m_142158_(stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        GunData data = GunData.from(stack);
        if (data.compute().maxDurability > 0) {
            return super.m_142159_(stack);
        }
        GunResource resource = GunResource.from(stack);
        if (data.compute().maxEnergy > 0) {
            return this.getEnergyBarColor(resource);
        }
        return super.m_142159_(stack);
    }

    public int getEnergyBarColor(GunResource resource) {
        return resource.compute().energyBarColor.get();
    }

    public void init(GunData data) {
        if (this.isInitialized(data)) {
            return;
        }
        data.gunDataTag.m_128362_("UUID", UUID.randomUUID());
        data.save();
    }

    public boolean isInitialized(GunData data) {
        return data.gunDataTag.m_128403_("UUID");
    }

    @ParametersAreNonnullByDefault
    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        LivingEntity living;
        if (!(stack.m_41720_() instanceof GunItem) || level.f_46443_) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel);
        }
        GunData data = GunData.from(stack);
        boolean inMainHand = entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_() == stack;
        data.tick(entity, inMainHand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID(slot.toString().hashCode(), 0L);
        if (slot != EquipmentSlot.MAINHAND) {
            return map;
        }
        GunData data = GunData.from(stack);
        DefaultGunData computed = data.compute();
        map = HashMultimap.create((Multimap)map);
        map.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "superbwarfare_attribute_modifier", (double)-0.01f - (double)0.005f * computed.weight, AttributeModifier.Operation.MULTIPLY_BASE));
        if (computed.meleeDamage > 0.0) {
            map.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "superbwarfare_attribute_modifier", computed.meleeDamage, AttributeModifier.Operation.ADDITION));
        }
        return map;
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        return Optional.of(new GunImageComponent(pStack));
    }

    public ResourceLocation getGunIcon(ItemStack stack) {
        return this.getGunIcon(GunData.from(stack));
    }

    public ResourceLocation getGunIcon(GunData data) {
        ResourceLocation icon = data.compute().icon;
        return icon == null ? DEFAULT_ICON : icon;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public int getMaxDamage(@NotNull ItemStack stack) {
        int maxDurability = GunData.compute((ItemStack)stack).maxDurability;
        this.isDamageable = maxDurability > 0;
        return maxDurability;
    }

    public boolean isDamageable(ItemStack stack) {
        return this.isDamageable;
    }

    public boolean isOpenBolt(GunData data) {
        return false;
    }

    public boolean hasBulletInBarrel(GunData data) {
        return false;
    }

    public boolean hasCustomBarrel(GunData data) {
        return false;
    }

    public int[] getValidBarrels() {
        return new int[]{0, 1, 2};
    }

    public boolean hasCustomGrip(GunData data) {
        return false;
    }

    public int[] getValidGrips() {
        return new int[]{0, 1, 2, 3};
    }

    public boolean hasCustomMagazine(GunData data) {
        return false;
    }

    public int[] getValidMagazines() {
        return new int[]{0, 1, 2};
    }

    public boolean hasCustomScope(GunData data) {
        return false;
    }

    public int[] getValidScopes() {
        return new int[]{0, 1, 2, 3};
    }

    public boolean hasCustomStock(GunData data) {
        return false;
    }

    public int[] getValidStocks() {
        return new int[]{0, 1, 2};
    }

    public boolean hasBipod(GunData data) {
        return false;
    }

    public boolean hasMeleeAttack(GunData data) {
        return data.compute().meleeDamage > 0.0;
    }

    public double getCustomDamage(GunData data) {
        return 0.0;
    }

    public double getCustomHeadshot(GunData data) {
        return 0.0;
    }

    public double getCustomBypassArmor(GunData data) {
        return 0.0;
    }

    public int getCustomMagazine(GunData data) {
        return 0;
    }

    public double getCustomZoom(GunData data) {
        return 0.0;
    }

    public int getCustomRPM(GunData data) {
        return 0;
    }

    public double getCustomWeight(GunData data) {
        CompoundTag tag = data.attachment();
        double scopeWeight = switch (tag.m_128451_("Scope")) {
            case 1 -> 0.5;
            case 2 -> 1.0;
            case 3 -> 1.5;
            default -> 0.0;
        };
        double barrelWeight = switch (tag.m_128451_("Barrel")) {
            case 1 -> 0.5;
            case 2 -> 1.0;
            default -> 0.0;
        };
        double magazineWeight = switch (tag.m_128451_("Magazine")) {
            case 1 -> 1.0;
            case 2 -> 2.0;
            default -> 0.0;
        };
        double stockWeight = switch (tag.m_128451_("Stock")) {
            case 1 -> -2.0;
            case 2 -> 1.5;
            default -> 0.0;
        };
        double gripWeight = switch (tag.m_128451_("Grip")) {
            case 1, 2 -> 0.25;
            case 3 -> 1.0;
            default -> 0.0;
        };
        return scopeWeight + barrelWeight + magazineWeight + stockWeight + gripWeight;
    }

    public double getCustomVelocity(GunData data) {
        return 0.0;
    }

    public double getCustomSoundRadius(GunData data) {
        return data.attachment.get(AttachmentType.BARREL) == 2 ? 0.6 : 1.0;
    }

    public boolean canAdjustZoom(GunData data) {
        return false;
    }

    public boolean canSwitchScope(GunData data) {
        return false;
    }

    public void addReloadTimeBehavior(Map<Integer, Consumer<GunData>> behaviors) {
    }

    public void addBoltTimeBehavior(Map<Integer, Consumer<GunData>> behaviors) {
    }

    public boolean canShoot(GunData data, @Nullable Entity shooter) {
        return data.compute().projectileAmount > 0 && !data.overHeat.get() && data.compute().heatPerShoot <= 100.0 + data.compute().heatPerShoot - data.heat.get() && !data.reloading() && !data.charging() && !data.bolt.needed.get() && data.hasEnoughAmmoToShoot(shooter);
    }

    public boolean useSpecialFireProcedure(GunData data) {
        return false;
    }

    public int hideBulletChainBelowShots() {
        return -1;
    }

    public void whenNoAmmo(GunData data) {
    }

    public void beforeShoot(@NotNull ShootParameters parameters) {
        GunData data = parameters.data();
        Entity ammoSupplier = parameters.ammoSupplier();
        MinecraftForge.EVENT_BUS.post((Event)new ShootEvent.Pre(parameters));
        if (data.compute().boltActionTime > 0 && data.hasEnoughAmmoToShoot(ammoSupplier)) {
            data.bolt.needed.set(true);
        }
        if (data.currentAvailableShots(ammoSupplier) <= this.hideBulletChainBelowShots()) {
            data.hideBulletChain.set(true);
        }
    }

    @Deprecated(forRemoval=true)
    public void beforeShoot(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom) {
    }

    public void afterShoot(@NotNull ShootParameters parameters) {
        int size;
        ItemStack stack;
        GunData data = parameters.data();
        Entity shooter = parameters.shooter();
        Entity ammoSupplier = parameters.ammoSupplier();
        ServerLevel level = parameters.level();
        MinecraftForge.EVENT_BUS.post((Event)new ShootEvent.Post(parameters));
        DefaultGunData computed = data.compute();
        if (!data.useBackpackAmmo()) {
            data.ammo.set(data.ammo.get() - computed.ammoCostPerShoot);
        } else {
            data.consumeBackupAmmo(ammoSupplier, computed.ammoCostPerShoot);
        }
        if (!data.hasEnoughAmmoToShoot(ammoSupplier)) {
            data.burstAmount.reset();
        }
        if (this.getMaxDamage(stack = data.stack()) > 0) {
            if (shooter instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)shooter;
                stack.m_41622_(computed.durabilityPerShoot, living, p -> p.m_21190_(living.m_7655_()));
            } else if (stack.m_220157_(computed.durabilityPerShoot, RandomSource.m_216327_(), null)) {
                stack.m_41774_(1);
            }
        }
        if (shooter != null && computed.recoil != 0.0) {
            shooter.m_20256_(shooter.m_20184_().m_82549_(shooter.m_20252_(1.0f).m_82490_(-computed.recoil)));
        }
        if ((size = computed.shootPos.positions.size()) > 0 && !computed.shootPos.boundUpWithAmmoAmount) {
            data.fireIndex.set((data.fireIndex.get() + 1) % size);
        } else {
            data.fireIndex.reset();
        }
        data.clearTempModifications();
    }

    @Deprecated(forRemoval=true)
    public void afterShoot(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
    }

    public void shoot(@NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
        this.shoot(new ShootParameters(null, null, level, shootPosition, shootDirection, data, spread, zoom, uuid, null));
    }

    public void shoot(@NotNull GunData data, @NotNull Entity shooter, double spread, boolean zoom, UUID uuid) {
        Level level = shooter.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.shoot(new ShootParameters(shooter, shooter, server, new Vec3(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_()), shooter.m_20154_(), data, spread, zoom, uuid, null));
        }
    }

    public void shoot(@NotNull GunData data, @NotNull Entity shooter, double spread, boolean zoom, UUID uuid, Vec3 pos) {
        Level level = shooter.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.shoot(new ShootParameters(shooter, shooter, server, new Vec3(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_()), shooter.m_20154_(), data, spread, zoom, uuid, pos));
        }
    }

    public void shoot(@NotNull ShootParameters parameters) {
        GunData data = parameters.data();
        Entity shooter = parameters.shooter();
        Entity ammoSupplier = parameters.ammoSupplier();
        boolean zoom = parameters.zoom();
        if (!data.canShoot(ammoSupplier)) {
            return;
        }
        data.item.beforeShoot(parameters);
        int projectileAmount = data.compute().projectileAmount;
        for (int index0 = 0; index0 < projectileAmount; ++index0) {
            if (this.shootBullet(parameters)) continue;
            return;
        }
        if (data.selectedFireModeInfo().mode == FireMode.BURST) {
            int amount = data.burstAmount.get();
            data.burstAmount.set(amount == 0 ? data.compute().burstAmount - 1 : Math.max((int)0, (int)(amount - 1)));
        }
        data.heat.set(Math.max((double)(data.heat.get() + data.compute().heatPerShoot), (double)0.0));
        if (data.item.enableShootTimer()) {
            data.shootAnimationTimer.set(data.compute().shootAnimationTime);
            data.shootTimer.set(Math.min((int)(data.shootTimer.get() + 3), (int)5));
        }
        if (data.heat.get() >= 100.0 && !data.overHeat.get()) {
            data.overHeat.set(true);
            if (shooter instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)shooter;
                SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.OVERHEAT.get(), 2.0f, 1.0f);
            }
        }
        this.playFireSounds(data, shooter, zoom);
        data.item.afterShoot(parameters);
        data.save();
    }

    @Deprecated(forRemoval=true)
    public void shoot(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
    }

    public void playFireSounds(GunData data, @Nullable Entity shooter, boolean zoom) {
        SoundEvent soundVeryFar;
        SoundEvent soundFar;
        SoundEvent sound3p;
        if (shooter == null) {
            return;
        }
        float pitch = data.heat.get() <= 75.0 ? 1.0f : (float)(1.0 - 0.02 * Math.abs((double)(75.0 - data.heat.get())));
        Perk perk = data.perk.get(Perk.Type.AMMO);
        if (perk == ModPerks.BEAST_BULLET.get()) {
            shooter.m_5496_((SoundEvent)ModSounds.HENG.get(), 4.0f, pitch);
        }
        float soundRadius = (float)data.compute().soundRadius;
        SoundInfo soundInfo = data.compute().soundInfo;
        boolean isSilent = data.attachment.get(AttachmentType.BARREL) == 2;
        SoundEvent soundEvent = sound3p = isSilent ? soundInfo.fire3PSilent : soundInfo.fire3P;
        if (sound3p != null) {
            shooter.m_5496_(sound3p, soundRadius * 0.4f, pitch);
        }
        SoundEvent soundEvent2 = soundFar = isSilent ? soundInfo.fire3PFarSilent : soundInfo.fire3PFar;
        if (soundFar != null) {
            shooter.m_5496_(soundFar, soundRadius * 0.7f, pitch);
        }
        SoundEvent soundEvent3 = soundVeryFar = isSilent ? soundInfo.fire3PVeryFarSilent : soundInfo.fire3PVeryFar;
        if (soundVeryFar != null) {
            shooter.m_5496_(soundVeryFar, soundRadius, pitch);
        }
    }

    public void onFireKeyPress(GunData data, Player player, boolean zoom) {
        if (data.reload.prepareTimer.get() == 0 && data.reloading() && data.hasEnoughAmmoToShoot((Entity)player)) {
            data.forceStop.set(true);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (data.stack.m_150930_((Item)ModItems.QL_1031.get()) && data.selectedFireModeInfo().name.equals("Hold")) {
                ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(Mod.loc("ql_1031_discharge"), SoundSource.PLAYERS);
                serverPlayer.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
            }
        }
    }

    public void onFireKeyRelease(GunData data, Player player, double power, boolean zoom) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            if (data.compute().seekType == SeekType.HOLD_FIRE) {
                ItemStack stack = data.stack;
                String origin = stack.m_41720_().m_5524_();
                String name = origin.substring(origin.lastIndexOf(".") + 1);
                ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(Mod.loc(name + "_lock"), SoundSource.PLAYERS);
                serverPlayer.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
            }
        }
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            if (data.stack.m_150930_((Item)ModItems.QL_1031.get()) && data.selectedFireModeInfo().name.equals("Hold")) {
                ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(Mod.loc("ql_1031_charge"), SoundSource.PLAYERS);
                serverPlayer.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
            }
        }
    }

    public boolean shootBullet(@NotNull ShootParameters parameters) {
        Entity entity;
        GunData data = parameters.data();
        ServerLevel level = parameters.level();
        Vec3 shootPosition = parameters.shootPosition();
        Vec3 shootDirection = parameters.shootDirection();
        Entity shooter = parameters.shooter();
        boolean zoom = parameters.zoom();
        double spread = parameters.spread();
        UUID uuid = parameters.targetEntityUUID();
        Vec3 targetPos = parameters.targetPos();
        ItemStack stack = data.stack;
        DefaultGunData computed = data.compute();
        ProjectileInfo projectileInfo = computed.projectile();
        String projectileType = projectileInfo.type;
        String projectileTypeStr = projectileType.trim().toLowerCase(Locale.ROOT);
        if (projectileTypeStr.equals("empty")) {
            return true;
        }
        if (projectileTypeStr.equals("ray")) {
            return this.shootRay(parameters);
        }
        double headshot = computed.headshot;
        double damage = computed.damage;
        float velocity = (float)computed.velocity;
        double bypassArmorRate = computed.bypassesArmor;
        if (VectorTool.isInLiquid((Level)level, shootPosition)) {
            velocity = 2.0f + 0.05f * velocity;
        }
        float finalVelocity = velocity;
        AtomicReference entityHolder = new AtomicReference();
        EntityType.m_20632_((String)projectileType).ifPresent(entityType -> {
            Entity entity = entityType.m_20615_((Level)level);
            if (entity == null) {
                Mod.LOGGER.warn("Failed to create projectile entity {}", (Object)projectileType);
                return;
            }
            if (entity instanceof Projectile) {
                Projectile projectileEntity = (Projectile)entity;
                projectileEntity.m_5602_(shooter);
            }
            if (entity instanceof ProjectileEntity) {
                ProjectileEntity projectile = (ProjectileEntity)entity;
                projectile.shooter(shooter).damage((float)damage).headShot((float)headshot).zoom(zoom).bypassArmorRate((float)bypassArmorRate).setGunItemId(stack).velocity(finalVelocity);
            }
            if (entity instanceof CustomDamageProjectile) {
                CustomDamageProjectile customDamageProjectile = (CustomDamageProjectile)entity;
                customDamageProjectile.setDamage((float)damage);
            }
            if (entity instanceof CustomGravityEntity) {
                CustomGravityEntity customGravityEntity = (CustomGravityEntity)entity;
                customGravityEntity.setGravity((float)computed.gravity);
            }
            if (entity instanceof ExplosiveProjectile) {
                ExplosiveProjectile explosive = (ExplosiveProjectile)entity;
                explosive.setExplosionDamage((float)computed.explosionDamage);
                explosive.setExplosionRadius((float)computed.explosionRadius);
            }
            if (entity instanceof WireGuideMissileEntity) {
                WireGuideMissileEntity wireGuideMissileEntity = (WireGuideMissileEntity)entity;
                if (shooter != null && shooter.m_20202_() != null) {
                    wireGuideMissileEntity.setLauncherVehicle(shooter.m_20202_().m_20148_());
                }
            }
            if (entity instanceof SmallCannonShellEntity) {
                SmallCannonShellEntity smallCannonShell = (SmallCannonShellEntity)entity;
                if (computed.isAntiAirProjectile) {
                    smallCannonShell.antiAir(true);
                }
            }
            if (entity instanceof CannonShellEntity) {
                CannonShellEntity cannonShell = (CannonShellEntity)entity;
                if (computed.isArmorPiercingProjectile) {
                    cannonShell.setType(CannonShellEntity.Type.AP);
                    cannonShell.durability(100);
                } else if (computed.isHighExplosiveProjectile) {
                    cannonShell.setType(CannonShellEntity.Type.HE);
                } else if (computed.isClusterMunitionsProjectile) {
                    cannonShell.setType(CannonShellEntity.Type.CM);
                    cannonShell.setSpreadAmount(computed.spreadAmount);
                    cannonShell.setSpreadAngle(computed.spreadAngle);
                } else if (computed.isGrapeShotProjectile) {
                    cannonShell.setType(CannonShellEntity.Type.GRAPE);
                    cannonShell.setSpreadAmount(computed.spreadAmount);
                    cannonShell.setSpreadAngle(computed.spreadAngle);
                }
            }
            if (entity instanceof MissileProjectile) {
                MissileProjectile missileProjectile = (MissileProjectile)entity;
                if (shooter != null) {
                    Entity target = EntityFindUtil.findEntity(shooter.m_9236_(), String.valueOf(uuid));
                    if (target != null) {
                        missileProjectile.setGuideType(0);
                        missileProjectile.setTargetUuid(String.valueOf(uuid));
                    } else if (targetPos != null) {
                        missileProjectile.setGuideType(1);
                        missileProjectile.setTargetVec(targetPos);
                    }
                }
            }
            if (entity instanceof SwarmDroneEntity) {
                Entity patt30494$temp;
                SwarmDroneEntity swarmDrone = (SwarmDroneEntity)entity;
                if (shooter != null && (patt30494$temp = shooter.m_20202_()) instanceof VehicleEntity) {
                    VehicleEntity vehicle = (VehicleEntity)patt30494$temp;
                    swarmDrone.setRotate(vehicle.getTurretVector(1.0f));
                }
            }
            if (projectileInfo.data != null) {
                CompoundTag tag = LaunchableEntityTool.getModifiedTag(projectileInfo, new ShootData(shooter != null ? shooter.m_20148_() : null, damage, computed.explosionDamage, computed.explosionRadius, computed.spread));
                if (tag != null) {
                    entity.m_20258_(tag);
                }
            } else if (CustomData.LAUNCHABLE_ENTITY.containsKey(projectileType)) {
                ProjectileInfo newInfo = new ProjectileInfo();
                newInfo.data = CustomData.LAUNCHABLE_ENTITY.get((Object)projectileType).data;
                newInfo.type = projectileType;
                CompoundTag tag = LaunchableEntityTool.getModifiedTag(newInfo, new ShootData(shooter != null ? shooter.m_20148_() : null, damage, computed.explosionDamage, computed.explosionRadius, computed.spread));
                if (tag != null) {
                    entity.m_20258_(tag);
                }
            }
            entityHolder.set(entity);
        });
        Entity entity2 = (Entity)entityHolder.get();
        if (entity2 == null) {
            Mod.LOGGER.warn("Failed to create projectile entity {}", (Object)projectileType);
            return false;
        }
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().modifyProjectile(data, instance, entity2);
        }
        if (shooter != null && (entity = shooter.m_20202_()) instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            if (computed.addShooterDeltaMovement) {
                velocity = (float)(vehicle.m_20184_().m_82553_() * computed.velocity);
            }
        }
        entity2.m_6034_(shootPosition.f_82479_ - 0.1 * shootDirection.f_82479_, shootPosition.f_82480_ - 0.1 - 0.1 * shootDirection.f_82480_, shootPosition.f_82481_ + -0.1 * shootDirection.f_82481_);
        double x = shootDirection.f_82479_;
        double y = shootDirection.f_82480_ + (double)0.001f;
        double z = shootDirection.f_82481_;
        if (uuid != null && zoom && shooter != null && !shooter.m_6144_()) {
            Entity target = EntityFindUtil.findEntity((Level)level, String.valueOf(uuid));
            GunData gunData = GunData.from(stack);
            short intelligentChipLevel = gunData.perk.getLevel(ModPerks.INTELLIGENT_CHIP);
            if (intelligentChipLevel > 0 && target != null) {
                Vec3 targetVec = target.m_146892_();
                Vec3 playerVec = shooter.m_146892_();
                boolean hasGravity = gunData.perk.getLevel(ModPerks.MICRO_MISSILE) <= 0;
                Vec3 toVec = RangeTool.calculateFiringSolution(playerVec, targetVec, Vec3.f_82478_, computed.velocity, hasGravity ? 0.03 : 0.0);
                x = toVec.f_82479_;
                y = toVec.f_82480_;
                z = toVec.f_82481_;
            }
        }
        if (entity2 instanceof Projectile) {
            Projectile projectile = (Projectile)entity2;
            projectile.m_6686_(x, y, z, velocity, (float)spread);
        } else {
            RandomSource random = RandomSource.m_216327_();
            Vec3 vec3 = new Vec3(x, y, z).m_82541_().m_82520_(random.m_216328_(0.0, 0.0172275 * spread), random.m_216328_(0.0, 0.0172275 * spread), random.m_216328_(0.0, 0.0172275 * spread)).m_82490_((double)velocity);
            entity2.m_20256_(vec3);
            entity2.f_19812_ = true;
            double d0 = vec3.m_165924_();
            entity2.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 180.0 / 3.1415927410125732));
            entity2.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 180.0 / 3.1415927410125732));
            entity2.f_19859_ = entity2.m_146908_();
            entity2.f_19860_ = entity2.m_146909_();
        }
        level.m_7967_(entity2);
        return true;
    }

    @Deprecated(forRemoval=true)
    public boolean shootBullet(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
        return false;
    }

    public boolean shootRay(@NotNull ShootParameters parameters) {
        Entity shooter = parameters.shooter();
        ServerLevel level = parameters.level();
        GunData data = parameters.data();
        Vec3 shootPosition = parameters.shootPosition();
        Vec3 shootDirection = parameters.shootDirection();
        if (shooter == null) {
            return false;
        }
        int range = data.compute().range;
        Entity target = null;
        double distance = range * range;
        BlockHitResult blockHitResult = shooter.m_9236_().m_45547_(new ClipContext(shootPosition, shootPosition.m_82549_(shootDirection.m_82490_((double)range)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, shooter));
        BlockPos blockPos = blockHitResult.m_82425_();
        BlockState state = level.m_8055_(blockPos);
        Vec3 pos = null;
        if (state.m_60815_()) {
            pos = blockHitResult.m_82450_();
        }
        Vec3 toVec = shootPosition.m_82520_(shootDirection.f_82479_ * (double)range, shootDirection.f_82480_ * (double)range, shootDirection.f_82481_ * (double)range);
        AABB aabb = shooter.m_20191_().m_82369_(shootDirection.m_82490_((double)range)).m_82400_(1.0);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)shooter, (Vec3)shootPosition, (Vec3)toVec, (AABB)aabb, p -> !p.m_5833_() && p.m_6084_(), (double)distance);
        Vec3 hitPos = null;
        if (entityHitResult != null) {
            hitPos = entityHitResult.m_82450_();
            target = entityHitResult.m_82443_();
        }
        if (pos != null && hitPos != null) {
            if (shootPosition.m_82557_(pos) < shootPosition.m_82557_(hitPos)) {
                this.onRayHitBlock(shooter, level, target, data, shootDirection, blockHitResult, pos);
            } else {
                this.rayHitEntity(shooter, target, level, data, hitPos, shootPosition, shootDirection);
            }
            return true;
        }
        Entity entity = shooter.m_20202_();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            vehicle.m_20088_().m_135381_(PrismTankEntity.LASER_LENGTH, (Object)Float.valueOf(range));
            vehicle.m_20088_().m_135381_(VehicleEntity.LASER_SCALE, (Object)Float.valueOf(data.compute().shootAnimationTime));
        }
        if (hitPos != null) {
            this.rayHitEntity(shooter, target, level, data, hitPos, shootPosition, shootDirection);
            return true;
        }
        if (pos != null) {
            this.onRayHitBlock(shooter, level, target, data, shootDirection, blockHitResult, pos);
            return true;
        }
        return true;
    }

    protected void rayHitEntity(Entity shooter, Entity target, ServerLevel level, @NotNull GunData data, Vec3 hitPos, Vec3 shootPosition, Vec3 shootDirection) {
        if (target != null && target.m_6084_()) {
            Vec3 hitBoxPos = hitPos.m_82546_(target.m_20182_());
            EntityResult res = GunItem.getEntityResult(target, hitBoxPos, hitPos);
            this.onRayHitEntity(shooter, level, data, res, shootPosition, shootDirection);
        }
    }

    protected static EntityResult getEntityResult(Entity target, Vec3 hitBoxPos, Vec3 hitPos) {
        boolean headshot = false;
        boolean legShot = false;
        float eyeHeight = target.m_20192_();
        float bodyHeight = target.m_20206_();
        if (target instanceof LivingEntity) {
            if ((double)eyeHeight - 0.25 < hitBoxPos.f_82480_ && hitBoxPos.f_82480_ < (double)eyeHeight + 0.3) {
                headshot = true;
            }
            if (hitBoxPos.f_82480_ < 0.33 * (double)bodyHeight) {
                legShot = true;
            }
        }
        return new EntityResult(target, hitPos, headshot, legShot);
    }

    public void onRayHitBlock(Entity shooter, ServerLevel level, @Nullable Entity target, @NotNull GunData data, Vec3 shootDirection, BlockHitResult result, @NotNull Vec3 pos) {
        BlockPos blockPos = result.m_82425_();
        if (target == null) {
            BulletDecalOption bulletDecalOption = new BulletDecalOption(result.m_82434_(), blockPos);
            ParticleTool.sendParticle(level, bulletDecalOption, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0, true);
        }
        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.getRayHitBlockSound(data), SoundSource.BLOCKS, 0.7f, (float)((2.0 * Math.random() - 1.0) * (double)0.05f + 1.0));
    }

    public SoundEvent getRayHitBlockSound(GunData data) {
        return SoundEvents.f_271165_;
    }

    public SoundEvent getRayHitEntitySound(GunData data) {
        return SoundEvents.f_271165_;
    }

    public void onRayHitEntity(Entity shooter, ServerLevel level, @NotNull GunData data, EntityResult result, Vec3 shootPosition, Vec3 shootDirection) {
        Entity target = result.getEntity();
        float damage = (float)data.compute().damage;
        float headshot = (float)data.compute().headshot;
        int type = 0;
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            ICustomKnockback iCustomKnockback = ICustomKnockback.getInstance(living);
            iCustomKnockback.superbWarfare$setKnockbackStrength(0.0);
            if (result.isHeadshot()) {
                DamageHandler.doDamage((Entity)living, ModDamageTypes.causeLaserHeadshotDamage(level.m_9598_(), null, shooter), damage * headshot);
                type = 1;
            } else if (result.isLegShot()) {
                DamageHandler.doDamage((Entity)living, ModDamageTypes.causeLaserDamage(level.m_9598_(), null, shooter), damage * 0.5f);
            } else {
                DamageHandler.doDamage((Entity)living, ModDamageTypes.causeLaserDamage(level.m_9598_(), null, shooter), damage);
            }
            target.f_19802_ = 0;
            iCustomKnockback.superbWarfare$resetKnockbackStrength();
        } else {
            if (result.isHeadshot()) {
                DamageHandler.doDamage(target, ModDamageTypes.causeLaserHeadshotDamage(level.m_9598_(), null, shooter), damage * headshot);
                type = 1;
            } else if (result.isLegShot()) {
                DamageHandler.doDamage(target, ModDamageTypes.causeLaserDamage(level.m_9598_(), null, shooter), damage * 0.5f);
            } else {
                DamageHandler.doDamage(target, ModDamageTypes.causeLaserDamage(level.m_9598_(), null, shooter), damage);
            }
            if (target instanceof VehicleEntity) {
                type = 3;
            }
        }
        if (shooter instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)shooter;
            player.m_9236_().m_5594_(null, player.m_20183_(), result.isHeadshot() ? (SoundEvent)ModSounds.HEADSHOT.get() : (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 0.1f, 1.0f);
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(type, 5));
        }
        level.m_6263_(null, result.getHitPos().f_82479_, result.getHitPos().f_82480_, result.getHitPos().f_82481_, this.getRayHitEntitySound(data), SoundSource.PLAYERS, 0.7f, (float)((2.0 * Math.random() - 1.0) * (double)0.05f + 1.0));
    }

    protected Vec3 randomVec(Vec3 vec3, double spread) {
        return vec3.m_82541_().m_82520_(this.random.m_216328_(0.0, 0.0172275 * spread), this.random.m_216328_(0.0, 0.0172275 * spread), this.random.m_216328_(0.0, 0.0172275 * spread));
    }

    public boolean canEditAttachments(GunData data) {
        return data.compute().getAmmoConsumers().size() > 1;
    }

    public boolean enableShootTimer() {
        return false;
    }

    public void onChangeSlot(GunData data, Entity ammoSupplier) {
        if (data.compute().withdrawAmmoWhenChangeSlot) {
            data.withdrawAmmo(ammoSupplier);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen getItemScreen(ItemStack stack, Player player, InteractionHand hand) {
        if (ClientEventHandler.canOpenEditScreen(stack, hand) && stack.m_41720_() instanceof GunItem && this.canEditAttachments(GunData.from(stack))) {
            return new WeaponEditScreen(stack);
        }
        return null;
    }

    public DefaultGunData getDefaultData(GunData data) {
        return GunData.getDefault(data.id);
    }

    public LazyOptional<IEnergyStorage> getEnergyProvider(@NotNull GunData data, @Nullable Entity ammoSupplier) {
        return data.stack.getCapability(ForgeCapabilities.ENERGY);
    }
}

