/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.block.VehicleAssemblingTableBlock;
import com.atsuishio.superbwarfare.block.property.BlockPart;
import com.atsuishio.superbwarfare.client.renderer.item.VehicleAssemblingTableBlockItemRenderer;
import com.atsuishio.superbwarfare.init.ModBlocks;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VehicleAssemblingTableBlockItem
extends BlockItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public VehicleAssemblingTableBlockItem() {
        super((Block)ModBlocks.VEHICLE_ASSEMBLING_TABLE.get(), new Item.Properties());
    }

    @Nullable
    public static BlockPos findInitialPos(@NotNull BlockPlaceContext context, BlockPos currentPos, Direction facing) {
        BlockPart availablePart = null;
        for (BlockPart part : BlockPart.values()) {
            BlockPos placePos = part.relativeNegative(currentPos, facing);
            if (!VehicleAssemblingTableBlockItem.canPlace(context, placePos, facing)) continue;
            availablePart = part;
            break;
        }
        if (availablePart == null) {
            return null;
        }
        return availablePart.relativeNegative(currentPos, facing);
    }

    protected boolean m_40610_(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)VehicleAssemblingTableBlock.FACING);
        BlockPos initialPos = VehicleAssemblingTableBlockItem.findInitialPos(context, context.m_8083_(), facing);
        if (initialPos == null) {
            return false;
        }
        Player player = context.m_43723_();
        CollisionContext collisionContext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        for (BlockPart blockPart : BlockPart.values()) {
            BlockPos blockPos = blockPart.relative(initialPos, facing);
            if (context.m_43725_().m_45752_(state, blockPos, collisionContext)) continue;
            return false;
        }
        return super.m_40610_(context, state);
    }

    public static boolean canPlace(@NotNull BlockPlaceContext context, BlockPos pos, Direction direction) {
        for (BlockPart part : BlockPart.values()) {
            BlockPos detectPos = part.relative(pos, direction);
            if (context.m_43725_().m_8055_(detectPos).m_60629_(context)) continue;
            return false;
        }
        return true;
    }

    public static boolean canPlace(@NotNull Level level, BlockPos pos, Direction direction, BlockPos skipPos) {
        for (BlockPart part : BlockPart.values()) {
            BlockPos detectPos = part.relative(pos, direction);
            if (detectPos.equals((Object)skipPos) || level.m_8055_(detectPos).m_247087_()) continue;
            return false;
        }
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new VehicleAssemblingTableBlockItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }
}

