/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PerkItem
extends Item {
    private final Supplier<Perk> perk;

    public PerkItem(Supplier<Perk> perk) {
        super(new Item.Properties());
        this.perk = perk;
    }

    public PerkItem(Supplier<Perk> perk, Rarity rarity) {
        super(new Item.Properties().m_41497_(rarity));
        this.perk = perk;
    }

    public Perk getPerk() {
        return this.perk.get();
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltips, TooltipFlag isAdvanced) {
        ChatFormatting chatFormatting = switch (this.getPerk().type) {
            default -> throw new IncompatibleClassChangeError();
            case Perk.Type.AMMO -> ChatFormatting.YELLOW;
            case Perk.Type.FUNCTIONAL -> ChatFormatting.GREEN;
            case Perk.Type.DAMAGE -> ChatFormatting.RED;
        };
        tooltips.add((Component)Component.m_237115_((String)("des.superbwarfare." + this.getPerk().descriptionId)).m_130940_(ChatFormatting.GRAY));
        tooltips.add((Component)Component.m_237119_());
        tooltips.add((Component)Component.m_237115_((String)"perk.superbwarfare.slot").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)("perk.superbwarfare.slot_" + this.getPerk().type.getName())).m_130940_(chatFormatting)));
        Perk perk = this.getPerk();
        if (perk instanceof AmmoPerk) {
            AmmoPerk ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.damageRate < 1.0) {
                tooltips.add((Component)Component.m_237115_((String)"des.superbwarfare.perk_damage_reduce").m_130940_(ChatFormatting.RED));
            } else if (ammoPerk.damageRate > 1.0) {
                tooltips.add((Component)Component.m_237115_((String)"des.superbwarfare.perk_damage_plus").m_130940_(ChatFormatting.GREEN));
            }
            if (ammoPerk.speedRate < 1.0) {
                tooltips.add((Component)Component.m_237115_((String)"des.superbwarfare.perk_speed_reduce").m_130940_(ChatFormatting.RED));
            } else if (ammoPerk.speedRate > 1.0) {
                tooltips.add((Component)Component.m_237115_((String)"des.superbwarfare.perk_speed_plus").m_130940_(ChatFormatting.GREEN));
            }
            if (ammoPerk.slug) {
                tooltips.add((Component)Component.m_237115_((String)"des.superbwarfare.perk_slug").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

