/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.utils;

import com.atsuishio.superbwarfare.data.vehicle.subdata.EngineInfo;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;

public final class VehicleEngineUtils {
    public static void trackEngine(VehicleEntity vehicle, EngineInfo.Track engineInfo) {
        int i;
        double buoyancy = engineInfo.buoyancy;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.m_14154_((float)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue()));
        double wheelRotSpeed = engineInfo.wheelRotSpeed;
        double wheelDifferential = engineInfo.wheelDifferential;
        double trackSpeed = engineInfo.trackRotSpeed;
        double trackDifferential = engineInfo.trackDifferential;
        float maxForwardSpeedRate = engineInfo.maxForwardSpeedRate;
        float maxBackwardSpeedRate = engineInfo.maxBackwardSpeedRate;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float steeringSpeed = engineInfo.steeringSpeed;
        if (buoyancy != 0.0) {
            double fluidFloat = buoyancy * VehicleVecUtils.getSubmergedHeight(vehicle);
            vehicle.m_20256_(vehicle.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        }
        if (vehicle.m_20096_()) {
            float f0 = 0.54f + 0.25f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f)))) / 90.0f;
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82541_().m_82490_(0.05 * vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)))));
            vehicle.m_20256_(vehicle.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else if (vehicle.isInFluidType()) {
            float f1 = 0.74f + 0.09f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f)))) / 90.0f;
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82541_().m_82490_(0.04 * vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)))));
            vehicle.m_20256_(vehicle.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        } else {
            vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        Entity passenger0 = vehicle.m_146895_();
        if (vehicle.getEnergy() <= energyCost) {
            return;
        }
        if (passenger0 == null) {
            vehicle.setLeftInputDown(false);
            vehicle.setRightInputDown(false);
            vehicle.setForwardInputDown(false);
            vehicle.setBackInputDown(false);
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(0.0f));
        }
        if (vehicle.forwardInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() + (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() < 0.0f ? powerAdd * 2.0f : powerAdd)), (float)1.0f)));
        }
        if (vehicle.backInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f ? powerReduce * 2.0f : powerReduce)), (float)-1.0f)));
            if (vehicle.rightInputDown()) {
                vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() + steeringSpeed));
            } else if (vehicle.leftInputDown()) {
                vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() - steeringSpeed));
            }
        } else if (vehicle.rightInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() - steeringSpeed));
        } else if (vehicle.leftInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() + steeringSpeed));
        }
        vehicle.targetSpeed = ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f ? (double)(maxForwardSpeedRate * (1.0f + vehicle.m_146909_() / 55.0f)) : (double)(maxBackwardSpeedRate * (1.0f - vehicle.m_146909_() / 55.0f));
        if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        if (vehicle.upInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.6f));
        }
        if (vehicle.rightInputDown() || vehicle.leftInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        if (vehicle.m_9236_() instanceof ServerLevel) {
            vehicle.consumeEnergy(energyCost);
        }
        vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.76f - (double)0.1f * vehicle.m_20184_().m_165924_()), (double)0.3)));
        double s0 = vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f));
        vehicle.setLeftWheelRot((float)((double)vehicle.getLeftWheelRot() - wheelRotSpeed * s0 + Mth.m_14008_((double)(wheelDifferential * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        vehicle.setRightWheelRot((float)((double)vehicle.getRightWheelRot() - wheelRotSpeed * s0 - Mth.m_14008_((double)(wheelDifferential * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        vehicle.setLeftTrack((float)((double)vehicle.getLeftTrack() - trackSpeed * java.lang.Math.PI * s0 + Mth.m_14008_((double)(trackDifferential * java.lang.Math.PI * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        vehicle.setRightTrack((float)((double)vehicle.getRightTrack() - trackSpeed * java.lang.Math.PI * s0 - Mth.m_14008_((double)(trackDifferential * java.lang.Math.PI * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.L_WHEEL_DAMAGED)).booleanValue() && ((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.R_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.93f));
            i = 0;
        } else if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.L_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.975f));
            i = 3;
        } else if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.R_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.975f));
            i = -3;
        } else {
            i = 0;
        }
        if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.MAIN_ENGINE_DAMAGED)).booleanValue()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        vehicle.m_146922_((float)((double)vehicle.m_146908_() - (vehicle.isInFluidType() && !vehicle.m_20096_() ? 2.5 : 6.0) * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() - (double)i * s0));
        if (vehicle.isInFluidType() || vehicle.m_20096_()) {
            double water = !vehicle.isInFluidType() && !vehicle.m_20096_() ? 0.05f : (vehicle.isInFluidType() && !vehicle.m_20096_() ? 0.3f : 1.0f);
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82490_(0.15 * water * vehicle.targetSpeed * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue())));
        }
    }

    public static void wheelEngine(VehicleEntity vehicle, EngineInfo.Wheel engineInfo) {
        int i;
        double buoyancy = engineInfo.buoyancy;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.m_14154_((float)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue()));
        double wheelRotSpeed = engineInfo.wheelRotSpeed;
        double wheelDifferential = engineInfo.wheelDifferential;
        float maxForwardSpeedRate = engineInfo.maxForwardSpeedRate;
        float maxBackwardSpeedRate = engineInfo.maxBackwardSpeedRate;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float steeringSpeed = engineInfo.steeringSpeed;
        if (buoyancy != 0.0) {
            double fluidFloat = buoyancy * VehicleVecUtils.getSubmergedHeight(vehicle);
            vehicle.m_20256_(vehicle.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        }
        if (vehicle.m_20096_()) {
            float f0 = 0.54f + 0.25f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f)))) / 90.0f;
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82541_().m_82490_(0.05 * vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)))));
            vehicle.m_20256_(vehicle.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else if (vehicle.isInFluidType()) {
            float f1 = 0.74f + 0.09f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f)))) / 90.0f;
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82541_().m_82490_(0.04 * vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)))));
            vehicle.m_20256_(vehicle.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        } else {
            vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        Level level = vehicle.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (vehicle.isInFluidType() && vehicle.m_20184_().m_82553_() > 0.1) {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, vehicle.m_20185_() + 0.5 * vehicle.m_20184_().f_82479_, vehicle.m_20186_() + VehicleVecUtils.getSubmergedHeight(vehicle) - 0.2, vehicle.m_20189_() + 0.5 * vehicle.m_20184_().f_82481_, (int)(2.0 + 4.0 * vehicle.m_20184_().m_82553_()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123774_, vehicle.m_20185_() + 0.5 * vehicle.m_20184_().f_82479_, vehicle.m_20186_() + VehicleVecUtils.getSubmergedHeight(vehicle) - 0.2, vehicle.m_20189_() + 0.5 * vehicle.m_20184_().f_82481_, (int)(2.0 + 10.0 * vehicle.m_20184_().m_82553_()), 0.65, 0.0, 0.65, 0.0, true);
            }
        }
        Entity passenger0 = vehicle.m_146895_();
        if (vehicle.getEnergy() <= energyCost) {
            return;
        }
        if (passenger0 == null) {
            vehicle.setLeftInputDown(false);
            vehicle.setRightInputDown(false);
            vehicle.setForwardInputDown(false);
            vehicle.setBackInputDown(false);
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(0.0f));
        }
        if (vehicle.forwardInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() + (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() < 0.0f ? powerAdd * 2.0f : powerAdd)), (float)1.0f)));
        }
        if (vehicle.backInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f ? powerReduce * 2.0f : powerReduce)), (float)-1.0f)));
        }
        vehicle.targetSpeed = ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f ? (double)(maxForwardSpeedRate * (1.0f + vehicle.m_146909_() / 55.0f)) : (double)(maxBackwardSpeedRate * (1.0f - vehicle.m_146909_() / 55.0f));
        if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.97f));
        }
        if (vehicle.upInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.6f));
        }
        if (vehicle.rightInputDown() || vehicle.leftInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.98f));
        }
        if (vehicle.m_9236_() instanceof ServerLevel) {
            vehicle.consumeEnergy(energyCost);
        }
        if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.L_WHEEL_DAMAGED)).booleanValue() && ((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.R_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.93f));
            i = 0;
        } else if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.L_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.975f));
            i = 3;
        } else if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.R_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.975f));
            i = -3;
        } else {
            i = 0;
        }
        if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.MAIN_ENGINE_DAMAGED)).booleanValue()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.875f));
        }
        if (vehicle.rightInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() + steeringSpeed));
        } else if (vehicle.leftInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() - steeringSpeed));
        }
        vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.78f - 0.25 * vehicle.m_20184_().m_165924_()), (double)0.1)));
        double s0 = vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f));
        vehicle.setLeftWheelRot((float)((double)vehicle.getLeftWheelRot() - wheelRotSpeed * s0 - Mth.m_14008_((double)(wheelDifferential * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0) * vehicle.m_20184_().m_82553_()));
        vehicle.setRightWheelRot((float)((double)vehicle.getRightWheelRot() - wheelRotSpeed * s0 + Mth.m_14008_((double)(wheelDifferential * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0) * vehicle.m_20184_().m_82553_()));
        vehicle.setRudderRot(Mth.m_14036_((float)(vehicle.getRudderRot() - ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue()), (float)-0.8f, (float)0.8f) * 0.75f);
        vehicle.m_146922_((float)((double)vehicle.m_146908_() - Math.max((double)((double)(vehicle.isInFluidType() && !vehicle.m_20096_() ? 6 : 12) * vehicle.m_20184_().m_165924_()), (double)0.0) * (double)vehicle.getRudderRot() * (double)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f ? 1 : -1) - (double)i * s0));
        if (vehicle.isInFluidType() || vehicle.m_20096_()) {
            double water = !vehicle.isInFluidType() && !vehicle.m_20096_() ? 0.05f : (vehicle.isInFluidType() && !vehicle.m_20096_() ? 0.3f : 1.0f);
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82490_(0.15 * water * vehicle.targetSpeed * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue())));
        }
    }

    public static void shipEngine(VehicleEntity vehicle, EngineInfo.Ship engineInfo) {
        double buoyancy = engineInfo.buoyancy;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.m_14154_((float)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue()));
        float maxForwardSpeedRate = engineInfo.maxForwardSpeedRate;
        float maxBackwardSpeedRate = engineInfo.maxBackwardSpeedRate;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float steeringSpeed = engineInfo.steeringSpeed;
        double bodyPitchRate = engineInfo.bodyPitchRate;
        double bodyRollRate = engineInfo.bodyRollRate;
        if (buoyancy != 0.0) {
            double fluidFloat = buoyancy * VehicleVecUtils.getSubmergedHeight(vehicle);
            vehicle.m_20256_(vehicle.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        }
        if (vehicle.m_20096_()) {
            vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.2, 0.99, 0.2));
        } else if (vehicle.isInFluidType()) {
            float f = (float)(0.75 - (double)0.04f * java.lang.Math.min(VehicleVecUtils.getSubmergedHeight(vehicle), (double)vehicle.m_20206_()) + (double)(0.09f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f)))) / 90.0f));
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82541_().m_82490_(0.04 * vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)))));
            vehicle.m_20256_(vehicle.m_20184_().m_82542_((double)f, 0.85, (double)f));
        } else {
            vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        Level level = vehicle.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (vehicle.isInFluidType() && vehicle.m_20184_().m_82553_() > 0.1) {
                double y = vehicle.m_20186_() + VehicleVecUtils.getSubmergedHeight(vehicle) - 0.2;
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, vehicle.m_20185_() + 0.5 * vehicle.m_20184_().f_82479_, y, vehicle.m_20189_() + 0.5 * vehicle.m_20184_().f_82481_, (int)(2.0 + 4.0 * vehicle.m_20184_().m_82553_()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123774_, vehicle.m_20185_() + 0.5 * vehicle.m_20184_().f_82479_, y, vehicle.m_20189_() + 0.5 * vehicle.m_20184_().f_82481_, (int)(2.0 + 10.0 * vehicle.m_20184_().m_82553_()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123774_, vehicle.m_20185_() - 4.5 * vehicle.m_20154_().f_82479_, vehicle.m_20186_() - 0.25, vehicle.m_20189_() - 4.5 * vehicle.m_20154_().f_82481_, (int)(40.0f * Mth.m_14154_((float)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue())), 0.15, 0.15, 0.15, 0.02, true);
            }
        }
        Entity passenger0 = vehicle.m_146895_();
        if (vehicle.getEnergy() > energyCost) {
            if (passenger0 == null) {
                vehicle.setLeftInputDown(false);
                vehicle.setRightInputDown(false);
                vehicle.setForwardInputDown(false);
                vehicle.setBackInputDown(false);
            }
            if (vehicle.forwardInputDown()) {
                vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() + (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() < 0.0f ? powerAdd * 2.0f : powerAdd)), (float)1.0f)));
            }
            if (vehicle.backInputDown()) {
                vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f ? powerReduce * 2.0f : powerReduce)), (float)-1.0f)));
            }
            vehicle.targetSpeed = ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f ? (double)maxForwardSpeedRate : (double)maxBackwardSpeedRate;
            if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
                vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.97f));
            }
            if (vehicle.rightInputDown() || vehicle.leftInputDown()) {
                vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.98f));
            }
            if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.MAIN_ENGINE_DAMAGED)).booleanValue()) {
                vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.875f));
            }
            if (vehicle.m_9236_() instanceof ServerLevel) {
                vehicle.consumeEnergy(energyCost);
            }
            if (vehicle.rightInputDown()) {
                vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() - steeringSpeed));
            } else if (vehicle.leftInputDown()) {
                vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() + steeringSpeed));
            }
            vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.78f - 0.25 * vehicle.m_20184_().m_165924_()), (double)0.1)));
            vehicle.setPropellerRot(vehicle.getPropellerRot() + 2.0f * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue());
            vehicle.setRudderRot(Mth.m_14036_((float)(vehicle.getRudderRot() - ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue()), (float)-0.8f, (float)0.8f) * 0.75f);
            if (vehicle.isInFluidType() || vehicle.m_5842_()) {
                vehicle.m_146926_(vehicle.m_146909_() * 0.85f);
                float direct = (90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f))) / 90.0f;
                vehicle.m_146926_((float)((double)vehicle.m_146909_() - (double)(direct * (float)(!vehicle.m_20096_() ? 1 : 0)) * bodyPitchRate * vehicle.m_20184_().m_165924_()));
                vehicle.m_146922_((float)((double)vehicle.m_146908_() - 20.0 * vehicle.m_20184_().m_165924_() * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() * (double)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f ? 1 : -1)));
                vehicle.setZRot((float)((double)vehicle.getRoll() - (double)(direct * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() * (float)(!vehicle.m_20096_() ? 1 : 0)) * bodyRollRate * 10.0 * vehicle.m_20184_().m_165924_()));
                vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82490_(0.15 * vehicle.targetSpeed * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue())));
            } else {
                vehicle.m_146926_(vehicle.m_146909_() * 0.99f);
            }
        }
        vehicle.setZRot(vehicle.getRoll() * 0.85f);
    }

    public static void helicopterEngine(VehicleEntity vehicle, EngineInfo.Helicopter engineInfo) {
        int energyCost = (int)engineInfo.energyCostRate;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float pitchSpeed = engineInfo.pitchSpeed;
        float yawSpeed = engineInfo.yawSpeed;
        float rollSpeed = engineInfo.rollSpeed;
        float lift = engineInfo.liftSpeed;
        if (vehicle.m_20096_()) {
            vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.8, 1.0, 0.8));
        } else {
            vehicle.setZRot(vehicle.getRoll() * (vehicle.backInputDown() ? 0.9f : 0.99f));
            float f = (float)Mth.m_14008_((double)((double)0.95f - 0.015 * vehicle.m_20184_().m_82553_() + (double)(0.02f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f)))) / 90.0f)), (double)0.01, (double)0.99);
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82490_((vehicle.m_146909_() < 0.0f ? -0.035 : (vehicle.m_146909_() > 0.0f ? 0.035 : 0.0)) * vehicle.m_20184_().m_82553_())));
            vehicle.m_20256_(vehicle.m_20184_().m_82542_((double)f, 0.95, (double)f));
        }
        if (vehicle.isInFluidType() && vehicle.f_19797_ % 4 == 0 && VehicleVecUtils.getSubmergedHeight(vehicle) > 0.5 * (double)vehicle.m_20206_()) {
            vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.6, 0.6, 0.6));
            vehicle.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(vehicle.m_9236_().m_9598_(), vehicle, vehicle.m_146895_() == null ? vehicle : vehicle.m_146895_()), 6.0f + (float)(20.0 * ((vehicle.lastTickSpeed - 0.4) * (vehicle.lastTickSpeed - 0.4))));
        }
        Entity pilot = vehicle.m_146895_();
        boolean hasPassenger = false;
        for (int i = 0; i < vehicle.getMaxPassengers() - 1; ++i) {
            if (vehicle.getNthEntity(i) == null) continue;
            hasPassenger = true;
        }
        if (vehicle.getHealth() > 0.1f * vehicle.getMaxHealth()) {
            Vec3 landingPos = VehicleEngineUtils.findNearestLandingPos(vehicle, 30);
            if (pilot == null) {
                vehicle.setLeftInputDown(false);
                vehicle.setRightInputDown(false);
                vehicle.setForwardInputDown(false);
                vehicle.setBackInputDown(false);
                vehicle.setUpInputDown(false);
                vehicle.setDownInputDown(false);
                vehicle.setZRot(vehicle.getRoll() * 0.98f);
                vehicle.m_146926_(vehicle.m_146909_() * 0.98f);
                vehicle.m_20184_().m_82542_(0.96, 0.98, 0.96);
                if (hasPassenger) {
                    vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.99f));
                }
            } else {
                if (!vehicle.backInputDown() || landingPos == null) {
                    if (vehicle.rightInputDown()) {
                        ++vehicle.holdTick;
                        vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() - 2.0f * (float)Math.min((int)vehicle.holdTick, (int)7) * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue()));
                    } else if (vehicle.leftInputDown()) {
                        ++vehicle.holdTick;
                        vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() + 2.0f * (float)Math.min((int)vehicle.holdTick, (int)7) * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue()));
                    } else {
                        vehicle.holdTick = 0;
                    }
                    vehicle.m_146926_(vehicle.m_146909_() + (vehicle.m_20096_() ? 0.0f : 1.5f) * pitchSpeed * vehicle.getMouseMoveSpeedY() * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PROPELLER_ROT)).floatValue());
                    vehicle.setZRot(vehicle.getRoll() - rollSpeed * (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() + (vehicle.m_20096_() ? 0.0f : 0.25f) * vehicle.getMouseMoveSpeedX() * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PROPELLER_ROT)).floatValue()));
                }
                vehicle.m_146922_(vehicle.m_146908_() + yawSpeed * Mth.m_14036_((float)((vehicle.m_20096_() ? 0.1f : 2.0f) * vehicle.getMouseMoveSpeedX() * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PROPELLER_ROT)).floatValue() + (float)((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.SUB_ENGINE_DAMAGED) != false ? 25 : 0) * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PROPELLER_ROT)).floatValue()), (float)-10.0f, (float)10.0f));
                if (landingPos != null && !vehicle.m_20096_() && vehicle.backInputDown()) {
                    VehicleEngineUtils.updateAutoLanding(vehicle, landingPos);
                }
                if (pilot instanceof Player) {
                    Player player = (Player)pilot;
                    if (vehicle.m_9236_().f_46443_ && landingPos != null && !vehicle.m_20096_()) {
                        player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.press_s_to_landing"), true);
                    }
                }
                if (vehicle.m_20096_()) {
                    vehicle.setZRot(vehicle.getRoll() * 0.98f);
                    vehicle.m_146926_(vehicle.m_146909_() * 0.98f);
                }
            }
            if (vehicle.getEnergy() > energyCost) {
                boolean up = vehicle.upInputDown() || vehicle.forwardInputDown();
                boolean down = vehicle.downInputDown();
                if (!vehicle.engineStart && up) {
                    vehicle.engineStart = true;
                    vehicle.m_9236_().m_6269_(null, (Entity)vehicle, engineInfo.engineStartSound, vehicle.m_5720_(), 3.0f, 1.0f);
                }
                if (up && vehicle.engineStartOver) {
                    ++vehicle.holdPowerTick;
                    vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() + 7.0E-4f * powerAdd * (float)Math.min((int)vehicle.holdPowerTick, (int)10)), (float)0.12f)));
                }
                if (vehicle.engineStartOver) {
                    if (down) {
                        ++vehicle.holdPowerTick;
                        vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - 0.001f * powerReduce * (float)Math.min((int)vehicle.holdPowerTick, (int)5)), (float)(vehicle.m_20096_() ? 0.0f : 0.025f / lift))));
                    } else if (vehicle.backInputDown()) {
                        ++vehicle.holdPowerTick;
                        vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - 0.001f * powerReduce * (float)Math.min((int)vehicle.holdPowerTick, (int)5)), (float)(vehicle.m_20096_() ? 0.0f : 0.058f / lift))));
                    }
                }
                if (vehicle.engineStart && !vehicle.engineStartOver) {
                    vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() + 0.0012f * powerAdd), (float)0.045f)));
                }
                if (!up && !down && !vehicle.backInputDown() && vehicle.engineStartOver) {
                    if (vehicle.m_20184_().m_7098_() < 0.0) {
                        vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() + 2.0E-4f), (float)0.12f)));
                    } else {
                        vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - (vehicle.m_20096_() ? 5.0E-5f : 2.0E-4f)), (float)0.0f)));
                    }
                    vehicle.holdPowerTick = 0;
                }
            } else {
                vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - 1.0E-4f), (float)0.0f)));
                vehicle.setForwardInputDown(false);
                vehicle.setBackInputDown(false);
                vehicle.engineStart = false;
                vehicle.engineStartOver = false;
            }
        } else if (!vehicle.m_20096_() && vehicle.engineStartOver) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - 3.0E-4f), (float)0.01f)));
            vehicle.destroyRot += 0.08f;
            float diffX = 45.0f - vehicle.m_146909_();
            float diffZ = -20.0f - vehicle.getRoll();
            vehicle.m_146926_(vehicle.m_146909_() + diffX * 0.05f * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PROPELLER_ROT)).floatValue());
            vehicle.m_146922_(vehicle.m_146908_() + vehicle.destroyRot);
            vehicle.setZRot(vehicle.getRoll() + diffZ * 0.1f * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PROPELLER_ROT)).floatValue());
            vehicle.m_20256_(vehicle.m_20184_().m_82520_(0.0, (double)(-vehicle.destroyRot) * 0.004, 0.0));
        }
        if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.MAIN_ENGINE_DAMAGED)).booleanValue()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.98f));
        }
        vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() * 0.9f));
        vehicle.m_20088_().m_135381_(VehicleEntity.PROPELLER_ROT, (Object)Float.valueOf(Mth.m_14179_((float)0.18f, (float)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PROPELLER_ROT)).floatValue(), (float)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue())));
        vehicle.setPropellerRot(vehicle.getPropellerRot() + 30.0f * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PROPELLER_ROT)).floatValue());
        vehicle.m_20088_().m_135381_(VehicleEntity.PROPELLER_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PROPELLER_ROT)).floatValue() * 0.9995f));
        if (vehicle.engineStart) {
            vehicle.consumeEnergy((int)((float)energyCost * 8.3333f * Mth.m_14154_((float)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue())));
        }
        Vec3 force = vehicle.getUpVec(1.0f);
        vehicle.m_20256_(vehicle.m_20184_().m_82549_(force.m_82490_((double)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PROPELLER_ROT)).floatValue() * lift))));
        if (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.04f) {
            vehicle.engineStartOver = true;
        }
        if (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() < 4.0E-4f) {
            vehicle.engineStart = false;
            vehicle.engineStartOver = false;
        }
    }

    public static void aircraftEngine(VehicleEntity vehicle, EngineInfo.Aircraft engineInfo) {
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float pitchSpeed = engineInfo.pitchSpeed;
        float yawSpeed = engineInfo.yawSpeed;
        float rollSpeed = engineInfo.rollSpeed;
        float lift = engineInfo.liftSpeed;
        float speedRate = engineInfo.speedRate;
        float gearRotateAngle = engineInfo.gearRotateAngle;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.m_14154_((float)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue()));
        float f = (float)Mth.m_14008_((double)(Math.max((double)((double)(vehicle.m_20096_() ? 0.819f : 0.82f) - 0.005 * vehicle.m_20184_().m_82553_()), (double)0.5) + (double)(0.001f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f)))) / 90.0f)), (double)0.01, (double)0.99);
        boolean forward = vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)) > 0.0;
        vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82490_((forward ? 0.227 : 0.1) * vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)))));
        vehicle.m_20256_(vehicle.m_20184_().m_82542_((double)f, (double)f, (double)f));
        if (vehicle.isInFluidType() && vehicle.f_19797_ % 4 == 0) {
            vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.6, 0.6, 0.6));
            if (vehicle.lastTickSpeed > 0.4) {
                vehicle.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(vehicle.m_9236_().m_9598_(), vehicle, vehicle.m_146895_() == null ? vehicle : vehicle.m_146895_()), (float)(20.0 * ((vehicle.lastTickSpeed - 0.4) * (vehicle.lastTickSpeed - 0.4))));
            }
        }
        Entity passenger = vehicle.m_146895_();
        if (vehicle.getHealth() > 0.1f * vehicle.getMaxHealth()) {
            if (passenger == null || vehicle.isInFluidType()) {
                vehicle.setLeftInputDown(false);
                vehicle.setRightInputDown(false);
                vehicle.setForwardInputDown(false);
                vehicle.setBackInputDown(false);
                vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.95f));
                if (vehicle.m_20096_()) {
                    vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.94, 1.0, 0.94));
                } else {
                    vehicle.m_146926_(Mth.m_14036_((float)(vehicle.m_146909_() + 0.1f), (float)-89.0f, (float)89.0f));
                }
            } else if (passenger instanceof Player) {
                if (vehicle.getEnergy() > energyCost) {
                    if (!vehicle.engineStart && vehicle.forwardInputDown()) {
                        vehicle.engineStart = true;
                        if (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f) {
                            vehicle.m_9236_().m_6269_(null, (Entity)vehicle, engineInfo.engineStartSound, vehicle.m_5720_(), 3.0f, 1.0f);
                        }
                    }
                    if (vehicle.forwardInputDown()) {
                        vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf((float)Mth.m_14008_((double)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() + 0.0045f * powerAdd), (double)-0.1, (double)1.0)));
                    }
                    if (vehicle.backInputDown()) {
                        vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - 0.006f * powerReduce), (float)(vehicle.m_20096_() ? -0.2f : 0.4f))));
                    }
                }
                if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
                    vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.995f));
                }
                if (!vehicle.m_20096_()) {
                    if (vehicle.rightInputDown()) {
                        vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() - 0.6f));
                    } else if (vehicle.leftInputDown()) {
                        vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() + 0.6f));
                    }
                }
                if (vehicle.downInputDown()) {
                    if (vehicle.m_20096_()) {
                        vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.92f));
                        vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.97, 1.0, 0.97));
                    } else {
                        vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.97f));
                        vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.994, 1.0, 0.994));
                    }
                    vehicle.m_20088_().m_135381_(VehicleEntity.PLANE_BREAK, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PLANE_BREAK)).floatValue() + 10.0f), (float)60.0f)));
                }
            }
            if (vehicle.engineStart) {
                vehicle.consumeEnergy(energyCost);
            }
            float rotSpeed = 1.5f + 1.2f * Mth.m_14154_((float)VectorTool.calculateY(vehicle.getRoll()));
            float addY = Mth.m_14036_((float)(Math.max((float)((vehicle.m_20096_() ? 0.6f : 0.2f) * (float)vehicle.m_20184_().m_82553_()), (float)0.0f) * vehicle.getMouseMoveSpeedX()), (float)(-rotSpeed), (float)rotSpeed);
            float addX = Mth.m_14036_((float)(Math.min((float)((float)Math.max((double)(vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)) - 0.24), (double)0.15)), (float)0.4f) * vehicle.getMouseMoveSpeedY()), (float)-3.5f, (float)3.5f);
            float addZ = ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() - (vehicle.m_20096_() ? 0.0f : 0.004f) * vehicle.getMouseMoveSpeedX() * (float)vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f));
            vehicle.m_146922_(vehicle.m_146908_() + yawSpeed * addY);
            if (!vehicle.m_20096_()) {
                vehicle.m_146926_(vehicle.m_146909_() + pitchSpeed * addX);
                vehicle.setZRot(vehicle.getRoll() - rollSpeed * addZ);
            }
            if (!vehicle.m_20096_()) {
                float xSpeed = 1.0f + 20.0f * Mth.m_14154_((float)(vehicle.m_146909_() / 180.0f));
                float speed = Mth.m_14036_((float)(Mth.m_14154_((float)vehicle.getRoll()) / (90.0f / xSpeed)), (float)0.0f, (float)1.0f);
                if (vehicle.getRoll() > 0.0f) {
                    vehicle.setZRot(vehicle.getRoll() - Math.min((float)speed, (float)vehicle.getRoll()));
                } else if (vehicle.getRoll() < 0.0f) {
                    vehicle.setZRot(vehicle.getRoll() + Math.min((float)speed, (float)(-vehicle.getRoll())));
                }
            }
            vehicle.setPropellerRot(vehicle.getPropellerRot() + 30.0f * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue());
            if (engineInfo.hasGear) {
                if (vehicle.upInputDown()) {
                    vehicle.setUpInputDown(false);
                    if (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.GEAR_ROT)).floatValue() == 0.0f && !vehicle.m_20096_()) {
                        vehicle.m_20088_().m_135381_(VehicleEntity.GEAR_UP, (Object)true);
                    } else if (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.GEAR_ROT)).floatValue() == 1.0f) {
                        vehicle.m_20088_().m_135381_(VehicleEntity.GEAR_UP, (Object)false);
                    }
                }
                if (vehicle.m_20096_()) {
                    vehicle.m_20088_().m_135381_(VehicleEntity.GEAR_UP, (Object)false);
                }
                if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.GEAR_UP)).booleanValue()) {
                    vehicle.m_20088_().m_135381_(VehicleEntity.GEAR_ROT, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.GEAR_ROT)).floatValue() + 0.05f), (float)1.0f)));
                } else {
                    vehicle.m_20088_().m_135381_(VehicleEntity.GEAR_ROT, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.GEAR_ROT)).floatValue() - 0.05f), (float)0.0f)));
                }
                vehicle.setGearRot(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.GEAR_ROT)).floatValue() * gearRotateAngle);
            }
            float flapX = (1.0f - Mth.m_14154_((float)vehicle.getRoll()) / 90.0f) * Mth.m_14036_((float)vehicle.getMouseMoveSpeedY(), (float)-22.5f, (float)22.5f) - VectorTool.calculateY(vehicle.getRoll()) * Mth.m_14036_((float)vehicle.getMouseMoveSpeedX(), (float)-22.5f, (float)22.5f);
            vehicle.setFlap1LRot(Mth.m_14036_((float)(-flapX - 4.0f * addZ - ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            vehicle.setFlap1RRot(Mth.m_14036_((float)(-flapX + 4.0f * addZ - ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            vehicle.setFlap1L2Rot(Mth.m_14036_((float)(-flapX - 4.0f * addZ + ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            vehicle.setFlap1R2Rot(Mth.m_14036_((float)(-flapX + 4.0f * addZ + ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            vehicle.setFlap2LRot(Mth.m_14036_((float)(flapX - 4.0f * addZ), (float)-22.5f, (float)22.5f));
            vehicle.setFlap2RRot(Mth.m_14036_((float)(flapX + 4.0f * addZ), (float)-22.5f, (float)22.5f));
            float flapY = (1.0f - Mth.m_14154_((float)vehicle.getRoll()) / 90.0f) * Mth.m_14036_((float)vehicle.getMouseMoveSpeedX(), (float)-22.5f, (float)22.5f) + VectorTool.calculateY(vehicle.getRoll()) * Mth.m_14036_((float)vehicle.getMouseMoveSpeedY(), (float)-22.5f, (float)22.5f);
            vehicle.setFlap3Rot(flapY * 5.0f);
        } else if (!vehicle.m_20096_()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - 3.0E-4f), (float)0.02f)));
            vehicle.destroyRot += 0.1f;
            float diffX = 90.0f - vehicle.m_146909_();
            vehicle.m_146926_(vehicle.m_146909_() + diffX * 0.001f * vehicle.destroyRot);
            vehicle.setZRot(vehicle.getRoll() - vehicle.destroyRot);
            vehicle.m_20256_(vehicle.m_20184_().m_82520_(0.0, -0.03, 0.0));
            vehicle.m_20256_(vehicle.m_20184_().m_82520_(0.0, (double)(-vehicle.destroyRot) * 0.005, 0.0));
        }
        vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() * 0.85f));
        vehicle.m_20088_().m_135381_(VehicleEntity.PLANE_BREAK, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.PLANE_BREAK)).floatValue() * 0.8f));
        if (vehicle.m_20096_()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.995f));
        }
        if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.MAIN_ENGINE_DAMAGED)).booleanValue()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        if (((Boolean)vehicle.m_20088_().m_135370_(VehicleEntity.SUB_ENGINE_DAMAGED)).booleanValue()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        double flapAngle = (vehicle.getFlap1LRot() + vehicle.getFlap1RRot() + vehicle.getFlap1L2Rot() + vehicle.getFlap1R2Rot()) / 4.0f;
        vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.getUpVec(1.0f).m_82490_(vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)) * 0.022 * (double)lift * (1.0 + Math.sin((double)((vehicle.m_20096_() ? 25.0 : flapAngle + 25.0) * 0.01745329238474369))))));
        vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82490_(0.03 * (double)speedRate * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * (vehicle.sprintInputDown() ? 2.2 : 1.0))));
        if (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.2f) {
            vehicle.engineStartOver = true;
        }
        if (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() < 4.0E-4f) {
            vehicle.engineStart = false;
            vehicle.engineStartOver = false;
        }
    }

    public static void tomEngine(VehicleEntity vehicle, EngineInfo.Tom6 engineInfo) {
        Entity passenger;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float pitchSpeed = engineInfo.pitchSpeed;
        float yawSpeed = engineInfo.yawSpeed;
        float rollSpeed = engineInfo.rollSpeed;
        float lift = engineInfo.liftSpeed;
        float speedRate = engineInfo.speedRate;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.m_14154_((float)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue()));
        float f = (float)Mth.m_14008_((double)(Math.max((double)((double)(vehicle.m_20096_() ? 0.819f : 0.82f) - 0.005 * vehicle.m_20184_().m_82553_()), (double)0.5) + (double)(0.001f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f)))) / 90.0f)), (double)0.01, (double)0.99);
        boolean forward = vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)) > 0.0;
        vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82490_((forward ? 0.227 : 0.1) * vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)))));
        vehicle.m_20256_(vehicle.m_20184_().m_82542_((double)f, (double)f, (double)f));
        if (vehicle.isInFluidType() && vehicle.f_19797_ % 4 == 0) {
            vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.6, 0.6, 0.6));
            if (vehicle.lastTickSpeed > 0.4) {
                vehicle.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(vehicle.m_9236_().m_9598_(), vehicle, vehicle.m_146895_() == null ? vehicle : vehicle.m_146895_()), (float)(20.0 * ((vehicle.lastTickSpeed - 0.4) * (vehicle.lastTickSpeed - 0.4))));
            }
        }
        if ((passenger = vehicle.m_146895_()) == null || vehicle.isInFluidType()) {
            vehicle.setLeftInputDown(false);
            vehicle.setRightInputDown(false);
            vehicle.setForwardInputDown(false);
            vehicle.setBackInputDown(false);
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.95f));
            if (vehicle.m_20096_()) {
                vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.94, 1.0, 0.94));
            } else {
                vehicle.m_146926_(Mth.m_14036_((float)(vehicle.m_146909_() + 0.1f), (float)-89.0f, (float)89.0f));
            }
        } else if (passenger instanceof Player) {
            if (vehicle.getEnergy() > energyCost) {
                if (!vehicle.engineStart && vehicle.forwardInputDown()) {
                    vehicle.engineStart = true;
                    if (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f) {
                        vehicle.m_9236_().m_6269_(null, (Entity)vehicle, engineInfo.engineStartSound, vehicle.m_5720_(), 3.0f, 1.0f);
                    }
                }
                if (vehicle.forwardInputDown()) {
                    vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf((float)Mth.m_14008_((double)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() + 0.045f * powerAdd), (double)-0.1, (double)1.0)));
                }
                if (vehicle.backInputDown()) {
                    if (vehicle.m_20096_()) {
                        vehicle.m_20256_(vehicle.m_20184_().m_82490_(0.97));
                    }
                    vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - 0.06f * powerReduce), (float)(vehicle.m_20096_() ? -0.6f : 0.2f))));
                }
            }
            float diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.m_14177_((float)(passenger.m_6080_() - vehicle.m_146908_())));
            float diffX = Math.clamp((float)-60.0f, (float)60.0f, (float)Mth.m_14177_((float)(passenger.m_146909_() - vehicle.m_146909_())));
            float roll = Mth.m_14154_((float)Mth.m_14036_((float)(vehicle.getRoll() / 60.0f), (float)-1.5f, (float)1.5f));
            float addY = Mth.m_14036_((float)(Math.min((float)((vehicle.m_20096_() ? 1.5f : 0.9f) * (float)Math.max((double)(vehicle.m_20184_().m_82553_() - 0.06), (double)0.1)), (float)0.9f) * diffY - 0.5f * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue()), (float)(-3.0f * (roll + 1.0f)), (float)(3.0f * (roll + 1.0f)));
            float addX = Mth.m_14036_((float)(Math.min((float)((float)Math.max((double)(vehicle.m_20184_().m_82553_() - 0.1), (double)0.01)), (float)0.9f) * diffX), (float)-4.0f, (float)4.0f);
            float addZ = ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() - (vehicle.m_20096_() ? 0.0f : 0.01f) * diffY * (float)vehicle.m_20184_().m_82553_();
            float i = vehicle.m_146909_() / 90.0f;
            float yRotSync = addY * (1.0f - Mth.m_14154_((float)i)) + addZ * i;
            vehicle.m_146922_(vehicle.m_146908_() + yRotSync * yawSpeed);
            vehicle.m_146926_(Mth.m_14036_((float)(vehicle.m_146909_() + addX * pitchSpeed), (float)(vehicle.m_20096_() ? -12.0f : -120.0f), (float)(vehicle.m_20096_() ? 3.0f : 120.0f)));
            vehicle.setZRot(vehicle.getRoll() - addZ * (1.0f - Mth.m_14154_((float)i)) * rollSpeed);
            if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
                vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.995f));
            }
            if (!vehicle.m_20096_()) {
                if (vehicle.rightInputDown()) {
                    vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() - 0.6f));
                } else if (vehicle.leftInputDown()) {
                    vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() + 0.6f));
                }
            }
        }
        vehicle.consumeEnergy(energyCost);
        if (!vehicle.m_20096_()) {
            float xSpeed = 1.0f + 20.0f * Mth.m_14154_((float)(vehicle.m_146909_() / 180.0f));
            float speed = Mth.m_14036_((float)(Mth.m_14154_((float)vehicle.getRoll()) / (90.0f / xSpeed)), (float)0.0f, (float)1.0f);
            if (vehicle.getRoll() > 0.0f) {
                vehicle.setZRot(vehicle.getRoll() - Math.min((float)speed, (float)vehicle.getRoll()));
            } else if (vehicle.getRoll() < 0.0f) {
                vehicle.setZRot(vehicle.getRoll() + Math.min((float)speed, (float)(-vehicle.getRoll())));
            }
        }
        vehicle.m_20088_().m_135381_(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.DELTA_ROT)).floatValue() * 0.85f));
        if (vehicle.m_20096_()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.995f));
        }
        vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.getUpVec(1.0f).m_82490_(vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)) * 0.022 * (double)lift * (double)(1.0f + Math.sin((float)((float)(vehicle.m_20096_() ? 25 : 30) * ((float)java.lang.Math.PI / 180)))))));
        vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82490_(0.02 * (double)speedRate * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * (vehicle.sprintInputDown() ? 2.2 : 1.0))));
    }

    public static void wheelChairEngine(VehicleEntity vehicle, EngineInfo.WheelChair engineInfo) {
        double buoyancy = engineInfo.buoyancy;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.m_14154_((float)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue()));
        double wheelRotSpeed = engineInfo.wheelRotSpeed;
        float wheelDifferential = (float)engineInfo.wheelDifferential;
        float maxForwardSpeedRate = engineInfo.maxForwardSpeedRate;
        float maxBackwardSpeedRate = engineInfo.maxBackwardSpeedRate;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float steeringSpeed = engineInfo.steeringSpeed;
        float bodyRollRate = (float)engineInfo.bodyRollRate;
        int jumpEnergyCost = engineInfo.jumpEnergyCost;
        if (buoyancy != 0.0) {
            double fluidFloat = buoyancy * VehicleVecUtils.getSubmergedHeight(vehicle);
            vehicle.m_20256_(vehicle.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        }
        if (vehicle.m_20096_()) {
            float f0 = 0.63f + 0.25f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f)))) / 90.0f;
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82541_().m_82490_(0.05 * vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)))));
            vehicle.m_20256_(vehicle.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else if (vehicle.isInFluidType()) {
            float f1 = 0.74f + 0.09f * Mth.m_14154_((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f)))) / 90.0f;
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82541_().m_82490_(0.04 * vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f)))));
            vehicle.m_20256_(vehicle.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        } else {
            vehicle.m_20256_(vehicle.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        vehicle.m_6858_(vehicle.m_20184_().m_165924_() > 0.15);
        Entity passenger0 = vehicle.m_146895_();
        float diffY = 0.0f;
        if (passenger0 == null) {
            vehicle.setLeftInputDown(false);
            vehicle.setRightInputDown(false);
            vehicle.setForwardInputDown(false);
            vehicle.setBackInputDown(false);
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(0.0f));
        } else {
            diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.m_14177_((float)(passenger0.m_6080_() - vehicle.m_146908_())));
            vehicle.m_146922_(vehicle.m_146908_() + Mth.m_14036_((float)(0.4f * diffY), (float)(-5.0f * steeringSpeed), (float)(5.0f * steeringSpeed)));
            float direct = (90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.m_20184_(), vehicle.m_20252_(1.0f))) / 90.0f;
            vehicle.setZRot((float)((double)vehicle.getRoll() + (double)(direct * diffY) * 0.1 * (double)bodyRollRate * vehicle.m_20184_().m_82553_()));
        }
        if (vehicle.forwardInputDown()) {
            if (vehicle.getEnergy() <= 0 && passenger0 instanceof Player) {
                Player player = (Player)passenger0;
                VehicleEngineUtils.moveWithOutPower(vehicle, player, true);
            } else {
                vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() + (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() < 0.0f ? powerAdd * 2.0f : powerAdd)), (float)(vehicle.sprintInputDown() ? 2.0f : 1.0f))));
            }
        }
        if (vehicle.backInputDown()) {
            if (vehicle.getEnergy() <= 0 && passenger0 instanceof Player) {
                Player player = (Player)passenger0;
                VehicleEngineUtils.moveWithOutPower(vehicle, player, false);
            } else {
                vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() - (((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f ? powerReduce * 2.0f : powerReduce)), (float)-1.0f)));
            }
        }
        vehicle.targetSpeed = ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() > 0.0f ? (double)(maxForwardSpeedRate * (1.0f + vehicle.m_146909_() / 55.0f)) : (double)(maxBackwardSpeedRate * (1.0f - vehicle.m_146909_() / 55.0f));
        if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
            vehicle.m_20088_().m_135381_(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        if (vehicle.upInputDown() && vehicle.m_20096_() && vehicle.getEnergy() > jumpEnergyCost && vehicle.jumpCoolDown == 0 && engineInfo.canJump) {
            if (passenger0 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)passenger0;
                serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), (SoundEvent)ModSounds.WHEEL_CHAIR_JUMP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            vehicle.consumeEnergy(jumpEnergyCost);
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.getUpVec(1.0f).m_82490_(engineInfo.jumpForce)));
            vehicle.jumpCoolDown = engineInfo.jumpCoolDown;
        }
        if (vehicle.m_9236_() instanceof ServerLevel) {
            vehicle.consumeEnergy(energyCost);
        }
        double s0 = vehicle.m_20184_().m_82526_(vehicle.m_20252_(1.0f));
        vehicle.setLeftWheelRot((float)((double)vehicle.getLeftWheelRot() - 1.25 * wheelRotSpeed * s0) - 0.015f * wheelDifferential * Mth.m_14036_((float)(0.4f * diffY), (float)-5.0f, (float)5.0f));
        vehicle.setRightWheelRot((float)((double)vehicle.getRightWheelRot() - 1.25 * wheelRotSpeed * s0) + 0.015f * wheelDifferential * Mth.m_14036_((float)(0.4f * diffY), (float)-5.0f, (float)5.0f));
        if (vehicle.isInFluidType() || vehicle.m_20096_()) {
            double water = !vehicle.isInFluidType() && !vehicle.m_20096_() ? 0.05f : (vehicle.isInFluidType() && !vehicle.m_20096_() ? 0.3f : 1.0f);
            vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82490_(0.08 * water * vehicle.targetSpeed * (double)((Float)vehicle.m_20088_().m_135370_(VehicleEntity.POWER)).floatValue())));
        }
    }

    public static void moveWithOutPower(VehicleEntity vehicle, Player player, boolean forward) {
        vehicle.m_20256_(vehicle.m_20184_().m_82549_(vehicle.m_20252_(1.0f).m_82490_(forward ? (double)0.1f : (double)-0.1f)));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11706_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        player.m_36399_(0.03f);
        vehicle.setForwardInputDown(false);
        vehicle.setBackInputDown(false);
    }

    public static Vec3 findNearestLandingPos(VehicleEntity entity, int radius) {
        Level world = entity.m_9236_();
        BlockPos entityPos = entity.m_20183_();
        ArrayList<BlockPos> landingBlocks = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= 0; ++y) {
                    BlockPos checkPos;
                    if (x * x + y * y + z * z > radius * radius || !world.m_8055_(checkPos = entityPos.m_7918_(x, y, z)).m_204336_(ModTags.Blocks.AUTO_LANDING)) continue;
                    landingBlocks.add(checkPos);
                }
            }
        }
        if (landingBlocks.isEmpty()) {
            return null;
        }
        landingBlocks.sort(Comparator.comparingDouble(pos -> entity.m_20182_().m_82531_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5)));
        return ((BlockPos)landingBlocks.get(0)).m_252807_();
    }

    public static void updateAutoLanding(VehicleEntity entity, Vec3 landingTarget) {
        Vec3 currentPos = entity.m_20182_();
        Vec3 horizontalOffset = new Vec3(landingTarget.f_82479_ - currentPos.f_82479_, 0.0, landingTarget.f_82481_ - currentPos.f_82481_);
        entity.m_20256_(entity.m_20184_().m_82542_(0.975, 0.99, 0.975));
        double horizontalDistance = horizontalOffset.m_82553_();
        Vec3 horizontalDirection = horizontalDistance > 0.0 ? horizontalOffset.m_82541_() : Vec3.f_82478_;
        float tiltSmoothingFactor = 0.1f;
        double horizontalDistanceNew = horizontalDistance - 5.0 * entity.m_20184_().m_165924_();
        float maxTiltAngle = 15.0f;
        float targetTilt = (float)Math.min((double)maxTiltAngle, (double)(horizontalDistanceNew * 2.0));
        float yawRad = Math.toRadians((float)(-entity.m_146908_()));
        Vec3 localDirection = new Vec3(horizontalDirection.f_82479_ * (double)Math.cos((float)yawRad) - horizontalDirection.f_82481_ * (double)Math.sin((float)yawRad), 0.0, horizontalDirection.f_82479_ * (double)Math.sin((float)yawRad) + horizontalDirection.f_82481_ * (double)Math.cos((float)yawRad));
        float targetXRot = (float)(-localDirection.f_82481_ * (double)targetTilt);
        float targetZRot = (float)(localDirection.f_82479_ * (double)targetTilt);
        entity.m_146926_(VehicleEngineUtils.lerpAngle(entity.m_146909_(), -targetXRot, tiltSmoothingFactor));
        entity.setZRot(VehicleEngineUtils.lerpAngle(entity.getRoll(), -targetZRot, tiltSmoothingFactor));
    }

    public static float lerpAngle(float current, float target, float factor) {
        float diff;
        for (diff = target - current; diff < -180.0f; diff += 360.0f) {
        }
        while (diff > 180.0f) {
            diff -= 360.0f;
        }
        return current + diff * factor;
    }
}

