/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.SeekInfo;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.world.TDMSavedData;
import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class AutoAimableEntity
extends GeoVehicleEntity
implements OwnableEntity {
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(AutoAimableEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(AutoAimableEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.m_135353_(AutoAimableEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public int changeTargetTimer;

    public AutoAimableEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (player.m_6047_()) {
            if (stack.m_204117_(ModTags.Items.TOOLS_CROWBAR) && (this.m_269323_() == null || player == this.m_269323_())) {
                ItemStack container = ContainerBlockItem.createInstance(this);
                if (!player.m_36356_(container)) {
                    player.m_36176_(container, false);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.m_146870_();
                return InteractionResult.SUCCESS;
            }
            if (this.m_21805_() == null) {
                this.setOwnerUUID(player.m_20148_());
            }
            if (this.m_269323_() == player) {
                this.f_19804_.m_135381_(ACTIVE, (Object)((Boolean)this.f_19804_.m_135370_(ACTIVE) == false ? 1 : 0));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            return InteractionResult.PASS;
        }
        this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
        return super.m_6096_(player, hand);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_UUID, (Object)"none");
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Active", ((Boolean)this.f_19804_.m_135370_(ACTIVE)).booleanValue());
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ACTIVE, (Object)compound.m_128471_("Active"));
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            try {
                uuid = this.m_20194_() == null ? UUID.fromString(s) : OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        this.autoAim();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void autoAim() {
        int changeTargetTime;
        block16: {
            block15: {
                block17: {
                    LivingEntity living;
                    LivingEntity livingEntity;
                    Entity target;
                    Entity nearestEntity;
                    if (this.m_146895_() != null || !((Boolean)this.f_19804_.m_135370_(ACTIVE)).booleanValue()) {
                        return;
                    }
                    String weaponName = "Main";
                    GunData data = this.getGunData(weaponName);
                    if (data == null) {
                        return;
                    }
                    SeekInfo seekInfo = this.data().compute().seekInfo;
                    if (seekInfo == null) {
                        return;
                    }
                    double maxSeekRange = seekInfo.maxSeekRange;
                    double minSeekRange = seekInfo.minSeekRange;
                    changeTargetTime = seekInfo.changeTargetTime;
                    int seekIterative = Math.max((int)1, (int)seekInfo.seekIterative);
                    double minTargetSize = seekInfo.minTargetSize;
                    if (this.getEnergy() < seekInfo.seekEnergyCost) {
                        return;
                    }
                    ProjectileInfo projectileInfo = data.compute().projectile();
                    String projectileType = projectileInfo.type;
                    String projectileTypeStr = projectileType.trim().toLowerCase(Locale.ROOT);
                    int rpm = (int)Math.ceil((float)(20.0f / ((float)this.vehicleWeaponRpm(weaponName) / 60.0f)));
                    if (projectileTypeStr.equals("ray") && ((Float)this.f_19804_.m_135370_(CHARGE_PROGRESS)).floatValue() < 1.0f && this.getEnergy() > data.compute().ammoCostPerShoot) {
                        float chargeSpeed = 1.0f / (float)rpm;
                        this.f_19804_.m_135381_(CHARGE_PROGRESS, (Object)Float.valueOf(Mth.m_14036_((float)(((Float)this.f_19804_.m_135370_(CHARGE_PROGRESS)).floatValue() + chargeSpeed), (float)0.0f, (float)1.0f)));
                    }
                    Vec3 barrelRootPos = this.getShootPos(weaponName, 1.0f);
                    if (((String)this.f_19804_.m_135370_(TARGET_UUID)).equals("none") && this.f_19797_ % seekIterative == 0 && (nearestEntity = this.seekNearLivingEntity(barrelRootPos, this.getTurretMinPitch(), this.getTurretMaxPitch(), minSeekRange, maxSeekRange, minTargetSize)) != null) {
                        this.f_19804_.m_135381_(TARGET_UUID, (Object)nearestEntity.m_20149_());
                        this.consumeEnergy(seekInfo.seekEnergyCost);
                    }
                    if ((target = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(TARGET_UUID))) == null || !((livingEntity = this.m_269323_()) instanceof Player)) break block15;
                    Player player = (Player)livingEntity;
                    if (!SeekTool.NOT_IN_SMOKE.test(target)) break block15;
                    if (SeekTool.IS_INVULNERABLE.test(target) || VehicleVecUtils.getSubmergedHeight(target) >= (double)target.m_20206_() || (double)target.m_20270_((Entity)this) > maxSeekRange || (double)target.m_20270_((Entity)this) < minSeekRange || target instanceof LivingEntity && (living = (LivingEntity)target).m_21223_() <= 0.0f || target == this || target instanceof TargetEntity || target.m_20069_() || target instanceof Projectile && (target.m_20096_() || target.m_20184_().m_82556_() < 0.001)) {
                        this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                        return;
                    }
                    if (target.m_20202_() != null) {
                        this.f_19804_.m_135381_(TARGET_UUID, (Object)target.m_20202_().m_20149_());
                    }
                    if (!target.m_6084_()) {
                        this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                    }
                    Vec3 targetPos = target.m_20191_().m_82399_();
                    Vec3 targetVel = target.m_20184_();
                    Vec3 targetVec = projectileTypeStr.equals("ray") ? barrelRootPos.m_82505_(targetPos).m_82541_() : RangeTool.calculateFiringSolution(barrelRootPos, targetPos, targetVel.m_82490_(1.1 + (double)(this.f_19796_.m_188501_() * 0.2f)), this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName));
                    if (((Float)this.f_19804_.m_135370_(LASER_SCALE)).floatValue() != 0.0f) break block16;
                    this.turretAutoAimFromVector(targetVec);
                    if (!(VectorTool.calculateAngle(this.getShootVec(weaponName, 1.0f), targetVec) < 1.0)) break block16;
                    if (!this.checkNoClip(target, barrelRootPos) || data.overHeat.get()) break block17;
                    if (projectileTypeStr.equals("ray") && ((Float)this.m_20088_().m_135370_(CHARGE_PROGRESS)).floatValue() == 1.0f) {
                        if (player.m_9236_() instanceof ServerLevel) {
                            this.rayShoot((LivingEntity)player, target, data);
                        }
                        this.changeTargetTimer = 0;
                        break block16;
                    } else if (this.getAmmoCount(weaponName) > 0 && this.f_19797_ % rpm == 0) {
                        if (player.m_9236_() instanceof ServerLevel) {
                            this.vehicleShoot((LivingEntity)player, "Main");
                        }
                        this.changeTargetTimer = 0;
                    }
                    break block16;
                }
                ++this.changeTargetTimer;
                break block16;
            }
            this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
        }
        if (this.changeTargetTimer > changeTargetTime) {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
            this.changeTargetTimer = 0;
        }
    }

    public boolean basicEnemyFilter(Entity pEntity) {
        if (pEntity instanceof Projectile) {
            return false;
        }
        if (this.m_269323_() == null) {
            return false;
        }
        if (pEntity.m_5647_() == null) {
            return false;
        }
        return !pEntity.m_7307_((Entity)this.m_269323_()) || pEntity.m_5647_() != null && TDMSavedData.enabledTDM(pEntity);
    }

    public boolean basicEnemyProjectileFilter(Projectile projectile) {
        if (this.m_269323_() == null) {
            return false;
        }
        if (projectile.m_19749_() != null && projectile.m_19749_() == this.m_269323_()) {
            return false;
        }
        return projectile.m_19749_() != null && !projectile.m_19749_().m_7307_((Entity)this.m_269323_()) || projectile.m_19749_() != null && projectile.m_19749_().m_5647_() != null && TDMSavedData.enabledTDM(projectile.m_19749_()) || projectile.m_19749_() == null;
    }

    public Entity seekNearLivingEntity(Vec3 pos, double minAngle, double maxAngle, double minRange, double seekRange, double size) {
        for (Entity target : this.m_9236_().m_6443_(Entity.class, new AABB(pos, pos).m_82400_(seekRange), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.m_20238_(pos))).toList()) {
            LivingEntity living;
            Player player;
            boolean condition = target.m_20280_((Entity)this) > minRange * minRange && target.m_20280_((Entity)this) <= seekRange * seekRange && AutoAimableEntity.canAim(pos, target, minAngle, maxAngle) && VehicleVecUtils.getSubmergedHeight(target) <= (double)target.m_20206_() && this.checkNoClip(target, pos) && (!(target instanceof Player) || !(player = (Player)target).m_5833_() && !player.m_7500_()) && (target instanceof LivingEntity && (living = (LivingEntity)target) instanceof Enemy && living.m_21223_() > 0.0f || this.isThreateningEntity(target, size, pos) || this.basicEnemyFilter(target)) && SeekTool.NOT_IN_SMOKE.test(target) && !SeekTool.IN_BLACKLIST.test(target);
            if (!condition) continue;
            return target;
        }
        return null;
    }

    public boolean isThreateningEntity(Entity target, double size, Vec3 pos) {
        if (target instanceof SmallCannonShellEntity) {
            return false;
        }
        if (!target.m_20096_() && target instanceof Projectile) {
            Projectile projectile = (Projectile)target;
            if ((double)target.m_20205_() >= size || (double)target.m_20206_() >= size) {
                return this.checkNoClip(target, pos) && this.basicEnemyProjectileFilter(projectile);
            }
        }
        return false;
    }

    public boolean checkNoClip(Entity target, Vec3 pos) {
        return this.m_9236_().m_45547_(new ClipContext(pos, target.m_20191_().m_82399_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this)).m_6662_() != HitResult.Type.BLOCK;
    }

    public static boolean canAim(Vec3 pos, Entity target, double minAngle, double maxAngle) {
        Vec3 targetPos = target.m_20191_().m_82399_();
        Vec3 toVec = pos.m_82505_(targetPos).m_82541_();
        double targetAngle = VehicleVecUtils.getXRotFromVector(toVec);
        return minAngle < targetAngle && targetAngle < maxAngle;
    }

    public void rayShoot(LivingEntity living, Entity target, GunData gunData) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123810_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 12, 0.0, 0.0, 0.0, 0.05, true);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123756_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 4, 0.0, 0.0, 0.0, 0.15, true);
        }
        Vec3 pos = target.m_20191_().m_82399_();
        this.f_19804_.m_135381_(LASER_LENGTH, (Object)Float.valueOf((float)this.getShootPos("Main", 1.0f).m_82554_(pos)));
        DamageHandler.doDamage(target, ModDamageTypes.causeLaserStaticDamage(this.m_9236_().m_9598_(), this, (Entity)living), (float)gunData.compute().damage);
        target.f_19802_ = 0;
        if (gunData.compute().explosionRadius > 0.0) {
            this.causeLaserExplode(pos, gunData, (Entity)living);
        }
        if (Math.random() < 0.25 && target instanceof LivingEntity) {
            LivingEntity pLiving = (LivingEntity)target;
            pLiving.m_20254_(2);
        }
        if (target instanceof Projectile && !(target instanceof DestroyableProjectile)) {
            this.causeAirExplode(pos);
            target.m_146870_();
        }
        if (!target.m_6084_()) {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
        }
        this.f_19804_.m_135381_(LASER_SCALE, (Object)Float.valueOf(gunData.compute().shootAnimationTime));
        this.f_19804_.m_135381_(CHARGE_PROGRESS, (Object)Float.valueOf(0.0f));
        this.playShootSound3p(living, "Main");
        this.consumeEnergy(gunData.compute().ammoCostPerShoot);
    }

    private void causeLaserExplode(Vec3 vec3, GunData gunData, Entity living) {
        float radius = (float)gunData.compute().explosionRadius;
        ParticleTool.ParticleType particleType = radius <= 4.0f ? ParticleTool.ParticleType.SMALL : (radius > 4.0f && radius < 10.0f ? ParticleTool.ParticleType.MEDIUM : (radius >= 10.0f && radius < 20.0f ? ParticleTool.ParticleType.HUGE : ParticleTool.ParticleType.GIANT));
        this.createCustomExplosion().damage((float)gunData.compute().explosionDamage).radius(radius).attacker(living).position(vec3).withParticleType(particleType).explode();
    }

    private void causeAirExplode(Vec3 vec3) {
        this.createCustomExplosion().damage(5.0f).radius(1.0f).keepBlock().attacker((Entity)this.m_269323_()).position(vec3).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
    }
}

