/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Yx100Entity
extends GeoVehicleEntity {
    public Yx100Entity(EntityType<Yx100Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.3f) * damage.floatValue()));
    }

    private PlayState cannonFirePredicate(AnimationState<Yx100Entity> event) {
        if (this.getShootAnimationTimer(0, 0) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.yx_100.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx_100.idle"));
    }

    private PlayState coaxFirePredicate(AnimationState<Yx100Entity> event) {
        if (this.getShootAnimationTimer(0, 1) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.yx_100.fire_coax"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx_100.idle_coax"));
    }

    private PlayState passengerWeaponStationFirePredicate(AnimationState<Yx100Entity> event) {
        if (this.getShootAnimationTimer(1, 0) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.yx_100.fire_weapon_station"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx_100.idle_weapon_station"));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "cannon", 0, this::cannonFirePredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "coax", 0, this::coaxFirePredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "passengerWeaponStation", 0, this::passengerWeaponStationFirePredicate)});
    }

    @Override
    public int getTrackAnimationLength() {
        return 80;
    }

    @Override
    public float getTurretMaxHealth() {
        return 100.0f;
    }

    @Override
    public float getWheelMaxHealth() {
        return 100.0f;
    }

    @Override
    public float getEngineMaxHealth() {
        return 150.0f;
    }
}

