/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RpgRocketTBGEntity
extends FastThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RpgRocketTBGEntity(EntityType<? extends RpgRocketTBGEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
        this.durability = 20;
        this.damage = 250.0f;
        this.explosionDamage = 200.0f;
        this.explosionRadius = 10.0f;
        this.gravity = 0.03f;
    }

    public RpgRocketTBGEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel, float damage, float explosionDamage, float explosionRadius) {
        super(pEntityType, pX, pY, pZ, pLevel);
        this.f_19811_ = true;
        this.durability = 20;
        this.damage = damage;
        this.explosionDamage = explosionDamage;
        this.explosionRadius = explosionRadius;
        this.gravity = 0.03f;
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.RPG_ROCKET_TBG.get();
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            BlockPos resultPos = blockHitResult.m_82425_();
            float hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_();
            if (hardness != -1.0f) {
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                    if (this.firstHit) {
                        this.causeExplode(blockHitResult.m_82450_());
                        this.firstHit = false;
                        Mod.queueServerWork(3, () -> ((RpgRocketTBGEntity)this).m_146870_());
                    }
                    if (((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
                        this.m_9236_().m_46961_(resultPos, true);
                    }
                }
            } else {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
            if (!((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
        }
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (this.m_19749_() != null && this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        if (this.m_9236_() instanceof ServerLevel) {
            LivingEntity living;
            if (entity == this.m_19749_() || this.m_19749_() != null && entity == this.m_19749_().m_20202_()) {
                return;
            }
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            DamageHandler.doDamage(entity, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
            if (entity instanceof LivingEntity) {
                entity.f_19802_ = 0;
            }
            this.causeExplode(result.m_82450_());
            this.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        Level level;
        super.m_8119_();
        this.mediumTrail();
        if (this.f_19797_ == 3 && !this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, this.f_19854_, this.f_19855_, this.f_19856_, 15, 0.8, 0.8, 0.8, 0.01, true);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, this.f_19854_, this.f_19855_, this.f_19856_, 10, 0.8, 0.8, 0.8, 0.01, true);
        }
        if (this.f_19797_ > 2) {
            this.m_20256_(this.m_20184_().m_82542_(1.03, 1.03, 1.03));
        }
        if (this.f_19797_ > 100 || this.m_20069_()) {
            if (this.m_9236_() instanceof ServerLevel) {
                ProjectileTool.causeCustomExplode(this, this.explosionDamage, this.explosionRadius);
            }
            this.m_146870_();
        }
        this.destroyBlock();
    }

    private PlayState movementPredicate(AnimationState<RpgRocketTBGEntity> event) {
        if (this.m_20184_().m_82556_() > 0.0) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.rpg.idle"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.rpg.none"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean shouldSyncMotion() {
        return true;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.ROCKET_FLY.get();
    }
}

