/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.client.particle.CustomSmokeOption;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.SmokeDecoyEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class M18SmokeGrenadeEntity
extends FastThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int count = 8;
    private int fuse = 100;
    private float rColor = 1.0f;
    private float gColor = 1.0f;
    private float bColor = 1.0f;

    public M18SmokeGrenadeEntity(EntityType<? extends M18SmokeGrenadeEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public M18SmokeGrenadeEntity(EntityType<? extends M18SmokeGrenadeEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.f_19811_ = true;
    }

    public M18SmokeGrenadeEntity(LivingEntity entity, Level level, int fuse) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.M18_SMOKE_GRENADE.get()), (Entity)entity, level);
        this.f_19811_ = true;
        this.fuse = fuse;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("Fuse", (float)this.fuse);
        pCompound.m_128405_("Count", this.count);
        pCompound.m_128350_("RColor", this.rColor);
        pCompound.m_128350_("GColor", this.gColor);
        pCompound.m_128350_("BColor", this.bColor);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Fuse")) {
            this.fuse = pCompound.m_128451_("Fuse");
        }
        if (pCompound.m_128441_("Count")) {
            this.count = Mth.m_14045_((int)pCompound.m_128451_("Count"), (int)1, (int)64);
        }
        if (pCompound.m_128441_("RColor")) {
            this.rColor = pCompound.m_128457_("RColor");
        }
        if (pCompound.m_128441_("GColor")) {
            this.gColor = pCompound.m_128457_("GColor");
        }
        if (pCompound.m_128441_("BColor")) {
            this.bColor = pCompound.m_128457_("BColor");
        }
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.M18_SMOKE_GRENADE.get();
    }

    protected void m_6532_(HitResult result) {
        switch (result.m_6662_()) {
            case BLOCK: {
                BlockHitResult blockResult = (BlockHitResult)result;
                BlockPos resultPos = blockResult.m_82425_();
                BlockState state = this.m_9236_().m_8055_(resultPos);
                SoundEvent event = state.m_60734_().getSoundType(state, (LevelReader)this.m_9236_(), resultPos, (Entity)this).m_56775_();
                double speed = this.m_20184_().m_82553_();
                if (speed > 0.1) {
                    this.m_9236_().m_6263_(null, result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_, event, SoundSource.AMBIENT, 1.0f, 1.0f);
                }
                this.bounce(blockResult.m_82434_());
                Block block = state.m_60734_();
                if (!(block instanceof BellBlock)) break;
                BellBlock bell = (BellBlock)block;
                bell.m_49712_(this.m_9236_(), resultPos, blockResult.m_82434_());
                break;
            }
            case ENTITY: {
                EntityHitResult entityResult = (EntityHitResult)result;
                Entity entity = entityResult.m_82443_();
                if (entity == this.m_19749_() || entity == this.m_20202_()) {
                    return;
                }
                double speed_e = this.m_20184_().m_82553_();
                if (speed_e > 0.1) {
                    LivingEntity living;
                    Entity entity2 = this.m_19749_();
                    if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)living;
                        living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                        NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
                    }
                    entity.m_6469_(entity.m_269291_().m_269390_((Entity)this, this.m_19749_()), 1.0f);
                }
                this.bounce(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
                this.m_20256_(this.m_20184_().m_82542_(0.25, 1.0, 0.25));
                break;
            }
        }
    }

    private void bounce(Direction direction) {
        switch (direction.m_122434_()) {
            case X: {
                this.m_20256_(this.m_20184_().m_82542_(-0.5, 0.75, 0.75));
                break;
            }
            case Y: {
                this.m_20256_(this.m_20184_().m_82542_(0.75, -0.25, 0.75));
                if (!(this.m_20184_().m_7098_() < (double)this.m_7139_())) break;
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
                break;
            }
            case Z: {
                this.m_20256_(this.m_20184_().m_82542_(0.75, 0.75, -0.5));
            }
        }
    }

    @Override
    public void m_8119_() {
        ServerLevel serverLevel;
        Level level;
        super.m_8119_();
        --this.fuse;
        if (this.f_19797_ > 200) {
            this.m_146870_();
        }
        if (this.fuse == -20) {
            this.releaseSmoke();
        }
        if (this.fuse == 0) {
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.SM0KE_GRENADE_RELEASE.get(), this.m_5720_(), 2.0f, 1.0f);
        }
        if (this.fuse <= 0 && this.f_19797_ % 2 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, new CustomSmokeOption(this.rColor, this.gColor, this.bColor), this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), 8, 0.075, 0.01, 0.075, 0.08, true);
        }
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123762_, this.f_19854_, this.f_19855_, this.f_19856_, 1, 0.0, 0.0, 0.0, 0.01, true);
        }
    }

    public void releaseSmoke() {
        Vec3 vec3 = new Vec3(1.0, 0.05, 0.0);
        for (int i = 0; i < this.count; ++i) {
            SmokeDecoyEntity decoy = new SmokeDecoyEntity((EntityType<? extends SmokeDecoyEntity>)((EntityType)ModEntities.SMOKE_DECOY.get()), this.m_9236_(), false);
            decoy.m_6034_(this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_());
            decoy.decoyShoot((Entity)this, vec3.m_82524_((float)i * (360.0f / (float)this.count) * ((float)Math.PI / 180)), 1.5f, 5.0f);
            this.m_9236_().m_7967_((Entity)decoy);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public float m_7139_() {
        return 0.07f;
    }

    public float getRed() {
        return this.rColor;
    }

    public float getGreen() {
        return this.gColor;
    }

    public float getBlue() {
        return this.bColor;
    }

    public M18SmokeGrenadeEntity setColor(float r, float g, float b) {
        this.rColor = r;
        this.gColor = g;
        this.bColor = b;
        return this;
    }

    @Override
    public boolean isFastMoving() {
        return false;
    }
}

