/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.AbstractLaserEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LaserEntity
extends AbstractLaserEntity {
    public static final double RADIUS = 512.0;

    public LaserEntity(EntityType<? extends LaserEntity> type, Level level) {
        super(type, level, 1);
    }

    public LaserEntity(Level level, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration) {
        super((EntityType)ModEntities.LASER.get(), level, 1);
        this.caster = caster;
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setDuration(duration);
        this.m_6034_(x, y, z);
        this.calculateEndPos(512.0);
        if (!this.m_9236_().f_46443_) {
            this.setCasterId(caster.m_19879_());
        }
    }

    @Override
    public void beamTick() {
        if (!this.m_9236_().f_46443_) {
            if (this.caster instanceof Player) {
                this.updateWithPlayer();
            } else if (this.caster != null) {
                this.updateWithEntity(0.0f, 0.75f);
            }
        }
        if (this.caster != null) {
            this.yaw = (float)Math.toRadians(this.caster.f_20885_ + 90.0f);
            this.pitch = (float)(-Math.toRadians(this.caster.m_146909_()));
        }
        if (this.f_19797_ >= this.getCountDown()) {
            this.calculateEndPos(512.0);
            this.raytraceEntities(this.m_9236_(), new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(this.endPosX, this.endPosY, this.endPosZ));
            if (this.blockSide != null) {
                this.spawnExplosionParticles();
            }
        }
    }

    @Override
    public AbstractLaserEntity.CustomHitResult raytraceEntities(Level world, Vec3 from, Vec3 to) {
        AbstractLaserEntity.CustomHitResult result = new AbstractLaserEntity.CustomHitResult();
        result.setBlockHit((HitResult)this.m_9236_().m_45547_(new ClipContext(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(this.endPosX, this.endPosY, this.endPosZ), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.getBlockHit() != null) {
            Vec3 hitVec = result.getBlockHit().m_82450_();
            this.collidePosX = hitVec.f_82479_;
            this.collidePosY = hitVec.f_82480_;
            this.collidePosZ = hitVec.f_82481_;
            this.blockSide = result.getBlockHit().m_82434_();
        } else {
            List entities = world.m_45976_(LivingEntity.class, new AABB(Math.min(this.m_20185_(), this.collidePosX), Math.min(this.m_20186_(), this.collidePosY), Math.min(this.m_20189_(), this.collidePosZ), Math.max(this.m_20185_(), this.collidePosX), Math.max(this.m_20186_(), this.collidePosY), Math.max(this.m_20189_(), this.collidePosZ)).m_82377_(1.0, 1.0, 1.0));
            for (LivingEntity entity : entities) {
                if (entity == this.caster) continue;
                float pad = entity.m_6143_() + this.getBaseScale();
                AABB aabb = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
                Optional hit = aabb.m_82371_(from, to);
                if (aabb.m_82390_(from)) {
                    result.addEntityHit(entity);
                    continue;
                }
                if (!hit.isPresent()) continue;
                result.addEntityHit(entity);
            }
            Optional<LivingEntity> target = result.getEntities().stream().min(Comparator.comparingDouble(e -> e.m_20280_((Entity)this.caster)));
            if (target.isPresent()) {
                this.collidePosX = target.get().m_20185_();
                this.collidePosY = target.get().m_20186_();
                this.collidePosZ = target.get().m_20189_();
            } else {
                this.collidePosX = this.endPosX;
                this.collidePosY = this.endPosY;
                this.collidePosZ = this.endPosZ;
            }
            this.blockSide = null;
        }
        return result;
    }

    public void spawnExplosionParticles() {
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag compoundTag) {
        if (this.caster == null) {
            this.m_146870_();
        }
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    private void updateWithPlayer() {
        this.setYaw((float)Math.toRadians(this.caster.f_20885_ + 90.0f));
        this.setPitch((float)Math.toRadians(-this.caster.m_146909_()));
        Vec3 vecOffset = this.caster.m_20154_().m_82541_().m_82490_(1.25);
        this.m_6034_(this.caster.m_20185_() + vecOffset.m_7096_(), this.caster.m_20186_() + (double)(this.caster.m_20206_() * 0.5f) + vecOffset.m_7098_(), this.caster.m_20189_() + vecOffset.m_7094_());
    }

    private void updateWithEntity(float offset, float yOffset) {
        double radians = Math.toRadians(this.caster.f_20885_ + 90.0f);
        this.setYaw((float)radians);
        this.setPitch((float)((double)(-this.caster.m_146909_()) * Math.PI / 180.0));
        double offsetX = Math.cos(radians) * (double)offset;
        double offsetZ = Math.sin(radians) * (double)offset;
        this.m_6034_(this.caster.m_20185_() + offsetX, this.caster.m_20227_((double)yOffset), this.caster.m_20189_() + offsetZ);
    }
}

