/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.datagen.builder;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingRecipe;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class VehicleAssemblingRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    @Nullable
    private final EntityType<?> entityType;
    private final int count;
    private final VehicleAssemblingRecipe.Category category;
    private final Map<String, Integer> ingredients = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    public VehicleAssemblingRecipeBuilder(ItemLike pResult, int pCount, VehicleAssemblingRecipe.Category category) {
        this.result = pResult.m_5456_();
        this.entityType = null;
        this.count = pCount;
        this.category = category;
    }

    public VehicleAssemblingRecipeBuilder(EntityType<?> type, VehicleAssemblingRecipe.Category category) {
        this.result = (Item)ModItems.CONTAINER.get();
        this.entityType = type;
        this.count = 1;
        this.category = category;
    }

    public static VehicleAssemblingRecipeBuilder item(ItemLike pResult, int pCount, VehicleAssemblingRecipe.Category category) {
        return new VehicleAssemblingRecipeBuilder(pResult, pCount, category);
    }

    public static VehicleAssemblingRecipeBuilder entity(EntityType<?> type, VehicleAssemblingRecipe.Category category) {
        return new VehicleAssemblingRecipeBuilder(type, category);
    }

    public VehicleAssemblingRecipeBuilder require(ItemLike item, int count) {
        this.ingredients.merge(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()).toString(), count, (k, v) -> count + v);
        return this;
    }

    public VehicleAssemblingRecipeBuilder require(TagKey<Item> tag, int count) {
        this.ingredients.merge("#" + tag.f_203868_(), count, (k, v) -> count + v);
        return this;
    }

    public VehicleAssemblingRecipeBuilder require(ItemLike item) {
        return this.require(item, 1);
    }

    public VehicleAssemblingRecipeBuilder require(TagKey<Item> tag) {
        return this.require(tag, 1);
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        if (this.entityType == null) {
            pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.ingredients, this.category, this.result, this.count, this.advancement, pRecipeId.m_246208_("recipes/" + RecipeCategory.MISC.m_247710_() + "/")));
        } else {
            pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.ingredients, this.category, this.entityType, this.advancement, pRecipeId.m_246208_("recipes/" + RecipeCategory.MISC.m_247710_() + "/")));
        }
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pId);
        }
    }

    static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Map<String, Integer> ingredients;
        private final VehicleAssemblingRecipe.Category category;
        private final Item result;
        private final int count;
        @Nullable
        private final EntityType<?> entityType;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Map<String, Integer> ingredients, VehicleAssemblingRecipe.Category category, Item result, int count, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.ingredients = ingredients;
            this.category = category;
            this.result = result;
            this.count = count;
            this.entityType = null;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public Result(ResourceLocation id, Map<String, Integer> ingredients, VehicleAssemblingRecipe.Category category, @Nullable EntityType<?> entityType, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.ingredients = ingredients;
            this.category = category;
            this.result = (Item)ModItems.CONTAINER.get();
            this.count = 1;
            this.entityType = entityType;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            JsonArray jsonarray = new JsonArray();
            for (Map.Entry<String, Integer> pair : this.ingredients.entrySet()) {
                String ingredient = pair.getKey();
                Integer count = pair.getValue();
                if (count > 1) {
                    jsonarray.add(count + " " + ingredient);
                    continue;
                }
                jsonarray.add(ingredient);
            }
            json.add("inputs", (JsonElement)jsonarray);
            json.addProperty("category", this.category.getName());
            JsonObject res = new JsonObject();
            if (this.entityType != null) {
                res.addProperty("entity", EntityType.m_20613_(this.entityType).toString());
            } else {
                res.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
                if (this.count > 1) {
                    res.addProperty("count", (Number)this.count);
                }
            }
            json.add("result", (JsonElement)res);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.VEHICLE_ASSEMBLING_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

