/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.vehicle;

import com.atsuishio.superbwarfare.data.CustomData;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.data.JsonPropertyModifier;
import com.atsuishio.superbwarfare.data.vehicle.DefaultVehicleData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class VehicleData
implements DefaultDataSupplier<DefaultVehicleData> {
    public final String id;
    public final VehicleEntity vehicle;
    private final JsonPropertyModifier<VehicleData, DefaultVehicleData> jsonPropModifier = new JsonPropertyModifier();
    private DefaultVehicleData cache = null;
    public static final LoadingCache<VehicleEntity, VehicleData> dataCache = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<VehicleEntity, VehicleData>(){

        @NotNull
        public VehicleData load(@NotNull VehicleEntity entity) {
            return new VehicleData(entity);
        }
    });

    private VehicleData(VehicleEntity entity) {
        this.id = VehicleData.getRegistryId(entity.m_6095_());
        this.vehicle = entity;
    }

    public static DefaultVehicleData compute(VehicleEntity vehicle) {
        return VehicleData.from(vehicle).compute();
    }

    public DefaultVehicleData compute() {
        if (this.cache != null) {
            return this.cache;
        }
        DefaultVehicleData raw = (DefaultVehicleData)this.getDefault().copy();
        if (this.vehicle.isInitialized()) {
            this.jsonPropModifier.update((String)this.vehicle.m_20088_().m_135370_(VehicleEntity.OVERRIDE));
            raw = this.jsonPropModifier.computeProperties(this, raw);
        }
        raw.limit();
        this.cache = raw;
        return raw;
    }

    public void update() {
        this.cache = null;
    }

    public static DefaultVehicleData getDefault(String id) {
        boolean isDefault = !CustomData.VEHICLE_DATA.containsKey(id);
        DefaultVehicleData data = CustomData.VEHICLE_DATA.getOrElseGet(id, DefaultVehicleData::new);
        data.isDefaultData = isDefault;
        return data;
    }

    @Override
    public DefaultVehicleData getDefault() {
        return VehicleData.getDefault(this.id);
    }

    public static DefaultVehicleData getDefault(VehicleEntity entity) {
        return VehicleData.getDefault(entity.m_6095_());
    }

    public static DefaultVehicleData getDefault(EntityType<?> type) {
        return VehicleData.getDefault(VehicleData.getRegistryId(type));
    }

    public static String getRegistryId(EntityType<?> type) {
        return EntityType.m_20613_(type).toString();
    }

    public static VehicleData from(VehicleEntity entity) {
        return (VehicleData)dataCache.getUnchecked((Object)entity);
    }

    public DamageModifier damageModifier() {
        DamageModifier modifier = new DamageModifier();
        DefaultVehicleData data = this.compute();
        if (data.applyDefaultDamageModifiers) {
            modifier.addAll(DamageModifier.createDefaultModifier().toList());
            modifier.reduce(5.0f, ModDamageTypes.VEHICLE_STRIKE);
        }
        return modifier.addAll((List)DataLoader.processValue(data.damageModifiers));
    }
}

