/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun.subdata;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.item.PerkItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.registries.RegistryObject;

public final class Perks {
    private final CompoundTag perks;

    public Perks(GunData gun) {
        this.perks = gun.perk();
    }

    public boolean has(Perk perk) {
        if (!this.has(perk.type)) {
            return false;
        }
        return this.getTag(perk).m_128461_("Name").equals(perk.name);
    }

    public boolean has(Perk.Type type) {
        return this.perks.m_128441_(type.getName()) && !this.perks.m_128469_(type.getName()).m_128461_("Name").isEmpty();
    }

    public void set(PerkInstance instance) {
        this.set(instance.perk(), instance.level());
    }

    public CompoundTag getTag(RegistryObject<Perk> registry) {
        return this.getTag(((Perk)registry.get()).type);
    }

    public CompoundTag getTag(Perk perk) {
        return this.getTag(perk.type);
    }

    public CompoundTag getTag(Perk.Type type) {
        return this.perks.m_128469_(type.getName());
    }

    public CompoundTag getOrCreateTag(Perk perk) {
        Perk.Type type = perk.type;
        if (!this.perks.m_128441_(type.getName())) {
            CompoundTag typeTag = new CompoundTag();
            this.perks.m_128365_(type.getName(), (Tag)typeTag);
        }
        return this.perks.m_128469_(type.getName());
    }

    public void set(Perk perk, short level) {
        this.getOrCreateTag(perk).m_128359_("Name", perk.name);
        this.getOrCreateTag(perk).m_128376_("Level", level);
    }

    public short getLevel(PerkItem item) {
        return this.getLevel(item.getPerk());
    }

    public short getLevel(RegistryObject<Perk> perk) {
        return this.getLevel((Perk)perk.get());
    }

    public short getLevel(Perk perk) {
        String name = perk.name;
        CompoundTag tag = this.getTag(perk);
        if (!tag.m_128461_("Name").equals(name)) {
            return 0;
        }
        return this.getLevel(perk.type);
    }

    public short getLevel(Perk.Type type) {
        return this.getTag(type).m_128448_("Level");
    }

    @Nullable
    public Perk get(RegistryObject<Perk> registry) {
        return this.get((Perk)registry.get());
    }

    @Nullable
    public Perk get(Perk perk) {
        return this.get(perk.type);
    }

    @Nullable
    public Perk get(Perk.Type type) {
        ArrayList perksRegistry = new ArrayList();
        perksRegistry.addAll(ModPerks.AMMO_PERKS.getEntries());
        perksRegistry.addAll(ModPerks.FUNC_PERKS.getEntries());
        perksRegistry.addAll(ModPerks.DAMAGE_PERKS.getEntries());
        for (RegistryObject registry : perksRegistry) {
            String name = this.getTag(type).m_128461_("Name");
            if (!((Perk)registry.get()).name.equals(name)) continue;
            return (Perk)registry.get();
        }
        return null;
    }

    @Nullable
    public PerkInstance getInstance(Perk perk) {
        return this.getInstance(perk.type);
    }

    @Nullable
    public PerkInstance getInstance(Perk.Type type) {
        Perk perk = this.get(type);
        if (perk == null) {
            return null;
        }
        return new PerkInstance(perk, this.getLevel(type));
    }

    public void reduceCooldown(RegistryObject<Perk> registry, String name) {
        this.reduceCooldown((Perk)registry.get(), name);
    }

    public void reduceCooldown(Perk perk, String name) {
        this.reduceCooldown(perk.type, name);
    }

    public void reduceCooldown(Perk.Type type, String name) {
        CompoundTag tag = this.getTag(type);
        int value = tag.m_128451_(name);
        if (--value <= 0) {
            tag.m_128473_(name);
        } else {
            tag.m_128405_(name, value);
        }
    }

    public void remove(Perk perk) {
        this.remove(perk.type);
    }

    public void remove(Perk.Type type) {
        this.perks.m_128473_(type.getName());
    }
}

