/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.data.DeserializeFromString;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class StringToObject<T extends DeserializeFromString> {
    public T value;

    public StringToObject(T value) {
        this.value = value;
    }

    static class AdapterFactory
    implements TypeAdapterFactory {
        AdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (StringToObject.class.isAssignableFrom(type.getRawType()) && type.getType() instanceof ParameterizedType) {
                return new StringOrObjectAdapter(type.getType(), gson);
            }
            return null;
        }
    }

    static class StringOrObjectAdapter<T extends DeserializeFromString>
    extends TypeAdapter<StringToObject<T>> {
        private final Type type;
        private final Gson gson;

        public StringOrObjectAdapter(Type type, Gson gson) {
            this.gson = gson;
            this.type = ((ParameterizedType)type).getActualTypeArguments()[0];
        }

        public void write(JsonWriter jsonWriter, StringToObject<T> obj) throws IOException {
            if (obj == null) {
                jsonWriter.nullValue();
                return;
            }
            this.gson.toJson(obj.value, this.type, jsonWriter);
        }

        public StringToObject<T> read(JsonReader jsonReader) throws IOException {
            JsonToken token = jsonReader.peek();
            if (token == JsonToken.NULL) {
                jsonReader.nextNull();
                return (StringToObject)this.gson.fromJson("{}", this.type);
            }
            if (token == JsonToken.BEGIN_OBJECT || token == JsonToken.BEGIN_ARRAY) {
                return new StringToObject<DeserializeFromString>((DeserializeFromString)this.gson.fromJson(jsonReader, this.type));
            }
            DeserializeFromString obj = (DeserializeFromString)this.gson.fromJson("{}", this.type);
            obj.deserializeFromString((String)this.gson.fromJson(jsonReader, String.class));
            return new StringToObject<DeserializeFromString>(obj);
        }
    }
}

