/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public class ObjectToList<T> {
    public List<T> list;

    public ObjectToList(List<T> list) {
        this.list = list;
    }

    @SafeVarargs
    public ObjectToList(T ... objects) {
        this.list = List.of(objects);
    }

    static class AdapterFactory
    implements TypeAdapterFactory {
        AdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (ObjectToList.class.isAssignableFrom(type.getRawType())) {
                return new ListOrObjectAdapter(type.getType(), gson);
            }
            return null;
        }
    }

    static class ListOrObjectAdapter<T>
    extends TypeAdapter<ObjectToList<T>> {
        private final Type type;
        private final Gson gson;

        public ListOrObjectAdapter(Type type, Gson gson) {
            this.gson = gson;
            this.type = ((ParameterizedType)type).getActualTypeArguments()[0];
        }

        public void write(JsonWriter jsonWriter, ObjectToList<T> objectToList) throws IOException {
            if (objectToList == null || objectToList.list == null) {
                jsonWriter.beginArray().endArray();
                return;
            }
            if (objectToList.list.size() == 1) {
                this.gson.toJson(objectToList.list.get(0), this.type, jsonWriter);
            } else {
                this.gson.toJson(objectToList.list, TypeToken.getParameterized(List.class, (Type[])new Type[]{this.type}).getType(), jsonWriter);
            }
        }

        public ObjectToList<T> read(JsonReader jsonReader) throws IOException {
            JsonToken token = jsonReader.peek();
            if (token != JsonToken.BEGIN_ARRAY) {
                if (token == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return new ObjectToList<Object>(new Object[0]);
                }
                return new ObjectToList<Object>(this.gson.fromJson(jsonReader, this.type));
            }
            Type listType = TypeToken.getParameterized(List.class, (Type[])new Type[]{this.type}).getType();
            return new ObjectToList((List)this.gson.fromJson(jsonReader, listType));
        }
    }
}

