/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class LowerCamelCaseEnumArgument<T extends Enum<T>>
implements ArgumentType<T> {
    private static final Dynamic2CommandExceptionType INVALID_ENUM = new Dynamic2CommandExceptionType((found, constants) -> Component.m_237110_((String)"commands.forge.arguments.enum.invalid", (Object[])new Object[]{constants, found}));
    public final Function<T, String> valueMapper = e -> {
        String input = e.name();
        if (input == null || input.trim().isEmpty()) {
            return input;
        }
        String trimmed = input.replaceAll("^_+|_+$", "");
        if (trimmed.isEmpty()) {
            return input;
        }
        String[] parts = trimmed.toLowerCase(Locale.ROOT).split("_+");
        StringBuilder result = new StringBuilder();
        result.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].isEmpty()) continue;
            result.append(Character.toUpperCase(parts[i].charAt(0))).append(parts[i].substring(1));
        }
        return result.toString();
    };
    private final Class<T> enumClass;

    private LowerCamelCaseEnumArgument(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public static <T extends Enum<T>> LowerCamelCaseEnumArgument<T> enumArgument(Class<T> enumClass) {
        return new LowerCamelCaseEnumArgument<T>(enumClass);
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String input = reader.readUnquotedString();
        for (Enum enumValue : (Enum[])this.enumClass.getEnumConstants()) {
            if (!this.valueMapper.apply(enumValue).equals(input)) continue;
            return (T)enumValue;
        }
        throw INVALID_ENUM.createWithContext((ImmutableStringReader)reader, (Object)input, (Object)Arrays.toString(Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(this.valueMapper).toArray()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(this.valueMapper).toList(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(this.valueMapper).toList();
    }

    public static class Info<T extends Enum<T>>
    implements ArgumentTypeInfo<LowerCamelCaseEnumArgument<T>, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.m_130070_(template.enumClass.getName());
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            try {
                String name = buffer.m_130277_();
                return new Template(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("enum", template.enumClass.getName());
        }

        public Template unpack(LowerCamelCaseEnumArgument<T> argument) {
            return new Template(argument.enumClass);
        }

        public class Template
        implements ArgumentTypeInfo.Template<LowerCamelCaseEnumArgument<T>> {
            final Class<T> enumClass;

            Template(Class<T> enumClass) {
                this.enumClass = enumClass;
            }

            public LowerCamelCaseEnumArgument<T> instantiate(CommandBuildContext pStructure) {
                return new LowerCamelCaseEnumArgument(this.enumClass);
            }

            public ArgumentTypeInfo<LowerCamelCaseEnumArgument<T>, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

