/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.sound;

import com.atsuishio.superbwarfare.client.sound.VehicleSoundInstance;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public abstract class VehicleFireSoundInstance
extends AbstractTickableSoundInstance {
    private final Minecraft client;
    private final Entity entity;
    private double lastDistance;
    private int fade = 0;
    private boolean die = false;

    public VehicleFireSoundInstance(SoundEvent sound, Minecraft client, Entity entity) {
        super(sound, SoundSource.AMBIENT, entity.m_20193_().m_213780_());
        this.client = client;
        this.entity = entity;
        this.f_119578_ = true;
        this.f_119579_ = 0;
    }

    protected abstract boolean canPlay(Entity var1);

    protected abstract float getPitch(Entity var1);

    protected abstract float getVolume(Entity var1);

    public void m_7788_() {
        LocalPlayer player = this.client.f_91074_;
        if (this.entity.m_213877_() || player == null) {
            this.m_119609_();
            return;
        }
        if (!this.canPlay(this.entity)) {
            this.die = true;
        }
        if (this.die) {
            if (this.fade > 0) {
                --this.fade;
            } else if (this.fade == 0) {
                this.m_119609_();
                return;
            }
        } else if (this.fade < 3) {
            ++this.fade;
        }
        this.f_119573_ = this.getVolume(this.entity) * (float)this.fade;
        this.f_119575_ = this.entity.m_20185_();
        this.f_119576_ = this.entity.m_20186_();
        this.f_119577_ = this.entity.m_20189_();
        this.f_119574_ = this.getPitch(this.entity);
    }

    public static class VehicleFireSound
    extends VehicleSoundInstance {
        public VehicleFireSound(VehicleEntity vehicle) {
            super(vehicle.getShootSoundInstance(), Minecraft.m_91087_(), vehicle);
        }

        @Override
        protected boolean canPlay(VehicleEntity vehicle) {
            return vehicle.isFiring();
        }

        @Override
        protected float getPitch(VehicleEntity vehicle) {
            return vehicle.shootingPitch();
        }

        @Override
        protected float getVolume(VehicleEntity vehicle) {
            return vehicle.shootingVolume();
        }
    }
}

