/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.client.layer.vehicle.DroneLayer;
import com.atsuishio.superbwarfare.client.model.entity.DroneModel;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class DroneRenderer
extends GeoEntityRenderer<DroneEntity> {
    private String entityNameCache = "";
    private Entity entityCache = null;
    private int attachedTick = Integer.MAX_VALUE;

    public DroneRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new DroneModel());
        this.addRenderLayer(new DroneLayer((GeoRenderer<DroneEntity>)this));
        this.f_114477_ = 0.2f;
    }

    public RenderType getRenderType(DroneEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)this.m_5478_(animatable));
    }

    public void render(DroneEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-entityIn.getYaw(partialTicks)));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(entityIn.getBodyPitch(partialTicks)));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(entityIn.getRoll(partialTicks)));
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            boolean firstPerson;
            ItemStack stack = player.m_21205_();
            DroneEntity drone = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_("LinkedDrone"));
            boolean bl = firstPerson = Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK;
            if (!(stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked") && drone != null && drone.m_20148_() == entityIn.m_20148_() && firstPerson)) {
                this.renderAttachments(entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
            }
        }
        poseStack.m_85849_();
    }

    private void renderAttachments(DroneEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Entity renderEntity;
        SynchedEntityData data = entity.m_20088_();
        String attached = (String)data.m_135370_(DroneEntity.DISPLAY_ENTITY);
        if (attached.isEmpty()) {
            return;
        }
        if (this.entityNameCache.equals(attached) && this.entityCache != null) {
            renderEntity = this.entityCache;
        } else {
            renderEntity = EntityType.m_20632_((String)attached).map(type -> type.m_20615_(entity.m_9236_())).orElse(null);
            if (renderEntity == null) {
                return;
            }
            CompoundTag tag = (CompoundTag)data.m_135370_(DroneEntity.DISPLAY_ENTITY_TAG);
            if (!tag.m_128456_()) {
                renderEntity.m_20258_(tag);
            }
            this.entityNameCache = attached;
            this.entityCache = renderEntity;
            this.attachedTick = entity.f_19797_;
        }
        List displayData = (List)data.m_135370_(DroneEntity.DISPLAY_DATA);
        renderEntity.f_19797_ = ((Float)displayData.get(11)).floatValue() >= 0.0f ? ((Float)displayData.get(11)).intValue() : entity.f_19797_ - this.attachedTick;
        float[] scale = new float[]{((Float)displayData.get(0)).floatValue(), ((Float)displayData.get(1)).floatValue(), ((Float)displayData.get(2)).floatValue()};
        float[] offset = new float[]{((Float)displayData.get(3)).floatValue(), ((Float)displayData.get(4)).floatValue(), ((Float)displayData.get(5)).floatValue()};
        float[] rotation = new float[]{((Float)displayData.get(6)).floatValue(), ((Float)displayData.get(7)).floatValue(), ((Float)displayData.get(8)).floatValue()};
        Float xLength = (Float)displayData.get(9);
        Float yLength = (Float)displayData.get(10);
        for (int i = 0; i < (Integer)data.m_135370_(VehicleEntity.AMMO); ++i) {
            float z;
            float x;
            if ((Integer)data.m_135370_(DroneEntity.MAX_AMMO) == 1) {
                x = 0.0f;
                z = 0.0f;
            } else {
                x = xLength.floatValue() / 2.0f * (float)(i % 2 == 0 ? 1 : -1);
                int rows = (Integer)data.m_135370_(DroneEntity.MAX_AMMO) / 2;
                int row = i / 2;
                if (rows < 2) {
                    z = 0.0f;
                } else {
                    float rowLength = yLength.floatValue() / (float)rows;
                    z = -yLength.floatValue() / 2.0f + rowLength * (float)row;
                }
            }
            poseStack.m_85836_();
            poseStack.m_252880_(x + offset[0], offset[1], z + offset[2]);
            poseStack.m_85841_(scale[0], scale[1], scale[2]);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation[2]));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rotation[0]));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation[1]));
            this.f_114476_.m_114384_(renderEntity, 0.0, 0.0, 0.0, entityYaw, partialTicks, poseStack, buffer, packedLight);
            poseStack.m_85849_();
        }
    }
}

