/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.model.item;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.item.gun.GunGeoItem;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.mixins.AnimationProcessorAccessor;
import com.atsuishio.superbwarfare.mixins.GeoModelAccessor;
import com.atsuishio.superbwarfare.resource.ModelResource;
import com.atsuishio.superbwarfare.resource.gun.DefaultGunResource;
import com.atsuishio.superbwarfare.resource.gun.GunResource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoModel;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.molang.MolangParser;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.util.RenderUtils;

public abstract class CustomGunModel<T extends GunGeoItem>
extends GeoModel<T> {
    public ItemStack gunItemStack;

    public ResourceLocation getAnimationResource(T animatable) {
        return this.getModel(animatable).animation;
    }

    public ResourceLocation getModelResource(T animatable) {
        return this.getModel(animatable).model;
    }

    public ResourceLocation getTextureResource(T animatable) {
        return this.getModel(animatable).texture;
    }

    public ResourceLocation getLODModelResource(T animatable) {
        return this.getModel(animatable).getLODModel(Integer.MAX_VALUE);
    }

    public ResourceLocation getLODTextureResource(T animatable) {
        return this.getModel(animatable).getLODTexture(Integer.MAX_VALUE);
    }

    protected ModelResource getModel(T animatable) {
        if (this.gunItemStack != null && this.gunItemStack.m_41720_() instanceof GunGeoItem) {
            return GunResource.from(this.gunItemStack).compute().getModel();
        }
        return this.getResource(animatable).getModel();
    }

    protected DefaultGunResource getResource(T animatable) {
        return GunResource.getDefault(animatable);
    }

    public void handleAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        boolean isReRender;
        Minecraft mc = Minecraft.m_91087_();
        AnimatableManager animatableManager = ((GunGeoItem)animatable).getAnimatableInstanceCache().getManagerForId(instanceId);
        Double currentTick = (Double)animationState.getData(DataTickets.TICK);
        if (currentTick == null) {
            currentTick = RenderUtils.getCurrentTick();
        }
        if (animatableManager.getFirstTickTime() == -1.0) {
            animatableManager.startedAt(currentTick + (double)mc.m_91296_());
        }
        double currentFrameTime = currentTick - animatableManager.getFirstTickTime();
        boolean bl = isReRender = !animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime();
        if (isReRender && instanceId == ((GeoModelAccessor)((Object)this)).getLastRenderedInstance()) {
            return;
        }
        if (!mc.m_91104_() || animatable.shouldPlayAnimsWhileGamePaused()) {
            animatableManager.updatedAt(currentFrameTime);
            double lastUpdateTime = animatableManager.getLastUpdateTime();
            ((GeoModelAccessor)((Object)this)).setAnimTime(((GeoModelAccessor)((Object)this)).getAnimTime() + lastUpdateTime - ((GeoModelAccessor)((Object)this)).getLastGameTickTime());
            ((GeoModelAccessor)((Object)this)).setLastGameTickTime(lastUpdateTime);
        }
        animationState.animationTick = ((GeoModelAccessor)((Object)this)).getAnimTime();
        ((GeoModelAccessor)((Object)this)).setLastRenderedInstance(instanceId);
        AnimationProcessor processor = this.getAnimationProcessor();
        CoreGeoModel model = ((AnimationProcessorAccessor)processor).getModel();
        if (model instanceof CustomGunModel) {
            CustomGunModel customGunModel = (CustomGunModel)model;
            customGunModel.applyCustomMolangQueries(animationState, ((GeoModelAccessor)((Object)this)).getAnimTime());
        }
        if (!processor.getRegisteredBones().isEmpty()) {
            processor.tickAnimation(animatable, (CoreGeoModel)this, animatableManager, ((GeoModelAccessor)((Object)this)).getAnimTime(), animationState, this.crashIfBoneMissing());
        }
        this.setCustomAnimations((GeoAnimatable)animatable, instanceId, (AnimationState)animationState);
    }

    public void applyMolangQueries(T animatable, double animTime) {
        MolangParser parser = MolangParser.INSTANCE;
        Minecraft mc = Minecraft.m_91087_();
        parser.setMemoizedValue("query.life_time", () -> animTime / 20.0);
        if (mc.f_91073_ != null) {
            parser.setMemoizedValue("query.actor_count", () -> ((ClientLevel)mc.f_91073_).m_104813_());
            parser.setMemoizedValue("query.time_of_day", () -> (float)mc.f_91073_.m_46468_() / 24000.0f);
            parser.setMemoizedValue("query.moon_phase", () -> ((ClientLevel)mc.f_91073_).m_46941_());
        }
    }

    public void applyCustomMolangQueries(AnimationState<T> animationState, double animTime) {
        this.applyMolangQueries((GunGeoItem)animationState.getAnimatable(), animTime);
        MolangParser parser = MolangParser.INSTANCE;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            this.resetQueryValue();
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            this.resetQueryValue();
            return;
        }
        ItemStack item = (ItemStack)animationState.getData(DataTickets.ITEMSTACK);
        if (GeoItem.getId((ItemStack)item) != GeoItem.getId((ItemStack)stack)) {
            this.resetQueryValue();
            return;
        }
        if (animationState.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            this.resetQueryValue();
            return;
        }
        GunData data = GunData.from(stack);
        parser.setValue("query.sbw_is_empty", () -> data.isEmpty.get() ? 1.0 : 0.0);
        parser.setValue("query.sbw_system_time", System::currentTimeMillis);
    }

    private void resetQueryValue() {
        MolangParser parser = MolangParser.INSTANCE;
        parser.setValue("query.sbw_is_empty", () -> 0.0);
        parser.setValue("query.sbw_system_time", () -> 0.0);
    }

    public boolean shouldCancelRender(ItemStack stack, AnimationState<T> animationState) {
        if (!(stack.m_41720_() instanceof GunItem)) {
            return true;
        }
        ItemStack item = (ItemStack)animationState.getData(DataTickets.ITEMSTACK);
        if (GeoItem.getId((ItemStack)item) != GeoItem.getId((ItemStack)stack)) {
            return true;
        }
        return animationState.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
    }
}

