/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.decorator;

import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemDecorator;

@OnlyIn(value=Dist.CLIENT)
public class ContainerItemDecorator
implements IItemDecorator {
    private static final Map<String, ResourceLocation> icons = new HashMap<String, ResourceLocation>();

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        if (!(stack.m_41720_() instanceof ContainerBlockItem)) {
            return false;
        }
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag == null) {
            return false;
        }
        ResourceLocation icon = null;
        if (tag.m_128441_("EntityType")) {
            String typeString = tag.m_128461_("EntityType");
            if (icons.containsKey(typeString)) {
                icon = icons.get(typeString);
            } else {
                EntityType entityType = EntityType.m_20632_((String)typeString).orElse(null);
                if (entityType == null) {
                    return false;
                }
                Minecraft mc = Minecraft.m_91087_();
                ClientLevel level = mc.f_91073_;
                if (level == null) {
                    return false;
                }
                Entity entity = entityType.m_20615_((Level)level);
                if (!(entity instanceof VehicleEntity)) {
                    return false;
                }
                VehicleEntity vehicle = (VehicleEntity)entity;
                icon = vehicle.getVehicleItemIcon();
                icons.put(typeString, icon);
            }
        }
        if (icon == null) {
            return false;
        }
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        RenderHelper.preciseBlit(guiGraphics, icon, xOffset, yOffset, 200.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
        pose.m_85849_();
        return true;
    }
}

