/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.animation;

import com.atsuishio.superbwarfare.client.animation.AnimationTimer;
import javax.annotation.Nullable;

public class ValueAnimator<T>
extends AnimationTimer {
    private T oldValue;
    private T newValue;

    public ValueAnimator(long duration, T defaultValue) {
        super(duration);
        this.reset(defaultValue);
    }

    public static <T> ValueAnimator<T>[] create(int size, long duration, T defaultValue) {
        ValueAnimator[] animators = new ValueAnimator[size];
        for (int i = 0; i < size; ++i) {
            animators[i] = new ValueAnimator<T>(duration, defaultValue);
        }
        return animators;
    }

    public void update(T value) {
        this.oldValue = this.newValue;
        this.newValue = value;
    }

    public void compareAndUpdate(T value) {
        this.compareAndUpdate(value, null);
    }

    public void compareAndUpdate(T value, @Nullable Runnable callback) {
        if (!this.newValue.equals(value)) {
            this.update(value);
            if (callback != null) {
                callback.run();
            }
        }
    }

    public void reset(T value) {
        this.oldValue = value;
        this.newValue = value;
    }

    public T oldValue() {
        return this.oldValue;
    }

    public T newValue() {
        return this.newValue;
    }
}

