/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import com.atsuishio.superbwarfare.block.entity.LuckyContainerBlockEntity;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LuckyContainerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPENED = BooleanProperty.m_61465_((String)"opened");

    public LuckyContainerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(3.0f).m_60955_().m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_ || ((Boolean)pState.m_61143_((Property)OPENED)).booleanValue() || !(pLevel.m_7702_(pPos) instanceof LuckyContainerBlockEntity)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (!stack.m_204117_(ModTags.Items.TOOLS_CROWBAR)) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"des.superbwarfare.container.fail.crowbar"), true);
            return InteractionResult.PASS;
        }
        pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(true)));
        pLevel.m_5594_(null, BlockPos.m_274561_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_()), (SoundEvent)ModSounds.OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        if (!pLevel.f_46443_) {
            return LuckyContainerBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.LUCKY_CONTAINER.get()), LuckyContainerBlockEntity::serverTick);
        }
        return null;
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        CompoundTag tag = BlockItem.m_186336_((ItemStack)pStack);
        if (tag != null) {
            Object location = tag.m_128461_("Location");
            if (((String)location).startsWith("superbwarfare")) {
                String[] split = ((String)location).split("superbwarfare:");
                if (split.length == 2) {
                    location = "location." + split[1];
                }
                pTooltip.add((Component)Component.m_237115_((String)("des.superbwarfare.lucky_container." + (String)location)).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            pTooltip.add((Component)Component.m_237115_((String)"des.superbwarfare.small_container").m_130940_(ChatFormatting.GRAY));
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)OPENED) != false ? LuckyContainerBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0) : LuckyContainerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new LuckyContainerBlockEntity(blockPos, blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{OPENED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(false));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        ItemStack itemstack = super.m_7397_(pLevel, pPos, pState);
        pLevel.m_141902_(pPos, (BlockEntityType)ModBlockEntities.LUCKY_CONTAINER.get()).ifPresent(blockEntity -> blockEntity.m_187476_(itemstack));
        return itemstack;
    }
}

