/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable.stateless;

import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.animatable.stateless.StatelessAnimationController;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StatelessAnimatable {
    default public void playAnimation(String animation) {
        this.playAnimation(RawAnimation.begin().thenPlay(animation));
    }

    default public void playLoopingAnimation(String animation) {
        this.playAnimation(RawAnimation.begin().thenLoop(animation));
    }

    default public void playAndHoldAnimation(String animation) {
        this.playAnimation(RawAnimation.begin().thenPlayAndHold(animation));
    }

    default public void stopAnimation(RawAnimation animation) {
        this.stopAnimation(animation.getStageCount() == 1 ? animation.getAnimationStages().get(0).animationName() : animation.toString());
    }

    public void playAnimation(RawAnimation var1);

    public void stopAnimation(String var1);

    @ApiStatus.Internal
    default public void handleClientAnimationPlay(GeoAnimatable animatable, long animatableId, RawAnimation animation) {
        AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(animatableId);
        if (animatableManager == null) {
            return;
        }
        String animKey = animation.getStageCount() == 1 ? animation.getAnimationStages().get(0).animationName() : animation.toString();
        AnimationController controller = animatableManager.getAnimationControllers().computeIfAbsent(animKey, anim -> new StatelessAnimationController(animatable, (String)anim));
        if (controller instanceof StatelessAnimationController) {
            StatelessAnimationController statelessController = (StatelessAnimationController)controller;
            statelessController.setCurrentAnimation(animation);
        }
    }

    @ApiStatus.Internal
    default public void handleClientAnimationStop(GeoAnimatable animatable, long animatableId, String animName) {
        AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(animatableId);
        if (animatableManager == null) {
            return;
        }
        AnimationController animationController = animatableManager.getAnimationControllers().get(animName);
        if (animationController instanceof StatelessAnimationController) {
            StatelessAnimationController statelessController = (StatelessAnimationController)animationController;
            statelessController.setCurrentAnimation(null);
        }
    }
}

