/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui;

import de.keksuccino.fancymenu.util.rendering.ui.FocuslessContainerEventHandler;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import org.jetbrains.annotations.NotNull;

public abstract class UIComponent
extends UIBase
implements FocuslessContainerEventHandler,
Renderable,
NarratableEntry {
    public float posZ = 0.0f;
    protected boolean hovered = false;
    protected boolean visible = true;
    protected Minecraft mc = Minecraft.m_91087_();
    protected boolean dragging = false;
    protected final List<GuiEventListener> children = new ArrayList<GuiEventListener>();

    public abstract void renderComponent(@NotNull GuiGraphics var1, double var2, double var4, float var6);

    public void m_88315_(@NotNull GuiGraphics graphics, int ignoredMouseX, int ignoredMouseY, float partial) {
        if (!this.isVisible()) {
            return;
        }
        this.hovered = this.isMouseOver();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(this.getFixedComponentScale(), this.getFixedComponentScale(), this.getFixedComponentScale());
        graphics.m_280168_().m_252880_(this.getTranslatedX(), this.getTranslatedY(), this.posZ);
        this.renderComponent(graphics, this.getRealMouseX(), this.getRealMouseY(), partial);
        graphics.m_280168_().m_85849_();
    }

    protected float getRealX() {
        return 0.0f;
    }

    protected float getRealY() {
        return 0.0f;
    }

    public abstract float getTranslatedX();

    public abstract float getTranslatedY();

    public abstract float getWidth();

    public abstract float getHeight();

    public double getRealMouseX() {
        return (this.mc.f_91067_.m_91589_() - (double)(this.getTranslatedX() * this.getComponentScale())) / (double)this.getComponentScale();
    }

    public double getRealMouseY() {
        return (this.mc.f_91067_.m_91594_() - (double)(this.getTranslatedY() * this.getComponentScale())) / (double)this.getComponentScale();
    }

    public double getTranslatedMouseX() {
        return this.mc.f_91067_.m_91589_() / (double)this.getComponentScale();
    }

    public double getTranslatedMouseY() {
        return this.mc.f_91067_.m_91594_() / (double)this.getComponentScale();
    }

    protected float getScreenWidth() {
        return (float)this.mc.m_91268_().m_85441_() / this.getComponentScale();
    }

    protected float getScreenHeight() {
        return (float)this.mc.m_91268_().m_85442_() / this.getComponentScale();
    }

    protected boolean isComponentAreaHovered(float x, float y, float width, float height, boolean isRealPosition) {
        double mX = this.getRealMouseX();
        double mY = this.getRealMouseY();
        if (!isRealPosition) {
            x -= this.getTranslatedX();
            y -= this.getTranslatedY();
        }
        return UIComponent.isXYInArea(mX, mY, x, y, width + 1.0f, height + 1.0f);
    }

    public float getComponentScale() {
        return UIComponent.getUIScale();
    }

    public float getFixedComponentScale() {
        return UIComponent.calculateFixedScale(this.getComponentScale());
    }

    protected void enableComponentScissor(GuiGraphics graphics, int x, int y, int width, int height, boolean isRealPosition) {
        if (isRealPosition) {
            x = (int)((float)x + this.getTranslatedX());
            y = (int)((float)y + this.getTranslatedY());
        }
        int scissorX = (int)((float)x * this.getFixedComponentScale());
        int scissorY = (int)((float)y * this.getFixedComponentScale());
        int scissorWidth = (int)((float)width * this.getFixedComponentScale());
        int scissorHeight = (int)((float)height * this.getFixedComponentScale());
        graphics.m_280588_(scissorX, scissorY, scissorX + scissorWidth, scissorY + scissorHeight);
    }

    protected void disableComponentScissor(GuiGraphics graphics) {
        graphics.m_280618_();
    }

    public boolean isHovered() {
        if (!this.isVisible()) {
            return false;
        }
        return this.hovered;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @NotNull
    public List<GuiEventListener> m_6702_() {
        return this.children;
    }

    protected boolean mouseClickedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_6375_(realMouseX, realMouseY, button)) continue;
            this.m_7522_(child);
            if (button == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean m_6375_(double ignoredMouseX, double ignoredMouseY, int button) {
        return this.mouseClickedComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), button);
    }

    protected boolean mouseReleasedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        this.m_7897_(false);
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_6348_(realMouseX, realMouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean m_6348_(double ignoredMouseX, double ignoredMouseY, int button) {
        return this.mouseReleasedComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), button);
    }

    protected boolean mouseDraggedComponent(double translatedMouseX, double translatedMouseY, int button, double d1, double d2) {
        if (this.m_7282_() && button == 0) {
            for (GuiEventListener child : this.m_6702_()) {
                if (!child.m_7979_(this.getRealMouseX(), this.getRealMouseY(), button, d1, d2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean m_7979_(double ignoredMouseX, double ignoredMouseY, int button, double d1, double d2) {
        return this.mouseDraggedComponent(this.getTranslatedMouseX(), this.getTranslatedMouseY(), button, d1, d2);
    }

    public boolean m_7282_() {
        return this.dragging;
    }

    public void m_7897_(boolean dragging) {
        this.dragging = dragging;
    }

    protected boolean mouseScrolledComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, double scrollDelta) {
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_6050_(realMouseX, realMouseY, scrollDelta)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean m_6050_(double ignoredMouseX, double ignoredMouseY, double scrollDelta) {
        return this.mouseScrolledComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), scrollDelta);
    }

    protected void mouseMovedComponent(double realMouseX, double realMouseY) {
    }

    @Deprecated
    public void m_94757_(double ignoredMouseX, double ignoredMouseY) {
        this.mouseMovedComponent(this.getRealMouseX(), this.getRealMouseY());
    }

    public boolean isMouseOver() {
        if (!this.isVisible()) {
            return false;
        }
        return this.isComponentAreaHovered(this.getTranslatedX(), this.getTranslatedY(), this.getWidth(), this.getHeight(), false);
    }

    @Deprecated
    public boolean m_5953_(double ignoredMouseX, double ignoredMouseY) {
        return this.isMouseOver();
    }

    @Override
    public void m_93692_(boolean var1) {
    }

    public boolean m_93696_() {
        return false;
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(@NotNull NarrationElementOutput var1) {
    }
}

