/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.mcef;

import com.cinemamod.mcef.MCEF;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionBridge {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String JAVASCRIPT_NAMESPACE = "fancymenu";
    private static CefMessageRouter messageRouter;
    private static boolean initialized;
    public static final String JAVASCRIPT_API;

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!MCEFUtil.isMCEFLoaded()) {
            LOGGER.warn("[FANCYMENU] Cannot initialize ActionBridge - MCEF is not loaded");
            return;
        }
        try {
            LOGGER.info("[FANCYMENU] Initializing ActionBridge message router");
            if (MCEF.getClient() == null) {
                LOGGER.warn("[FANCYMENU] MCEF client is not initialized yet, delaying ActionBridge initialization");
                return;
            }
            CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig();
            config.jsQueryFunction = "cefQuery";
            config.jsCancelFunction = "cefQueryCancel";
            messageRouter = CefMessageRouter.create((CefMessageRouter.CefMessageRouterConfig)config);
            messageRouter.addHandler((CefMessageRouterHandler)ActionBridge.createMessageHandler(), true);
            MCEF.getClient().getHandle().addMessageRouter(messageRouter);
            initialized = true;
            LOGGER.info("[FANCYMENU] ActionBridge message router initialized successfully");
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to initialize ActionBridge message router", (Throwable)ex);
        }
    }

    public static void dispose() {
        if (messageRouter != null && initialized) {
            try {
                MCEF.getClient().getHandle().removeMessageRouter(messageRouter);
                messageRouter.dispose();
                messageRouter = null;
                initialized = false;
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to dispose ActionBridge message router", (Throwable)ex);
            }
        }
    }

    public static CefMessageRouterHandlerAdapter createMessageHandler() {
        return new CefMessageRouterHandlerAdapter(){

            public boolean onQuery(CefBrowser browser, CefFrame frame, long query_id, String request, boolean persistent, CefQueryCallback callback) {
                block8: {
                    LOGGER.info("[FANCYMENU] Received query from browser: {}", (Object)request);
                    try {
                        if (request == null || request.isEmpty()) {
                            callback.failure(400, "Empty request");
                            return true;
                        }
                        if (request.contains("\"type\":\"fancymenu_action\"") && request.contains("\"action\":")) {
                            String actionString = ActionBridge.extractActionFromJson(request);
                            if (actionString != null) {
                                LOGGER.info("[FANCYMENU] Processing action: {}", (Object)actionString);
                                boolean success = ActionBridge.processAction(actionString);
                                if (success) {
                                    callback.success("{\"success\":true,\"message\":\"Action executed successfully\"}");
                                } else {
                                    callback.failure(500, "Failed to execute action");
                                }
                            } else {
                                callback.failure(400, "Invalid action format");
                            }
                            break block8;
                        }
                        LOGGER.debug("[FANCYMENU] Query is not a FancyMenu action, passing to other handlers");
                        return false;
                    }
                    catch (Exception ex) {
                        LOGGER.error("[FANCYMENU] Error processing browser action request", (Throwable)ex);
                        callback.failure(500, "Internal error: " + ex.getMessage());
                    }
                }
                return true;
            }
        };
    }

    private static String extractActionFromJson(String json) {
        try {
            int actionIndex = json.indexOf("\"action\":\"");
            if (actionIndex == -1) {
                return null;
            }
            int start = actionIndex + 10;
            int end = json.indexOf("\"", start);
            if (end == -1) {
                return null;
            }
            String action = json.substring(start, end);
            action = action.replace("\\\"", "\"").replace("\\\\", "\\").replace("\\/", "/").replace("\\b", "\b").replace("\\f", "\f").replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t");
            return action;
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to extract action from JSON", (Throwable)ex);
            return null;
        }
    }

    private static boolean processAction(@NotNull String actionString) {
        try {
            ActionInstance action = ActionBridge.parseBrowserAction(actionString);
            if (action != null) {
                ActionBridge.executeAction(action);
                return true;
            }
            LOGGER.warn("[FANCYMENU] Failed to parse browser action: {}", (Object)actionString);
            return false;
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Error processing browser action: " + actionString, (Throwable)ex);
            return false;
        }
    }

    @Nullable
    public static ActionInstance parseBrowserAction(@NotNull String actionString) {
        try {
            String actionType;
            String value = null;
            if (actionString.contains(":")) {
                String[] array = actionString.split(":", 2);
                actionType = array[0];
                value = array[1];
            } else {
                actionType = actionString;
            }
            String parsableKey = "[executable_action_instance:" + ScreenCustomization.generateUniqueIdentifier() + "][action_type:" + actionType + "]";
            PropertyContainer container = new PropertyContainer("dummy_action_holder");
            container.putProperty(parsableKey, value == null ? "" : value);
            List<ActionInstance> deserialized = ActionInstance.deserializeAll(container);
            if (!deserialized.isEmpty()) {
                return deserialized.get(0);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to parse browser action: " + actionString, (Throwable)ex);
        }
        return null;
    }

    public static void executeAction(@NotNull ActionInstance action) {
        try {
            action.execute();
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to execute browser action!", (Throwable)ex);
        }
    }

    static {
        initialized = false;
        JAVASCRIPT_API = "(function() {\n    console.log('[FancyMenu] Initializing JavaScript API...');\n    console.log('[FancyMenu] typeof window.cefQuery:', typeof window.cefQuery);\n\n    // Wait for cefQuery to be available\n    var attempts = 0;\n    function waitForCefQuery(callback) {\n        attempts++;\n        if (typeof window.cefQuery !== 'undefined') {\n            console.log('[FancyMenu] cefQuery found after ' + attempts + ' attempts');\n            callback();\n        } else if (attempts > 100) {\n            console.error('[FancyMenu] cefQuery not found after 100 attempts. Message router may not be properly configured.');\n        } else {\n            setTimeout(function() {\n                waitForCefQuery(callback);\n            }, 50);\n        }\n    }\n\n    waitForCefQuery(function() {\n        window.%namespace% = {\n            executeWithCallback: function(actionType, actionValue, onSuccess, onFailure) {\n                // Handle overloaded calls\n                if (typeof actionValue === 'function') {\n                    // executeWithCallback(actionType, onSuccess, onFailure)\n                    onFailure = onSuccess;\n                    onSuccess = actionValue;\n                    actionValue = null;\n                }\n\n                if (!actionType || typeof actionType !== 'string') {\n                    if (onFailure) onFailure('Invalid action type');\n                    return;\n                }\n\n                // Construct action string\n                var actionString = actionType;\n                if (actionValue !== null && actionValue !== undefined && actionValue !== '') {\n                    actionString += ':' + actionValue;\n                }\n\n                console.log('[FancyMenu] Executing action:', actionString);\n\n                window.cefQuery({\n                    request: JSON.stringify({\n                        type: 'fancymenu_action',\n                        action: actionString\n                    }),\n                    onSuccess: function(response) {\n                        console.log('[FancyMenu] Action response:', response);\n                        if (onSuccess) {\n                            try {\n                                var result = JSON.parse(response);\n                                onSuccess(result);\n                            } catch (e) {\n                                onSuccess(response);\n                            }\n                        }\n                    },\n                    onFailure: function(error_code, error_message) {\n                        console.error('[FancyMenu] Action failed:', error_code, error_message);\n                        if (onFailure) onFailure(error_message);\n                    }\n                });\n            },\n\n            // Convenience method for executing actions without callbacks\n            execute: function(actionType, actionValue) {\n                if (arguments.length === 1) {\n                    // Single argument - action without value\n                    this.executeWithCallback(actionType);\n                } else {\n                    // Two arguments - action with value\n                    this.executeWithCallback(actionType, actionValue);\n                }\n            }\n        };\n\n        // Also create a global alias for easier access\n        window.FancyMenu = window.%namespace%;\n\n        console.log('[FancyMenu] API initialized successfully');\n\n        // Dispatch event to notify that the API is ready\n        window.dispatchEvent(new Event('fancymenu-ready'));\n    });\n})();\n".replace("%namespace%", JAVASCRIPT_NAMESPACE);
    }
}

