/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background.backgrounds.video.mcef;

import de.keksuccino.fancymenu.customization.background.backgrounds.video.mcef.MCEFVideoMenuBackground;
import de.keksuccino.fancymenu.customization.element.elements.video.SetVideoVolumeScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedGenericValueCycle;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.resource.ResourceChooserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.NotNull;

public class MCEFVideoMenuBackgroundConfigScreen
extends CellScreen {
    @NotNull
    protected Consumer<MCEFVideoMenuBackground> callback;
    @NotNull
    MCEFVideoMenuBackground background;

    protected MCEFVideoMenuBackgroundConfigScreen(@NotNull MCEFVideoMenuBackground background, @NotNull Consumer<MCEFVideoMenuBackground> callback) {
        super((Component)Component.m_237115_((String)"fancymenu.backgrounds.video_mcef.configure"));
        this.background = background;
        this.callback = callback;
    }

    @Override
    protected void initCells() {
        this.addStartEndSpacerCell();
        this.addWidgetCell((AbstractWidget)new ExtendedButton(0, 0, 20, 20, (Component)Component.m_237115_((String)"fancymenu.elements.video_mcef.set_source"), button -> Minecraft.m_91087_().m_91152_(ResourceChooserScreen.video(null, source -> {
            if (source != null) {
                this.background.rawVideoUrlSource = ResourceSource.of(source);
            }
            Minecraft.m_91087_().m_91152_((Screen)this);
        }).setSource(this.background.rawVideoUrlSource != null ? this.background.rawVideoUrlSource.getSerializationSource() : null, false))), true);
        this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.elements.video_mcef.loop", this.background.loop), true, (value, button) -> {
            this.background.loop = value.getAsBoolean();
        });
        this.addWidgetCell((AbstractWidget)new ExtendedButton(0, 0, 20, 20, (Component)Component.m_237115_((String)"fancymenu.elements.video_mcef.volume"), button -> Minecraft.m_91087_().m_91152_((Screen)new SetVideoVolumeScreen(this.background.volume, vol -> {
            if (vol != null) {
                this.background.volume = vol.floatValue();
            }
            Minecraft.m_91087_().m_91152_((Screen)this);
        }))), true);
        LocalizedGenericValueCycle<SoundSource> soundSourceCycle = CommonCycles.cycle("fancymenu.elements.video_mcef.sound_channel", Arrays.asList(SoundSource.values()), this.background.soundSource).setValueNameSupplier(consumes -> I18n.m_118938_((String)("soundCategory." + consumes.m_12676_()), (Object[])new Object[0])).setValueComponentStyleSupplier(consumes -> Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
        this.addCycleButtonCell(soundSourceCycle, true, (value, button) -> {
            this.background.soundSource = value;
        });
        this.addCellGroupEndSpacerCell();
        this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.background.image.configure.parallax", this.background.parallaxEnabled), true, (value, button) -> {
            this.background.parallaxEnabled = value.getAsBoolean();
        });
        this.addWidgetCell((AbstractWidget)new ExtendedButton(0, 0, 0, 20, (Component)Component.m_237115_((String)"fancymenu.background.image.configure.parallax_intensity"), var1 -> {
            Screen currentScreen = Minecraft.m_91087_().f_91080_;
            TextEditorScreen s = TextEditorScreen.build((Component)Component.m_237115_((String)"fancymenu.background.image.configure.parallax_intensity"), null, callback -> {
                if (callback != null) {
                    this.background.parallaxIntensityString = callback;
                }
                Minecraft.m_91087_().m_91152_(currentScreen);
            });
            s.setText(this.background.parallaxIntensityString);
            Minecraft.m_91087_().m_91152_((Screen)s);
        }).setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.background.image.configure.parallax_intensity.desc", new String[0]))), true);
        CellScreen.WidgetCell invertParallaxCell = this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.background.image.configure.invert_parallax", this.background.invertParallax), true, (value, button) -> {
            this.background.invertParallax = value.getAsBoolean();
        });
        AbstractWidget abstractWidget = invertParallaxCell.widget;
        if (abstractWidget instanceof ExtendedButton) {
            ExtendedButton b = (ExtendedButton)abstractWidget;
            b.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.background.image.configure.invert_parallax.desc", new String[0])));
        }
        this.addStartEndSpacerCell();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.doneButton != null) {
            this.doneButton.setTooltipSupplier(consumes -> {
                if (this.background.rawVideoUrlSource == null) {
                    return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.backgrounds.video_mcef.configure.no_video", new String[0]));
                }
                return null;
            });
        }
    }

    @Override
    public boolean allowDone() {
        return this.background.rawVideoUrlSource != null;
    }

    @Override
    protected void onCancel() {
        this.callback.accept(null);
    }

    @Override
    protected void onDone() {
        this.callback.accept(this.background);
    }
}

