uniform sampler2D tex;
uniform vec2 resolution;
uniform float progress;

float gaussian(float x, float sigma) {
    return exp(-(x * x) / (2.0 * sigma * sigma));
}

void main() {
    vec2 uv = gl_FragCoord.xy / resolution;
    vec4 sum = vec4(0.0);
    float w = 0.0;
    for (float i = -10.0; i <= 10.0; i++) {
        float weight = gaussian(i, 10.0);
        sum += texture2D(tex, uv + vec2(i,0)/resolution) * weight;
        w += weight;
    }
    sum /= w;
    gl_FragColor = mix(texture2D(tex, uv), sum, progress);
}
