/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class MinecraftColorConverter {
    private static final Map<Character, ChatFormatting> COLOR_CODES = new HashMap<Character, ChatFormatting>();
    private static final Map<Character, ChatFormatting> FORMAT_CODES = new HashMap<Character, ChatFormatting>();
    private static final Pattern COLOR_PATTERN = Pattern.compile("([&\u00a7])([0-9a-fk-or])", 2);
    private static final Pattern HEX_PATTERN = Pattern.compile("([&\u00a7])#([0-9a-fA-F]{6})", 2);
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("(?:^|(?<!^))#([0-9a-fA-F]{6})(?:([&\u00a7])([0-9a-fk-or]))*([^#|])(?=#|\\||$)");

    public static Component convertToComponent(String text) {
        String suffixPart;
        if (text == null || text.isEmpty()) {
            return Component.m_237113_((String)"");
        }
        text = text.replaceAll("[\\[\\]|]", "");
        String[] parts = text.split("\\|", 2);
        String gradientPart = parts[0];
        String string = suffixPart = parts.length > 1 ? parts[1] : null;
        if (MinecraftColorConverter.isGradientFormat(gradientPart)) {
            return MinecraftColorConverter.parseGradientText(gradientPart, suffixPart);
        }
        String formattedText = MinecraftColorConverter.convertColorCodes(text);
        return Component.m_237113_((String)formattedText);
    }

    public static String convertColorCodes(String text) {
        String suffixPart;
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.replaceAll("[\\[\\]|]", "");
        String[] parts = text.split("\\|", 2);
        String gradientPart = parts[0];
        String string = suffixPart = parts.length > 1 ? parts[1] : null;
        if (MinecraftColorConverter.isGradientFormat(gradientPart)) {
            MutableComponent component = MinecraftColorConverter.parseGradientText(gradientPart, suffixPart);
            return component.getString();
        }
        text = MinecraftColorConverter.processHexColors(text);
        text = MinecraftColorConverter.processStandardColors(text);
        return text;
    }

    private static boolean isGradientFormat(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        return text.contains("#") && GRADIENT_PATTERN.matcher(text).find();
    }

    private static MutableComponent parseGradientText(String gradientText, String suffix) {
        MutableComponent result = Component.m_237113_((String)"");
        if (gradientText == null || gradientText.isEmpty()) {
            return result;
        }
        Pattern pattern = Pattern.compile("#([0-9a-fA-F]{6})((?:[&\u00a7][0-9a-fk-or])*)([^#|\\[\\]])");
        Matcher matcher = pattern.matcher(gradientText);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                String before = gradientText.substring(lastEnd, matcher.start());
                if (!(before = before.replaceAll("[\\[\\]|]", "")).isEmpty()) {
                    result.m_7220_((Component)Component.m_237113_((String)before));
                }
            }
            String hexColor = matcher.group(1);
            String formatCodes = matcher.group(2);
            String character = matcher.group(3);
            if (character.equals("[") || character.equals("]") || character.equals("|")) continue;
            int color = Integer.parseInt(hexColor, 16);
            Style style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)color));
            if (formatCodes != null && !formatCodes.isEmpty()) {
                Pattern formatPattern = Pattern.compile("[&\u00a7]([0-9a-fk-or])");
                Matcher formatMatcher = formatPattern.matcher(formatCodes);
                while (formatMatcher.find()) {
                    char code = formatMatcher.group(1).toLowerCase().charAt(0);
                    ChatFormatting formatting = FORMAT_CODES.get(Character.valueOf(code));
                    if (formatting == null) continue;
                    style = style.m_131157_(formatting);
                }
            }
            result.m_7220_((Component)Component.m_237113_((String)character).m_130948_(style));
            lastEnd = matcher.end();
        }
        if (lastEnd < gradientText.length()) {
            String remaining = gradientText.substring(lastEnd);
            if (!(remaining = remaining.replaceAll("[\\[\\]|]", "")).isEmpty()) {
                result.m_7220_((Component)Component.m_237113_((String)remaining));
            }
        }
        return result;
    }

    private static String processHexColors(String text) {
        Matcher matcher = HEX_PATTERN.matcher(text);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String hexColor = matcher.group(2);
            StringBuilder minecraftHex = new StringBuilder("\u00a7x");
            for (char c : hexColor.toCharArray()) {
                minecraftHex.append("\u00a7").append(Character.toLowerCase(c));
            }
            matcher.appendReplacement(result, minecraftHex.toString());
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String processStandardColors(String text) {
        Matcher matcher = COLOR_PATTERN.matcher(text);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            char code = matcher.group(2).toLowerCase().charAt(0);
            ChatFormatting formatting = COLOR_CODES.get(Character.valueOf(code));
            if (formatting == null) {
                formatting = FORMAT_CODES.get(Character.valueOf(code));
            }
            if (formatting != null) {
                matcher.appendReplacement(result, formatting.toString());
                continue;
            }
            matcher.appendReplacement(result, matcher.group());
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static ChatFormatting findClosestColor(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        ChatFormatting closest = ChatFormatting.WHITE;
        double minDistance = Double.MAX_VALUE;
        for (ChatFormatting color : COLOR_CODES.values()) {
            int colorB;
            int colorG;
            int colorRgb;
            int colorR;
            double distance;
            if (!color.m_126664_() || !((distance = MinecraftColorConverter.colorDistance(r, g, b, colorR = (colorRgb = MinecraftColorConverter.getColorRGB(color)) >> 16 & 0xFF, colorG = colorRgb >> 8 & 0xFF, colorB = colorRgb & 0xFF)) < minDistance)) continue;
            minDistance = distance;
            closest = color;
        }
        return closest;
    }

    private static double colorDistance(int r1, int g1, int b1, int r2, int g2, int b2) {
        return Math.sqrt(Math.pow(r1 - r2, 2.0) + Math.pow(g1 - g2, 2.0) + Math.pow(b1 - b2, 2.0));
    }

    private static int getColorRGB(ChatFormatting color) {
        return switch (color) {
            case ChatFormatting.BLACK -> 0;
            case ChatFormatting.DARK_BLUE -> 170;
            case ChatFormatting.DARK_GREEN -> 43520;
            case ChatFormatting.DARK_AQUA -> 43690;
            case ChatFormatting.DARK_RED -> 0xAA0000;
            case ChatFormatting.DARK_PURPLE -> 0xAA00AA;
            case ChatFormatting.GOLD -> 0xFFAA00;
            case ChatFormatting.GRAY -> 0xAAAAAA;
            case ChatFormatting.DARK_GRAY -> 0x555555;
            case ChatFormatting.BLUE -> 0x5555FF;
            case ChatFormatting.GREEN -> 0x55FF55;
            case ChatFormatting.AQUA -> 0x55FFFF;
            case ChatFormatting.RED -> 0xFF5555;
            case ChatFormatting.LIGHT_PURPLE -> 0xFF55FF;
            case ChatFormatting.YELLOW -> 0xFFFF55;
            case ChatFormatting.WHITE -> 0xFFFFFF;
            default -> 0xFFFFFF;
        };
    }

    public static String stripColorCodes(String text) {
        if (text == null) {
            return "";
        }
        text = text.replaceAll("[&\u00a7][0-9a-fk-or]", "");
        text = text.replaceAll("[&\u00a7]#[0-9a-fA-F]{6}", "");
        return text.trim();
    }

    public static String extractCleanText(String text) {
        if (text == null) {
            return "";
        }
        String[] parts = text.split("\\|");
        if (parts.length > 1) {
            String lastPart = parts[parts.length - 1].trim();
            return MinecraftColorConverter.stripColorCodes(lastPart);
        }
        return MinecraftColorConverter.stripColorCodes(text);
    }

    public static boolean hasComplexFormatting(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        Matcher colorMatcher = COLOR_PATTERN.matcher(text);
        if (colorMatcher.find()) {
            return true;
        }
        Matcher hexMatcher = HEX_PATTERN.matcher(text);
        if (hexMatcher.find()) {
            return true;
        }
        Pattern minecraftHexPattern = Pattern.compile("\u00a7x(\u00a7[0-9a-fA-F]){6}", 2);
        Matcher minecraftHexMatcher = minecraftHexPattern.matcher(text);
        return minecraftHexMatcher.find();
    }

    static {
        COLOR_CODES.put(Character.valueOf('0'), ChatFormatting.BLACK);
        COLOR_CODES.put(Character.valueOf('1'), ChatFormatting.DARK_BLUE);
        COLOR_CODES.put(Character.valueOf('2'), ChatFormatting.DARK_GREEN);
        COLOR_CODES.put(Character.valueOf('3'), ChatFormatting.DARK_AQUA);
        COLOR_CODES.put(Character.valueOf('4'), ChatFormatting.DARK_RED);
        COLOR_CODES.put(Character.valueOf('5'), ChatFormatting.DARK_PURPLE);
        COLOR_CODES.put(Character.valueOf('6'), ChatFormatting.GOLD);
        COLOR_CODES.put(Character.valueOf('7'), ChatFormatting.GRAY);
        COLOR_CODES.put(Character.valueOf('8'), ChatFormatting.DARK_GRAY);
        COLOR_CODES.put(Character.valueOf('9'), ChatFormatting.BLUE);
        COLOR_CODES.put(Character.valueOf('a'), ChatFormatting.GREEN);
        COLOR_CODES.put(Character.valueOf('b'), ChatFormatting.AQUA);
        COLOR_CODES.put(Character.valueOf('c'), ChatFormatting.RED);
        COLOR_CODES.put(Character.valueOf('d'), ChatFormatting.LIGHT_PURPLE);
        COLOR_CODES.put(Character.valueOf('e'), ChatFormatting.YELLOW);
        COLOR_CODES.put(Character.valueOf('f'), ChatFormatting.WHITE);
        FORMAT_CODES.put(Character.valueOf('k'), ChatFormatting.OBFUSCATED);
        FORMAT_CODES.put(Character.valueOf('l'), ChatFormatting.BOLD);
        FORMAT_CODES.put(Character.valueOf('m'), ChatFormatting.STRIKETHROUGH);
        FORMAT_CODES.put(Character.valueOf('n'), ChatFormatting.UNDERLINE);
        FORMAT_CODES.put(Character.valueOf('o'), ChatFormatting.ITALIC);
        FORMAT_CODES.put(Character.valueOf('r'), ChatFormatting.RESET);
    }
}

