/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ru.chibicraft.chibiiscute.render.elem.GifAnim;
import ru.chibicraft.chibiiscute.utils.PhotoLoader;

@OnlyIn(value=Dist.CLIENT)
public class PhotoRender {
    protected final Minecraft mc = Minecraft.m_91087_();
    private final ConcurrentHashMap<String, NativeImage> skinImages = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ResourceLocation> skinImagesStream = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ResourceLocation> finalTextures = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, GifAnim> finalImagesGif = new ConcurrentHashMap();
    private final List<String> startUpload = Collections.synchronizedList(new ArrayList());
    private final List<String> endUpload = Collections.synchronizedList(new ArrayList());
    private static PhotoRender instance;

    public static PhotoRender getInstance() {
        if (instance == null) {
            instance = new PhotoRender();
        }
        return instance;
    }

    public void drawAvatar(GuiGraphics guiGraphics, String username, float xPos, float yPos, float width, float height, float alpha) {
        if (this.finalTextures.containsKey(username = StringUtil.m_14406_((String)username))) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            guiGraphics.m_280163_(this.finalTextures.get(username), (int)xPos, (int)yPos, 0.0f, 0.0f, (int)width, (int)height, (int)width, (int)height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        } else if (this.finalImagesGif.containsKey(username)) {
            this.finalImagesGif.get(username).render(guiGraphics.m_280168_(), xPos, yPos, width, height);
        } else if (this.endUpload.contains(username)) {
            if (this.skinImages.containsKey(username)) {
                DynamicTexture texture = new DynamicTexture(this.skinImages.get(username));
                ResourceLocation textureLocation = new ResourceLocation("chibiiscute", "avatar_" + username.hashCode());
                this.mc.m_91097_().m_118495_(textureLocation, (AbstractTexture)texture);
                this.finalTextures.put(username, textureLocation);
            }
            if (this.skinImagesStream.containsKey(username)) {
                try {
                    this.finalImagesGif.put(username, new GifAnim(this.skinImagesStream.get(username)));
                }
                catch (IOException e) {
                    System.err.println("Failed to load GIF for " + username + ": " + e.getMessage());
                }
            }
        } else if (!this.startUpload.contains(username)) {
            this.startUpload.add(username);
            new Thread(new PhotoLoader(username, this.skinImages, this.endUpload)).start();
            this.renderPlaceholder(guiGraphics, username, xPos, yPos, width, height);
        } else {
            this.renderPlaceholder(guiGraphics, username, xPos, yPos, width, height);
        }
    }

    private void renderPlaceholder(GuiGraphics guiGraphics, String username, float x, float y, float width, float height) {
        int color = username.hashCode() | 0xFF000000;
        guiGraphics.m_280509_((int)x, (int)y, (int)(x + width), (int)(y + height), color);
        String dots = this.getLoadingDots();
        guiGraphics.m_280488_(this.mc.f_91062_, dots, (int)(x + width / 2.0f - (float)(this.mc.f_91062_.m_92895_(dots) / 2)), (int)(y + height / 2.0f - 4.0f), -1);
    }

    private String getLoadingDots() {
        long time = System.currentTimeMillis() / 500L;
        int dotCount = (int)(time % 4L);
        return ".".repeat(dotCount);
    }

    public void clearCache() {
        this.skinImages.clear();
        this.skinImagesStream.clear();
        this.finalTextures.clear();
        this.finalImagesGif.clear();
        this.startUpload.clear();
        this.endUpload.clear();
    }
}

