/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.chibicraft.chibiiscute.handlers.ConfigHandler;

public class PacketUpdateConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String tabHeader;
    private final String avatarUrl;
    private final String skinUrl;
    private final boolean useGroupName;
    private final boolean useColouredBg;
    private final boolean useColorCodes;
    private final boolean drawTPS;
    private final boolean drawRoles;
    private final List<String> roleColorsList;

    public PacketUpdateConfig(String tabHeader, String avatarUrl, String skinUrl, boolean useGroupName, boolean useColouredBg, boolean useColorCodes, boolean drawTPS, boolean drawRoles, List<String> roleColorsList) {
        this.tabHeader = tabHeader;
        this.avatarUrl = avatarUrl;
        this.skinUrl = skinUrl;
        this.useGroupName = useGroupName;
        this.useColouredBg = useColouredBg;
        this.useColorCodes = useColorCodes;
        this.drawTPS = drawTPS;
        this.drawRoles = drawRoles;
        this.roleColorsList = roleColorsList;
    }

    public static void encode(PacketUpdateConfig msg, FriendlyByteBuf buf) {
        try {
            buf.m_130070_(msg.tabHeader != null ? msg.tabHeader : "");
            buf.m_130070_(msg.avatarUrl != null ? msg.avatarUrl : "");
            buf.m_130070_(msg.skinUrl != null ? msg.skinUrl : "");
            buf.writeBoolean(msg.useGroupName);
            buf.writeBoolean(msg.useColouredBg);
            buf.writeBoolean(msg.useColorCodes);
            buf.writeBoolean(msg.drawTPS);
            buf.writeBoolean(msg.drawRoles);
            buf.writeInt(msg.roleColorsList.size());
            for (String colorEntry : msg.roleColorsList) {
                buf.m_130070_(colorEntry != null ? colorEntry : "");
            }
            LOGGER.debug("\u0417\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d \u043f\u0430\u043a\u0435\u0442 \u043a\u043e\u043d\u0444\u0438\u0433\u0430");
        }
        catch (Exception e) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0430\u043a\u0435\u0442\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0430: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static PacketUpdateConfig decode(FriendlyByteBuf buf) {
        try {
            String tabHeader = buf.m_130277_();
            String avatarUrl = buf.m_130277_();
            String skinUrl = buf.m_130277_();
            boolean useGroupName = buf.readBoolean();
            boolean useColouredBg = buf.readBoolean();
            boolean useColorCodes = buf.readBoolean();
            boolean drawTPS = buf.readBoolean();
            boolean drawRoles = buf.readBoolean();
            int colorsCount = buf.readInt();
            ArrayList<String> roleColorsList = new ArrayList<String>();
            for (int i = 0; i < colorsCount; ++i) {
                roleColorsList.add(buf.m_130277_());
            }
            return new PacketUpdateConfig(tabHeader, avatarUrl, skinUrl, useGroupName, useColouredBg, useColorCodes, drawTPS, drawRoles, roleColorsList);
        }
        catch (Exception e) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0430\u043a\u0435\u0442\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0430: {}", (Object)e.getMessage(), (Object)e);
            return new PacketUpdateConfig("", "", "", false, false, false, false, false, new ArrayList<String>());
        }
    }

    public static void handle(PacketUpdateConfig msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            try {
                ConfigHandler.updateClientConfig(msg.tabHeader, msg.avatarUrl, msg.skinUrl, msg.useGroupName, msg.useColouredBg, msg.useColorCodes, msg.drawTPS, msg.drawRoles, msg.roleColorsList);
                LOGGER.debug("\u041a\u043e\u043d\u0444\u0438\u0433 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d \u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0435");
            }
            catch (Exception e) {
                LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043f\u0430\u043a\u0435\u0442\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0430: {}", (Object)e.getMessage(), (Object)e);
            }
        });
        context.setPacketHandled(true);
    }

    public String getTabHeader() {
        return this.tabHeader;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getSkinUrl() {
        return this.skinUrl;
    }

    public boolean isUseGroupName() {
        return this.useGroupName;
    }

    public boolean isUseColouredBg() {
        return this.useColouredBg;
    }

    public boolean isUseColorCodes() {
        return this.useColorCodes;
    }

    public boolean isDrawTPS() {
        return this.drawTPS;
    }

    public boolean isDrawRoles() {
        return this.drawRoles;
    }

    public List<String> getRoleColorsList() {
        return this.roleColorsList;
    }
}

