/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.chibicraft.chibiiscute.handlers.ServerPacketHandler;

public class PacketScreenshotChunk {
    private static final Logger LOGGER = LogManager.getLogger();
    public final String transferId;
    public final int chunkIndex;
    public final byte[] chunkData;

    public PacketScreenshotChunk(String transferId, int chunkIndex, byte[] chunkData) {
        this.transferId = transferId;
        this.chunkIndex = chunkIndex;
        this.chunkData = chunkData;
    }

    public static void encode(PacketScreenshotChunk pkt, FriendlyByteBuf buf) {
        buf.m_130070_(pkt.transferId);
        buf.writeInt(pkt.chunkIndex);
        buf.m_130087_(pkt.chunkData);
    }

    public static PacketScreenshotChunk decode(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        int index = buf.readInt();
        byte[] data = buf.m_130052_();
        return new PacketScreenshotChunk(id, index, data);
    }

    public static void handle(PacketScreenshotChunk pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ServerPacketHandler.addChunk(pkt.transferId, pkt.chunkIndex, pkt.chunkData));
        ctx.get().setPacketHandled(true);
    }
}

