/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class ExplosionFX
extends Particle {
    public static CCModel model;
    public static CCModel model_inv;
    public CoreEffect coreEffect;
    private LinkedList<EffectPart> effectParts = new LinkedList();
    private static final Random rand;
    private static final RenderStateShard.DepthTestStateShard DISABLE_DEPTH;
    public static RenderType EXPLOSION_TYPE;
    public static RenderType FOG_TYPE;
    private final Vector3 pos;
    public final int radius;
    private static final ParticleRenderType FX_HANDLER;

    public ExplosionFX(ClientLevel worldIn, Vector3 pos, int radius) {
        super(worldIn, pos.x, pos.y, pos.z);
        this.pos = pos;
        this.radius = radius;
        this.f_107225_ = 240;
        this.coreEffect = new CoreEffect(0.0);
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5989_() {
        if (this.effectParts.size() > 0) {
            Iterator i = this.effectParts.iterator();
            while (i.hasNext()) {
                EffectPart part = (EffectPart)i.next();
                if (part.isDead()) {
                    i.remove();
                    continue;
                }
                part.update();
            }
        }
        this.coreEffect.update();
        if (this.f_107224_ > this.f_107225_) {
            this.m_107274_();
        }
        if (this.f_107224_ == 0) {
            this.coreEffect = new CoreEffect(0.0);
            ClientEventHandler.triggerExplosionEffect(this.pos.pos(), true);
        } else if (this.f_107224_ == 3 || this.f_107224_ == 8 || this.f_107224_ == 13) {
            this.effectParts.addFirst(new LeadingWave(this.f_107224_));
        } else if (this.f_107224_ > 30 && this.f_107224_ <= 35) {
            this.effectParts.addFirst(new BlastWave(this.f_107224_ - 30));
        }
        if (this.f_107224_ == 10) {
            this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, (SoundEvent)DESounds.FUSION_EXPLOSION.get(), SoundSource.PLAYERS, 100.0f, 0.9f, false);
        }
        ++this.f_107224_;
    }

    public void m_5744_(VertexConsumer b, Camera renderInfo, float partialTicks) {
        Vec3 viewVec = renderInfo.m_90583_();
        Vector3 pos = new Vector3(this.f_107212_ - viewVec.f_82479_, this.f_107213_ - viewVec.f_82480_, this.f_107214_ - viewVec.f_82481_);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = 240;
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer buffer = buffers.m_6299_(FOG_TYPE);
        ccrs.bind(buffer, DefaultVertexFormat.f_85815_);
        float ttl = 1.0f - ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        ttl = Math.min(1.0f, ttl * 5.0f);
        double od = 1200.0;
        double id = (double)this.radius / 100.0;
        ccrs.baseColour = 0xFFFFFF00 | MathHelper.clip((int)((int)(255.0f * (0.15f * ttl * Math.min(1.0f, (float)this.f_107225_ / 25.0f)))), (int)0, (int)255);
        for (double i = 0.0; i < 16.0; i += 1.0) {
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos, (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(od, id * i, od));
            model.render(ccrs, new IVertexOperation[]{mat});
            od += id * i;
        }
        buffers.m_109911_();
        ccrs.baseColour = -1;
        if (!this.coreEffect.isDead()) {
            this.coreEffect.render(pos, ccrs, buffers, partialTicks);
        }
        for (EffectPart part : this.effectParts) {
            part.render(pos, ccrs, buffers, partialTicks);
        }
        ccrs.reset();
    }

    public ParticleRenderType m_7556_() {
        return FX_HANDLER;
    }

    static {
        rand = new Random();
        DISABLE_DEPTH = new RenderStateShard.DepthTestStateShard("none", 519){

            public void m_110185_() {
                RenderSystem.disableDepthTest();
            }
        };
        EXPLOSION_TYPE = RenderType.m_173215_((String)"draconicevolution:explosion_shader", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_173292_(new RenderStateShard.ShaderStateShard(() -> DEShaders.explosionShader)).m_110661_(RenderStateShard.f_110110_).m_110687_(RenderStateShard.f_110115_).m_110663_(DISABLE_DEPTH).m_110691_(false));
        FOG_TYPE = RenderType.m_173215_((String)"draconicevolution:explosion_fog", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_110661_(RenderStateShard.f_110110_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/reactor/reactor_core.obj")).quads().ignoreMtl().parse();
        model = CCModel.combine(map.values());
        model_inv = model.backfacedCopy();
        FX_HANDLER = new FXHandler();
    }

    private class CoreEffect
    extends EffectPart {
        public CoreEffect(double scale) {
            super(scale);
            this.maxAge = 60;
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vector3 pos, CCRenderState ccrs, MultiBufferSource.BufferSource buffers, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (double)ExplosionFX.this.radius / 6.0 * (double)ttl * 2.0;
            float a = (float)this.age + partialTicks;
            VertexConsumer buffer = buffers.m_6299_(EXPLOSION_TYPE);
            ccrs.bind(buffer, DefaultVertexFormat.f_85817_);
            DEShaders.explosionTime.glUniform1f(((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
            DEShaders.explosionScale.glUniform1f(a > 35.0f ? (a - 35.0f) / 20.0f * 2.0f : 0.0f);
            DEShaders.explosionAlpha.glUniform1f(a > 50.0f ? 1.0f - (a - 50.0f) / 10.0f : 1.0f);
            DEShaders.explosionType.glUniform1i(0);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos, (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, scale / 2.0, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            buffers.m_109911_();
        }
    }

    private static abstract class EffectPart {
        private boolean isDead = false;
        protected int age = 0;
        protected int maxAge = 0;
        public double scale;
        public int randOffset;

        public EffectPart(double scale) {
            this.scale = scale;
            this.randOffset = rand.nextInt(3265324);
        }

        public abstract void update();

        public abstract void render(Vector3 var1, CCRenderState var2, MultiBufferSource.BufferSource var3, float var4);

        public void setDead() {
            this.isDead = true;
        }

        public boolean isDead() {
            return this.isDead;
        }
    }

    private class LeadingWave
    extends EffectPart {
        public LeadingWave(double scale) {
            super(scale);
            this.maxAge = 40 + (int)scale;
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vector3 pos, CCRenderState ccrs, MultiBufferSource.BufferSource buffers, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (float)ExplosionFX.this.radius * ttl * 2.0f;
            VertexConsumer buffer = buffers.m_6299_(EXPLOSION_TYPE);
            ccrs.bind(buffer, DefaultVertexFormat.f_85817_);
            DEShaders.explosionTime.glUniform1f(((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
            DEShaders.explosionScale.glUniform1f(ttl * 3.0f);
            DEShaders.explosionAlpha.glUniform1f(1.0f - ttl);
            DEShaders.explosionType.glUniform1i(2);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos, (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, 1.0, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            buffers.m_109911_();
        }
    }

    private class BlastWave
    extends EffectPart {
        public BlastWave(double scale) {
            super(scale);
            this.maxAge = 150 + (int)(scale * 5.0);
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vector3 pos, CCRenderState ccrs, MultiBufferSource.BufferSource buffers, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (float)ExplosionFX.this.radius * ttl * 2.0f;
            double vScale = (double)ExplosionFX.this.radius / 5.0 * (double)ttl * this.scale;
            float a = (float)this.age + partialTicks;
            VertexConsumer buffer = buffers.m_6299_(EXPLOSION_TYPE);
            ccrs.bind(buffer, DefaultVertexFormat.f_85817_);
            DEShaders.explosionTime.glUniform1f(((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
            DEShaders.explosionScale.glUniform1f(ttl);
            DEShaders.explosionAlpha.glUniform1f(a < 40.0f ? (a - 20.0f) / 20.0f : 1.0f - ttl);
            DEShaders.explosionType.glUniform1i(1);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos, (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, vScale, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            buffers.m_109911_();
        }
    }

    public static class FXHandler
    implements ParticleRenderType {
        public void m_6505_(BufferBuilder builder, TextureManager p_217600_2_) {
        }

        public void m_6294_(Tesselator tessellator) {
        }
    }
}

