/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.entities.EnderCollectionEntity;
import com.brandon3055.draconicevolution.api.modules.entities.JunkFilterEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.brandon3055.draconicevolution.lib.WTFException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class ModuleHelper {
    public static void handleItemCollection(Player player, ModuleHost host, IOPStorage storage, InventoryDynamic inventory) {
        ModuleEntity optionalCollector;
        if (player.m_9236_().f_46443_) {
            return;
        }
        Predicate<ItemStack> junkTest = null;
        for (ModuleEntity<?> entity : host.getEntitiesByType(ModuleTypes.JUNK_FILTER).toList()) {
            junkTest = junkTest == null ? ((JunkFilterEntity)entity).createFilterTest() : junkTest.or(((JunkFilterEntity)entity).createFilterTest());
        }
        if (junkTest != null) {
            inventory.removeIf(junkTest);
        }
        if ((optionalCollector = (ModuleEntity)host.getEntitiesByType(ModuleTypes.ENDER_COLLECTION).findAny().orElse(null)) instanceof EnderCollectionEntity) {
            EnderCollectionEntity collector = (EnderCollectionEntity)optionalCollector;
            List<ItemStack> remainder = collector.insertStacks(player, inventory.getStacks(), storage);
            inventory.setStacks(new LinkedList<ItemStack>(remainder));
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack sis = inventory.m_8020_(i);
            if (sis == null) continue;
            ItemEntity item = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), sis);
            item.m_32010_(0);
            player.m_9236_().m_7967_((Entity)item);
        }
        player.m_6756_(inventory.xp);
        inventory.m_6211_();
    }

    public static List<ItemStack> getEquippedHostItems(LivingEntity entity) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(EquipmentManager.findItems(e -> {
            IModularItem item;
            Item patt3125$temp = e.m_41720_();
            return patt3125$temp instanceof IModularItem && (item = (IModularItem)patt3125$temp).isEquipped((ItemStack)e, null, true);
        }, entity));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            IModularItem item;
            Item item2;
            ItemStack stack = entity.m_6844_(slot);
            if (stack.m_41619_() || !((item2 = stack.m_41720_()) instanceof IModularItem) || !(item = (IModularItem)item2).isEquipped(stack, slot, false)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static FastStream<ModuleHost> getEquippedHosts(LivingEntity entity) {
        return FastStream.of(ModuleHelper.getEquippedHostItems(entity)).map(e -> e.getCapability(DECapabilities.MODULE_HOST_CAPABILITY)).filter(LazyOptional::isPresent).map(e -> (ModuleHost)e.orElseThrow(WTFException::new));
    }

    public static <T extends ModuleData<T>> T getCombinedEquippedData(LivingEntity entity, ModuleType<T> moduleType, T fallback) {
        return (T)((ModuleData)ModuleHelper.getEquippedHosts(entity).map(e -> e.getModuleData(moduleType)).filter(Objects::nonNull).fold(fallback, ModuleData::combine));
    }

    public static <T extends ModuleData<T>> List<T> getEquippedModules(LivingEntity entity, ModuleType<T> moduleType) {
        return ModuleHelper.getEquippedHosts(entity).map(e -> e.getModuleData(moduleType)).filter(Objects::nonNull).toList();
    }
}

