/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventorySimple
implements Container {
    public ItemStack[] items;
    public int limit;
    public String name;

    public InventorySimple(ItemStack[] items, int limit, String name) {
        this.items = items;
        ArrayUtils.fillArray(items, ItemStack.f_41583_, Objects::isNull);
        this.limit = limit;
        this.name = name;
    }

    public InventorySimple(ItemStack[] items, String name) {
        this(items, 64, name);
    }

    public InventorySimple(ItemStack[] items, int limit) {
        this(items, limit, "inv");
    }

    public InventorySimple(ItemStack[] items) {
        this(items, 64, "inv");
    }

    public InventorySimple(int size, int limit, String name) {
        this(new ItemStack[size], limit, name);
    }

    public InventorySimple(int size, int limit) {
        this(size, limit, "inv");
    }

    public InventorySimple(int size, String name) {
        this(size, 64, name);
    }

    public InventorySimple(int size) {
        this(size, 64, "inv");
    }

    public int m_6643_() {
        return this.items.length;
    }

    public boolean m_7983_() {
        return ArrayUtils.count(this.items, stack -> !stack.m_41619_()) <= 0;
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        return this.items[slot];
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int amount) {
        return InventoryUtils.decrStackSize(this, slot, amount);
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        return InventoryUtils.removeStackFromSlot(this, slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.m_6596_();
    }

    public int m_6893_() {
        return this.limit;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public boolean m_7013_(int i, ItemStack itemstack) {
        return true;
    }

    public void m_6596_() {
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public void m_6211_() {
        Arrays.fill(this.items, ItemStack.f_41583_);
    }
}

