/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class MCDataByteBuf
implements MCDataInput,
MCDataOutput {
    protected final ByteBuf buf;

    public MCDataByteBuf() {
        this(Unpooled.buffer());
    }

    public MCDataByteBuf(ByteBuf buf) {
        this.buf = buf;
    }

    public FriendlyByteBuf toPacketBuffer() {
        return this.buf instanceof FriendlyByteBuf ? (FriendlyByteBuf)this.buf : new FriendlyByteBuf(this.buf);
    }

    public Tag toTag() {
        return new ByteArrayTag(this.buf.array());
    }

    public static MCDataByteBuf fromTag(Tag tag) {
        if (!(tag instanceof ByteArrayTag)) {
            throw new IllegalArgumentException("Expected ByteArrayNBT, got: " + tag.getClass().getSimpleName());
        }
        return new MCDataByteBuf(Unpooled.copiedBuffer((byte[])((ByteArrayTag)tag).m_128227_()));
    }

    public CompoundTag writeToNBT(CompoundTag tag, String key) {
        tag.m_128365_(key, this.toTag());
        return tag;
    }

    public static MCDataByteBuf readFromNBT(CompoundTag tag, String key) {
        return MCDataByteBuf.fromTag(tag.m_128423_(key));
    }

    @Override
    public byte readByte() {
        return this.buf.readByte();
    }

    @Override
    public short readUByte() {
        return this.buf.readUnsignedByte();
    }

    @Override
    public char readChar() {
        return this.buf.readChar();
    }

    @Override
    public short readShort() {
        return this.buf.readShort();
    }

    @Override
    public int readUShort() {
        return this.buf.readUnsignedShort();
    }

    @Override
    public int readInt() {
        return this.buf.readInt();
    }

    @Override
    public long readLong() {
        return this.buf.readLong();
    }

    @Override
    public float readFloat() {
        return this.buf.readFloat();
    }

    @Override
    public double readDouble() {
        return this.buf.readDouble();
    }

    @Override
    public boolean readBoolean() {
        return this.buf.readBoolean();
    }

    @Override
    public MCDataOutput writeByte(int b) {
        this.buf.writeByte(b);
        return this;
    }

    @Override
    public MCDataOutput writeChar(int c) {
        this.buf.writeChar(c);
        return this;
    }

    @Override
    public MCDataOutput writeShort(int s) {
        this.buf.writeShort(s);
        return this;
    }

    @Override
    public MCDataOutput writeInt(int i) {
        this.buf.writeInt(i);
        return this;
    }

    @Override
    public MCDataOutput writeLong(long l) {
        this.buf.writeLong(l);
        return this;
    }

    @Override
    public MCDataOutput writeFloat(float f) {
        this.buf.writeFloat(f);
        return this;
    }

    @Override
    public MCDataOutput writeDouble(double d) {
        this.buf.writeDouble(d);
        return this;
    }

    @Override
    public MCDataOutput writeBoolean(boolean b) {
        this.buf.writeBoolean(b);
        return this;
    }
}

