/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.math.MatrixUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.common.extensions.IForgeTransformation;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class Transformation
implements IForgeTransformation {
    private final Matrix4f f_121078_;
    public static final Codec<Transformation> f_268453_ = RecordCodecBuilder.create(p_269604_ -> p_269604_.group((App)ExtraCodecs.f_252432_.fieldOf("translation").forGetter(p_269599_ -> p_269599_.f_121080_), (App)ExtraCodecs.f_268538_.fieldOf("left_rotation").forGetter(p_269600_ -> p_269600_.f_121081_), (App)ExtraCodecs.f_252432_.fieldOf("scale").forGetter(p_269603_ -> p_269603_.f_121082_), (App)ExtraCodecs.f_268538_.fieldOf("right_rotation").forGetter(p_269598_ -> p_269598_.f_121083_)).apply((Applicative)p_269604_, Transformation::new));
    public static final Codec<Transformation> f_268620_ = Codec.either(f_268453_, (Codec)ExtraCodecs.f_268748_.xmap(Transformation::new, Transformation::m_252783_)).xmap(p_269605_ -> (Transformation)p_269605_.map(p_269601_ -> p_269601_, p_269602_ -> p_269602_), Either::left);
    private boolean f_121079_;
    @Nullable
    private Vector3f f_121080_;
    @Nullable
    private Quaternionf f_121081_;
    @Nullable
    private Vector3f f_121082_;
    @Nullable
    private Quaternionf f_121083_;
    private static final Transformation f_121084_ = Util.m_137537_(() -> {
        Transformation transformation = new Transformation(new Matrix4f());
        transformation.f_121080_ = new Vector3f();
        transformation.f_121081_ = new Quaternionf();
        transformation.f_121082_ = new Vector3f(1.0f, 1.0f, 1.0f);
        transformation.f_121083_ = new Quaternionf();
        transformation.f_121079_ = true;
        return transformation;
    });
    private Matrix3f normalTransform = null;

    public Transformation(@Nullable Matrix4f p_253689_) {
        this.f_121078_ = p_253689_ == null ? new Matrix4f() : p_253689_;
    }

    public Transformation(@Nullable Vector3f p_253831_, @Nullable Quaternionf p_253846_, @Nullable Vector3f p_254502_, @Nullable Quaternionf p_253912_) {
        this.f_121078_ = Transformation.m_253227_(p_253831_, p_253846_, p_254502_, p_253912_);
        this.f_121080_ = p_253831_ != null ? p_253831_ : new Vector3f();
        this.f_121081_ = p_253846_ != null ? p_253846_ : new Quaternionf();
        this.f_121082_ = p_254502_ != null ? p_254502_ : new Vector3f(1.0f, 1.0f, 1.0f);
        this.f_121083_ = p_253912_ != null ? p_253912_ : new Quaternionf();
        this.f_121079_ = true;
    }

    public static Transformation m_121093_() {
        return f_121084_;
    }

    public Transformation m_121096_(Transformation p_121097_) {
        Matrix4f matrix4f = this.m_252783_();
        matrix4f.mul((Matrix4fc)p_121097_.m_252783_());
        return new Transformation(matrix4f);
    }

    @Nullable
    public Transformation m_121103_() {
        if (this == f_121084_) {
            return this;
        }
        Matrix4f matrix4f = this.m_252783_().invert();
        return matrix4f.isFinite() ? new Transformation(matrix4f) : null;
    }

    private void m_121106_() {
        if (!this.f_121079_) {
            float f = 1.0f / this.f_121078_.m33();
            Triple triple = MatrixUtil.m_253103_((Matrix3f)new Matrix3f((Matrix4fc)this.f_121078_).scale(f));
            this.f_121080_ = this.f_121078_.getTranslation(new Vector3f()).mul(f);
            this.f_121081_ = new Quaternionf((Quaternionfc)triple.getLeft());
            this.f_121082_ = new Vector3f((Vector3fc)triple.getMiddle());
            this.f_121083_ = new Quaternionf((Quaternionfc)triple.getRight());
            this.f_121079_ = true;
        }
    }

    private static Matrix4f m_253227_(@Nullable Vector3f p_254465_, @Nullable Quaternionf p_254416_, @Nullable Vector3f p_254499_, @Nullable Quaternionf p_254334_) {
        Matrix4f matrix4f = new Matrix4f();
        if (p_254465_ != null) {
            matrix4f.translation((Vector3fc)p_254465_);
        }
        if (p_254416_ != null) {
            matrix4f.rotate((Quaternionfc)p_254416_);
        }
        if (p_254499_ != null) {
            matrix4f.scale((Vector3fc)p_254499_);
        }
        if (p_254334_ != null) {
            matrix4f.rotate((Quaternionfc)p_254334_);
        }
        return matrix4f;
    }

    public Matrix4f m_252783_() {
        return new Matrix4f((Matrix4fc)this.f_121078_);
    }

    public Vector3f m_252829_() {
        this.m_121106_();
        return new Vector3f((Vector3fc)this.f_121080_);
    }

    public Quaternionf m_253244_() {
        this.m_121106_();
        return new Quaternionf((Quaternionfc)this.f_121081_);
    }

    public Vector3f m_252900_() {
        this.m_121106_();
        return new Vector3f((Vector3fc)this.f_121082_);
    }

    public Quaternionf m_252848_() {
        this.m_121106_();
        return new Quaternionf((Quaternionfc)this.f_121083_);
    }

    public boolean equals(Object p_121108_) {
        if (this == p_121108_) {
            return true;
        }
        if (p_121108_ != null && this.getClass() == p_121108_.getClass()) {
            Transformation transformation = (Transformation)p_121108_;
            return Objects.equals(this.f_121078_, transformation.f_121078_);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.f_121078_);
    }

    public Matrix3f getNormalMatrix() {
        this.checkNormalTransform();
        return this.normalTransform;
    }

    private void checkNormalTransform() {
        if (this.normalTransform == null) {
            this.normalTransform = new Matrix3f((Matrix4fc)this.f_121078_);
            this.normalTransform.invert();
            this.normalTransform.transpose();
        }
    }

    public Transformation m_175937_(Transformation p_175938_, float p_175939_) {
        Vector3f vector3f = this.m_252829_();
        Quaternionf quaternionf = this.m_253244_();
        Vector3f vector3f1 = this.m_252900_();
        Quaternionf quaternionf1 = this.m_252848_();
        vector3f.lerp((Vector3fc)p_175938_.m_252829_(), p_175939_);
        quaternionf.slerp((Quaternionfc)p_175938_.m_253244_(), p_175939_);
        vector3f1.lerp((Vector3fc)p_175938_.m_252900_(), p_175939_);
        quaternionf1.slerp((Quaternionfc)p_175938_.m_252848_(), p_175939_);
        return new Transformation(vector3f, quaternionf, vector3f1, quaternionf1);
    }
}

