/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.compat.filesystem;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.launch.ClassLoaderControl;

public class FileSystemFixer {
    public static void run(ClassLoaderControl classLoaderControl) {
        MethodHandles.Lookup lookup = classLoaderControl.getHackLookup();
        if (lookup == null) {
            throw new RuntimeException("Hacks not enabled");
        }
        try {
            ModuleLayer.Controller controller;
            List<FileSystemProvider> installed = new ArrayList<FileSystemProvider>(FileSystemProvider.installedProviders());
            if (LogHelper.isDevEnabled()) {
                for (FileSystemProvider e : installed) {
                    LogHelper.dev((String)"Already installed: %s", (Object[])new Object[]{e.getClass().getName()});
                }
            }
            ServiceLoader<FileSystemProvider> serviceLoader = (controller = (ModuleLayer.Controller)classLoaderControl.getJava9ModuleController()) != null ? ServiceLoader.load(controller.layer(), FileSystemProvider.class) : ServiceLoader.load(FileSystemProvider.class, FileSystemFixer.class.getClassLoader());
            for (FileSystemProvider e : serviceLoader) {
                installed.add(e);
            }
            if (LogHelper.isDevEnabled()) {
                for (FileSystemProvider e : installed) {
                    LogHelper.dev((String)"After install: %s", (Object[])new Object[]{e.getClass().getName()});
                }
            }
            installed = Collections.unmodifiableList(installed);
            lookup.findStaticSetter(FileSystemProvider.class, "installedProviders", List.class).invoke(installed);
            Object factory = lookup.findStaticGetter(URL.class, "factory", URLStreamHandlerFactory.class).invoke();
            if (factory != null) {
                LogHelper.warning((String)"Found URL.factory %s", (Object[])new Object[]{factory.getClass().getName()});
                URLStreamHandlerFactory object = null;
                lookup.findStaticSetter(URL.class, "factory", URLStreamHandlerFactory.class).invoke(object);
            }
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
        }
    }
}

