/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.launcher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.launcher.GenericGameProfile;
import com.mojang.authlib.launcher.GenericProperty;
import com.mojang.authlib.launcher.InlineLoaderUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import pro.gravit.launcher.base.api.ConfigService;
import pro.gravit.launcher.base.profiles.PlayerProfile;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.base.request.auth.CheckServerRequest;
import pro.gravit.launcher.base.request.auth.JoinServerRequest;
import pro.gravit.launcher.base.request.uuid.ProfileByUUIDRequest;
import pro.gravit.launcher.base.request.uuid.ProfileByUsernameRequest;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LauncherUtils {
    public static String SESSION_HARDWARE_ID_PROPERTY;
    public static String SESSION_ID_PROPERTY;
    public static String SESSION_BASE_PROPERTY;
    private static Gson GSON;

    public static void error(Throwable e) {
        LogHelper.error((Throwable)e);
    }

    public static void debug(String format, Object ... args) {
        LogHelper.debug((String)format, (Object[])args);
    }

    public static CompletableFuture<GenericGameProfile> findByUsername(String username) {
        return LauncherUtils.request(new ProfileByUsernameRequest(username)).thenApply(event -> LauncherUtils.toGeneticGameProfile(event.playerProfile));
    }

    public static CompletableFuture<GenericGameProfile> findByUUID(UUID uuid) {
        return LauncherUtils.request(new ProfileByUUIDRequest(uuid)).thenApply(event -> LauncherUtils.toGeneticGameProfile(event.playerProfile));
    }

    public static CompletableFuture<Boolean> joinServerAsync(String username, String accessToken, String serverId) {
        return LauncherUtils.request(new JoinServerRequest(username, accessToken, serverId)).thenApply(event -> event.allow);
    }

    public static CompletableFuture<Boolean> joinServerAsync(UUID uuid, String accessToken, String serverId) {
        return LauncherUtils.request(new JoinServerRequest(uuid, accessToken, serverId)).thenApply(event -> event.allow);
    }

    public static CompletableFuture<GenericGameProfile> checkServerAsync(String username, String serverID, String ip) {
        CheckServerRequest request = new CheckServerRequest(username, serverID, ConfigService.checkServerConfig.needHardware, ConfigService.checkServerConfig.needProperties);
        return LauncherUtils.request(request).thenApply(event -> {
            HashMap<String, GenericProperty> properties = new HashMap<String, GenericProperty>();
            LauncherUtils.pushProperty(properties, SESSION_ID_PROPERTY, event.sessionId);
            LauncherUtils.pushProperty(properties, SESSION_HARDWARE_ID_PROPERTY, event.hardwareId);
            if (event.sessionProperties != null) {
                for (Map.Entry e : event.sessionProperties.entrySet()) {
                    LauncherUtils.pushProperty(properties, SESSION_BASE_PROPERTY.concat((String)e.getKey()), (String)e.getValue());
                }
            }
            LauncherUtils.pushPlayerProfileProperties(properties, event.playerProfile);
            return new GenericGameProfile(event.playerProfile.username, event.playerProfile.uuid, properties);
        });
    }

    private static <T extends WebSocketEvent> CompletableFuture<T> request(Request<T> var1) {
        try {
            return Request.getRequestService().request(var1);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private static GenericGameProfile toGeneticGameProfile(PlayerProfile playerProfile) {
        HashMap<String, GenericProperty> properties = new HashMap<String, GenericProperty>();
        LauncherUtils.pushPlayerProfileProperties(properties, playerProfile);
        return new GenericGameProfile(playerProfile.username, playerProfile.uuid, properties);
    }

    private static void pushPlayerProfileProperties(Map<String, GenericProperty> properties, PlayerProfile playerProfile) {
        if (playerProfile.properties != null) {
            for (Map.Entry e : playerProfile.properties.entrySet()) {
                LauncherUtils.pushProperty(properties, (String)e.getKey(), (String)e.getValue());
            }
        }
        LauncherUtils.pushProperty(properties, LauncherUtils.makeTexturesProperty(playerProfile));
    }

    private static void pushProperty(Map<String, GenericProperty> properties, GenericProperty property) {
        if (property == null) {
            return;
        }
        properties.put(property.name(), property);
    }

    private static void pushProperty(Map<String, GenericProperty> properties, String name, String value) {
        if (value == null) {
            return;
        }
        properties.put(name, new GenericProperty(name, value, ""));
    }

    public static GenericProperty makeTexturesProperty(PlayerProfile playerProfile) {
        Map textures = playerProfile.assets;
        HashMap<String, GenericTexture> genericTextures = new HashMap<String, GenericTexture>();
        for (Map.Entry e : textures.entrySet()) {
            genericTextures.put((String)e.getKey(), LauncherUtils.toGenericTexture((Texture)e.getValue()));
        }
        MinecraftTexturesProperty property = new MinecraftTexturesProperty();
        property.timestamp = System.currentTimeMillis();
        property.profileId = playerProfile.uuid.toString().replace("-", "");
        property.profileName = playerProfile.username;
        property.isPublic = true;
        property.textures = genericTextures;
        String encoded = GSON.toJson((Object)property);
        String base64 = Base64.getEncoder().encodeToString(encoded.getBytes(StandardCharsets.UTF_8));
        return new GenericProperty("textures", base64, "");
    }

    public static Map<String, GenericTexture> parseTexturesProperty(String value) {
        String decoded = new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
        MinecraftTexturesProperty property = (MinecraftTexturesProperty)GSON.fromJson(decoded, MinecraftTexturesProperty.class);
        return property.textures;
    }

    private static GenericTexture toGenericTexture(Texture texture) {
        return new GenericTexture(texture.url, SecurityHelper.toHex((byte[])texture.digest), texture.metadata);
    }

    static {
        InlineLoaderUtils.load();
        SESSION_HARDWARE_ID_PROPERTY = "session_hardware_id";
        SESSION_ID_PROPERTY = "session_id";
        SESSION_BASE_PROPERTY = "session_";
        GSON = new GsonBuilder().create();
    }

    public static class GenericTexture {
        private final String url;
        private final String hash;
        private final Map<String, String> metadata;

        public GenericTexture(String url, String hash, Map<String, String> metadata) {
            this.url = url;
            this.hash = hash;
            this.metadata = metadata;
        }

        public String getUrl() {
            return this.url;
        }

        public String getHash() {
            return this.hash;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }

    public static class MinecraftTexturesProperty {
        public long timestamp;
        public String profileId;
        public String profileName;
        public boolean isPublic;
        public Map<String, GenericTexture> textures;

        public MinecraftTexturesProperty() {
        }

        public MinecraftTexturesProperty(long timestamp, String profileId, String profileName, boolean isPublic, Map<String, GenericTexture> textures) {
            this.timestamp = timestamp;
            this.profileId = profileId;
            this.profileName = profileName;
            this.isPublic = isPublic;
            this.textures = textures;
        }
    }
}

