/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.gtnewhorizons.wdmla.util.FormatUtil;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class DisplayUtil {
    private static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    private static final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    private static final RenderItem renderItem = new RenderItem();

    public static String stripSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternMinecraft.matcher(result).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static String stripWailaSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    @Deprecated
    public static void renderStack(int x, int y, ItemStack stack) {
        DisplayUtil.enable3DRender();
        try {
            renderItem.func_82406_b(fontRenderer, textureManager, stack, x, y);
            renderItem.func_77021_b(fontRenderer, textureManager, stack, x, y);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            WailaExceptionHandler.handleErr(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    public static void enable3DRender() {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public static void enable2DRender() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    @NotNull
    public static List<String> itemDisplayNameMultiline(@NotNull ItemStack itemstack) {
        ArrayList<String> namelist = null;
        try {
            namelist = itemstack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<String>();
        }
        if (namelist.isEmpty()) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).isEmpty()) {
            namelist.set(0, "Unnamed");
        }
        String rarityColor = itemstack.func_77973_b() != null ? itemstack.func_77953_t().field_77937_e.toString() : "";
        namelist.set(0, rarityColor + (String)namelist.get(0));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, "\u00a77" + (String)namelist.get(i));
        }
        return namelist;
    }

    @NotNull
    public static String itemDisplayNameShortFormatted(@NotNull ItemStack itemstack) {
        List<String> list = DisplayUtil.itemDisplayNameMultiline(itemstack);
        return FormatUtil.formatNameByPixelCount(list.get(0));
    }

    @Deprecated
    @NotNull
    public static String itemDisplayNameShort(@NotNull ItemStack itemstack) {
        List<String> list = DisplayUtil.itemDisplayNameMultiline(itemstack);
        return list.get(0);
    }
}

