/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.wailacompat;

import com.gtnewhorizons.wdmla.api.ITTRenderParser;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ui.component.VPanelComponent;
import com.gtnewhorizons.wdmla.wailacompat.parser.HealthArgsParser;
import com.gtnewhorizons.wdmla.wailacompat.parser.IconArgsParser;
import com.gtnewhorizons.wdmla.wailacompat.parser.ItemArgsParser;
import com.gtnewhorizons.wdmla.wailacompat.parser.ProgressArgsParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.overlay.DisplayUtil;

public class TooltipCompat {
    private final ITTRenderParser healthParser = new HealthArgsParser();
    private final ITTRenderParser itemParser = new ItemArgsParser();
    private final ITTRenderParser progressParser = new ProgressArgsParser();
    private final ITTRenderParser iconParser = new IconArgsParser();

    public ITooltip computeRenderables(List<String> legacyTextData) {
        VPanelComponent verticalLayout = new VPanelComponent();
        ArrayList<ArrayList<String>> lines = new ArrayList<ArrayList<String>>();
        for (String s : legacyTextData) {
            ArrayList<String> line = new ArrayList<String>(Arrays.asList(SpecialChars.patternTab.split(s)));
            lines.add(line);
        }
        for (int i = 0; i < lines.size(); ++i) {
            ITooltip lineComponent = verticalLayout.horizontal();
            for (int c = 0; c < ((ArrayList)lines.get(i)).size(); ++c) {
                String currentLine = (String)((ArrayList)lines.get(i)).get(c);
                Matcher lineMatcher = SpecialChars.patternLineSplit.matcher(currentLine);
                while (lineMatcher.find()) {
                    String cs = lineMatcher.group();
                    Matcher renderMatcher = SpecialChars.patternRender.matcher(cs);
                    Matcher iconMatcher = SpecialChars.patternIcon.matcher(cs);
                    if (renderMatcher.find()) {
                        String renderName;
                        switch (renderName = renderMatcher.group("name")) {
                            case "waila.health": {
                                String[] healthArgs = renderMatcher.group("args").split(",");
                                lineComponent.child(this.healthParser.parse(healthArgs));
                                break;
                            }
                            case "waila.stack": {
                                String[] itemArgs = renderMatcher.group("args").split(",");
                                lineComponent.child(this.itemParser.parse(itemArgs));
                                break;
                            }
                            case "waila.progress": {
                                String[] progressArgs = renderMatcher.group("args").split(",");
                                lineComponent.child(this.progressParser.parse(progressArgs));
                                break;
                            }
                        }
                        continue;
                    }
                    if (iconMatcher.find()) {
                        String iconArg = iconMatcher.group("type");
                        lineComponent.child(this.iconParser.parse(new String[]{iconArg}));
                        continue;
                    }
                    lineComponent.text(DisplayUtil.stripWailaSymbols(cs));
                }
            }
        }
        return verticalLayout;
    }
}

