/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IEntityComponentProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ui.component.TextComponent;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import cpw.mods.fml.common.registry.VillagerRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public enum VillagerProfessionProvider implements IEntityComponentProvider
{
    INSTANCE;

    private static final String[] VANILLA_VILLAGERS;

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor) {
        Entity entity = accessor.getEntity();
        if (entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            String name = VillagerProfessionProvider.getVillagerName(villager.func_70946_n());
            tooltip.child(new TextComponent(StatCollector.func_74838_a((String)("hud.msg.wdmla.villager.profession." + name))).tag(VanillaIdentifiers.VILLAGER_PROFESSION));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.VILLAGER_PROFESSION;
    }

    public static String getVillagerName(int id) {
        ResourceLocation skin = VillagerRegistry.getVillagerSkin((int)id, null);
        if (id >= 0 && id <= 4) {
            return VANILLA_VILLAGERS[id];
        }
        if (skin != null) {
            String path = skin.func_110623_a();
            return skin.func_110624_b() + "." + path.substring(path.lastIndexOf("/") + 1, path.length() - 4);
        }
        return "nodata";
    }

    static {
        VANILLA_VILLAGERS = new String[]{"farmer", "librarian", "priest", "blacksmith", "butcher"};
    }
}

