/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.impl.format.TimeFormattingPattern;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.impl.ui.component.HPanelComponent;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public enum RedstoneStateProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
        Block block = accessor.getBlock();
        if (block instanceof BlockLever && PluginsConfig.vanilla.redstoneState.showLeverState) {
            IComponent redstoneOn = (accessor.getMetadata() & 8) == 0 ? ThemeHelper.INSTANCE.failure(StatCollector.func_74838_a((String)"hud.msg.wdmla.off")) : ThemeHelper.INSTANCE.success(StatCollector.func_74838_a((String)"hud.msg.wdmla.on"));
            tooltip.child(new HPanelComponent().text(String.format("%s: ", StatCollector.func_74838_a((String)"hud.msg.wdmla.state"))).child(redstoneOn).tag(VanillaIdentifiers.REDSTONE_STATE));
        } else if (block instanceof BlockRedstoneRepeater && PluginsConfig.vanilla.redstoneState.showRepeaterDelay) {
            int tick = (accessor.getMetadata() >> 2) + 1;
            tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.delay"), TimeFormattingPattern.ALWAYS_TICK.tickFormatter.apply(tick)).tag(VanillaIdentifiers.REDSTONE_STATE));
        } else if (block instanceof BlockRedstoneComparator && PluginsConfig.vanilla.redstoneState.showComparatorMode) {
            String mode = (accessor.getMetadata() >> 2 & 1) == 0 ? StatCollector.func_74838_a((String)"hud.msg.wdmla.comparator") : StatCollector.func_74838_a((String)"hud.msg.wdmla.substractor");
            tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.mode"), mode).tag(VanillaIdentifiers.REDSTONE_STATE));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.REDSTONE_STATE;
    }
}

