/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.world.NoteBlockEvent;
import org.apache.commons.lang3.StringUtils;

public enum NoteBlockProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final String[] PITCH;
    private static final String[] OCTAVE;
    private static final Map<Material, NoteBlockEvent.Instrument> INSTRUMENTS;

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
        if (accessor.getServerData().func_74764_b("note")) {
            int x = accessor.getHitResult().field_72311_b;
            int y = accessor.getHitResult().field_72312_c - 1;
            int z = accessor.getHitResult().field_72309_d;
            Material material = accessor.getWorld().func_147439_a(x, y, z).func_149688_o();
            NoteBlockEvent.Instrument instrument = INSTRUMENTS.get(material);
            if (instrument == null) {
                instrument = NoteBlockEvent.Instrument.PIANO;
            }
            String instrumentKey = "hud.msg.wdmla.instrument." + StringUtils.lowerCase((String)instrument.toString());
            byte note = accessor.getServerData().func_74771_c("note");
            String pitch = PITCH[note % PITCH.length];
            String octave = OCTAVE[note / PITCH.length];
            tooltip.text(String.format("%s %s", StatCollector.func_74838_a((String)instrumentKey), octave + pitch));
        }
    }

    @Override
    public void appendServerData(NBTTagCompound data, BlockAccessor accessor) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof TileEntityNote) {
            TileEntityNote note = (TileEntityNote)tileEntity;
            note.func_145841_b(data);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.NOTE_BLOCK;
    }

    static {
        PITCH = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};
        OCTAVE = new String[]{SpecialChars.WHITE, SpecialChars.YELLOW, SpecialChars.GOLD};
        INSTRUMENTS = new HashMap<Material, NoteBlockEvent.Instrument>(){
            {
                this.put(Material.field_151576_e, NoteBlockEvent.Instrument.BASSDRUM);
                this.put(Material.field_151595_p, NoteBlockEvent.Instrument.SNARE);
                this.put(Material.field_151592_s, NoteBlockEvent.Instrument.CLICKS);
                this.put(Material.field_151575_d, NoteBlockEvent.Instrument.BASSGUITAR);
            }
        };
    }
}

