/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public enum FurnaceProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
        IComponent progressComponent;
        ItemStack resultStack;
        short cookTime = accessor.getServerData().func_74765_d("CookTime");
        ItemStack[] items = new ItemStack[3];
        NBTTagList itemsTag = accessor.getServerData().func_150295_c("Items", 10);
        boolean allEmpty = true;
        for (int i = 0; i < itemsTag.func_74745_c(); ++i) {
            NBTTagCompound itemTag = itemsTag.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= items.length) continue;
            items[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            if (items[slot] == null) continue;
            allEmpty = false;
        }
        if (items[0] != null && items[2] == null && (resultStack = FurnaceRecipes.func_77602_a().func_151395_a(items[0])) != null) {
            items[2] = resultStack.func_77946_l();
            items[2].field_77994_a = 0;
        }
        if (!allEmpty && (progressComponent = ThemeHelper.INSTANCE.furnaceLikeProgress(Arrays.asList(items[0], items[1]), Arrays.asList(items[2]), cookTime, 200, accessor.showDetails())) != null) {
            tooltip.child(progressComponent.tag(VanillaIdentifiers.FURNACE));
        }
    }

    @Override
    public void appendServerData(NBTTagCompound data, BlockAccessor accessor) {
        if (accessor.getTileEntity() != null) {
            accessor.getTileEntity().func_145841_b(data);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.FURNACE;
    }
}

