/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.universal;

import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ItemIterator<T> {
    public static final AtomicLong version = new AtomicLong();
    protected final Function<Accessor, @Nullable T> containerFinder;
    protected final int fromIndex;
    protected boolean finished;
    protected int currentIndex;

    protected ItemIterator(Function<Accessor, @Nullable T> containerFinder, int fromIndex) {
        this.containerFinder = containerFinder;
        this.currentIndex = this.fromIndex = fromIndex;
    }

    @Nullable
    public T find(Accessor accessor) {
        return this.containerFinder.apply(accessor);
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public long getVersion(T container) {
        return version.getAndIncrement();
    }

    public abstract Stream<ItemStack> populate(T var1, int var2);

    public void reset() {
        this.currentIndex = this.fromIndex;
        this.finished = false;
    }

    public void afterPopulate(int count) {
        this.currentIndex += count;
        if (count == 0 || this.currentIndex >= 10000) {
            this.finished = true;
        }
    }

    public float getCollectingProgress() {
        return Float.NaN;
    }

    public static abstract class SlotlessItemIterator<T>
    extends ItemIterator<T> {
        protected SlotlessItemIterator(Function<Accessor, @Nullable T> containerFinder, int fromIndex) {
            super(containerFinder, fromIndex);
        }

        @Override
        public Stream<ItemStack> populate(T container, int amount) {
            return this.populateRaw(container).skip(this.currentIndex).limit(amount);
        }

        protected abstract Stream<ItemStack> populateRaw(T var1);
    }

    public static class IInventoryItemIterator
    extends SlottedItemIterator<IInventory> {
        public IInventoryItemIterator(int fromIndex) {
            this(IInventoryItemIterator::findIInventory, fromIndex);
        }

        public IInventoryItemIterator(Function<Accessor, @Nullable IInventory> containerFinder, int fromIndex) {
            super(containerFinder, fromIndex);
        }

        @Override
        protected int getSlotCount(IInventory container) {
            return container.func_70302_i_();
        }

        @Override
        protected ItemStack getItemInSlot(IInventory container, int slot) {
            return container.func_70301_a(slot);
        }

        public static IInventory findIInventory(Accessor accessor) {
            Object target = accessor.getTarget();
            if (target instanceof IInventory) {
                IInventory container = (IInventory)target;
                return container;
            }
            return null;
        }
    }

    public static abstract class SlottedItemIterator<T>
    extends ItemIterator<T> {
        protected float progress;

        public SlottedItemIterator(Function<Accessor, @Nullable T> containerFinder, int fromIndex) {
            super(containerFinder, fromIndex);
        }

        protected abstract int getSlotCount(T var1);

        protected abstract ItemStack getItemInSlot(T var1, int var2);

        @Override
        public Stream<ItemStack> populate(T container, int amount) {
            int toIndex;
            int slotCount = this.getSlotCount(container);
            int n = toIndex = (long)this.currentIndex + (long)amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.currentIndex + amount;
            if (toIndex >= slotCount) {
                toIndex = slotCount;
                this.finished = true;
                this.progress = 1.0f;
            } else {
                this.progress = (float)(this.currentIndex - this.fromIndex) / (float)(slotCount - this.fromIndex);
            }
            return IntStream.range(this.currentIndex, toIndex).mapToObj(slot -> this.getItemInSlot(container, slot));
        }

        @Override
        public float getCollectingProgress() {
            return this.progress;
        }
    }
}

