/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.universal;

import com.gtnewhorizons.wdmla.ClientProxy;
import com.gtnewhorizons.wdmla.CommonProxy;
import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IClientExtensionProvider;
import com.gtnewhorizons.wdmla.api.provider.IComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerExtensionProvider;
import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.api.view.ClientViewGroup;
import com.gtnewhorizons.wdmla.api.view.FluidView;
import com.gtnewhorizons.wdmla.api.view.ViewGroup;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.impl.WDMlaClientRegistration;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.impl.ui.component.FluidComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.HPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.ProgressComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TooltipComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.VPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.drawable.FluidDrawable;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Padding;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import com.gtnewhorizons.wdmla.impl.ui.style.ProgressStyle;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.Nullable;

public class FluidStorageProvider<T extends Accessor>
implements IComponentProvider<T>,
IServerDataProvider<T> {
    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, T accessor) {
        List<ClientViewGroup<FluidView>> groups = ClientProxy.mapToClientGroups(accessor, Identifiers.FLUID_STORAGE, FluidStorageProvider::decodeGroups, WDMlaClientRegistration.instance().fluidStorageProviders::get);
        if (groups == null || groups.isEmpty()) {
            return;
        }
        this.append(tooltip, accessor, groups);
    }

    public void append(ITooltip tooltip, T accessor, List<ClientViewGroup<FluidView>> groups) {
        if (!accessor.showDetails() && PluginsConfig.universal.fluidStorage.detailed) {
            return;
        }
        boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            int extra;
            if (renderGroup) {
                group.renderHeader(tooltip);
            }
            for (FluidView view : group.views) {
                IComponent description;
                PluginsConfig.Universal.FluidStorage.Mode showMode;
                ThemeHelper helper = ThemeHelper.INSTANCE;
                String currentStr = FormatUtil.STANDARD.format(view.current) + StatCollector.func_74838_a((String)"hud.wdmla.msg.millibucket");
                String maxStr = FormatUtil.STANDARD.format(view.max) + StatCollector.func_74838_a((String)"hud.wdmla.msg.millibucket");
                PluginsConfig.Universal.FluidStorage.Mode mode = showMode = General.forceLegacy ? PluginsConfig.Universal.FluidStorage.Mode.TEXT : PluginsConfig.universal.fluidStorage.mode;
                if (view.description != null) {
                    description = view.description;
                } else if (view.fluidName == null) {
                    description = accessor.showDetails() && showMode != PluginsConfig.Universal.FluidStorage.Mode.GAUGE ? new HPanelComponent().child(helper.info(StatCollector.func_74838_a((String)"hud.msg.wdmla.empty"))).text(": / ").text(maxStr) : helper.info(StatCollector.func_74838_a((String)"hud.msg.wdmla.empty"));
                } else {
                    String fluidName = FormatUtil.formatNameByPixelCount(view.fluidName);
                    description = accessor.showDetails() && showMode != PluginsConfig.Universal.FluidStorage.Mode.GAUGE ? new HPanelComponent().child(helper.info(currentStr)).text(" / ").text(maxStr) : helper.info(currentStr);
                    description = new HPanelComponent().child(helper.info(fluidName)).text(": ").child(description);
                }
                switch (showMode) {
                    case GAUGE: {
                        ProgressStyle progressStyle = new ProgressStyle().singleColor(General.progressColor.filled).overlay(new FluidDrawable(view.overlay));
                        if (view.hasScale) {
                            progressStyle.color(General.progressColor.filled, General.progressColor.border);
                        }
                        tooltip.child(new ProgressComponent(view.current, view.max).style(progressStyle).child(new VPanelComponent().padding(TooltipComponent.DEFAULT_PROGRESS_DESCRIPTION_PADDING).child(description)));
                        break;
                    }
                    case ICON_TEXT: {
                        if (view.overlay != null) {
                            tooltip.horizontal().child(new FluidComponent(view.overlay).size(new Size(description.getHeight(), description.getHeight()))).child(description);
                            break;
                        }
                        theTooltip.horizontal().item(new ItemStack(Items.field_151133_ar), new Padding(), new Size(description.getHeight(), description.getHeight())).child(description);
                        break;
                    }
                    case TEXT: {
                        theTooltip.child(description);
                    }
                }
            }
            if (group.extraData != null && (extra = group.extraData.func_74762_e("+")) > 0) {
                theTooltip.text(StatCollector.func_74837_a((String)"hud.msg.wdmla.more.tanks", (Object[])new Object[]{extra}));
            }
        });
    }

    @Override
    public void appendServerData(NBTTagCompound data, T accessor) {
        Map.Entry<ResourceLocation, List<ViewGroup<FluidView.Data>>> entry = CommonProxy.getServerExtensionData(accessor, WDMlaCommonRegistration.instance().fluidStorageProviders);
        if (entry != null) {
            data.func_74782_a(Identifiers.FLUID_STORAGE.toString(), (NBTBase)FluidStorageProvider.encodeGroups(entry));
        }
    }

    public static NBTTagCompound encodeGroups(Map.Entry<ResourceLocation, List<ViewGroup<FluidView.Data>>> entry) {
        List<ViewGroup<FluidView.Data>> viewGroups = entry.getValue();
        NBTTagList groupsNBT = new NBTTagList();
        for (ViewGroup<FluidView.Data> viewGroup : viewGroups) {
            groupsNBT.func_74742_a((NBTBase)FluidStorageProvider.encodeGroup(viewGroup));
        }
        NBTTagCompound root = new NBTTagCompound();
        root.func_74782_a(entry.getKey().toString(), (NBTBase)groupsNBT);
        return root;
    }

    public static NBTTagCompound encodeGroup(ViewGroup<FluidView.Data> viewGroup) {
        ArrayList<NBTTagCompound> encodedFluidData = new ArrayList<NBTTagCompound>();
        for (FluidView.Data fluidData : viewGroup.views) {
            encodedFluidData.add(FluidView.Data.encode(fluidData));
        }
        ViewGroup<NBTTagCompound> contentEncodedGroup = new ViewGroup<NBTTagCompound>(encodedFluidData, viewGroup);
        return ViewGroup.encode(contentEncodedGroup);
    }

    public static Map.Entry<ResourceLocation, List<ViewGroup<FluidView.Data>>> decodeGroups(NBTTagCompound root) {
        if (root.func_82582_d()) {
            return null;
        }
        String key = (String)root.func_150296_c().iterator().next();
        ResourceLocation resourceLocation = new ResourceLocation(key);
        NBTTagList groupsNBT = root.func_150295_c(key, 10);
        ArrayList<ViewGroup<FluidView.Data>> viewGroups = new ArrayList<ViewGroup<FluidView.Data>>();
        for (int i = 0; i < groupsNBT.func_74745_c(); ++i) {
            NBTTagCompound groupNBT = groupsNBT.func_150305_b(i);
            viewGroups.add(FluidStorageProvider.decodeGroup(groupNBT));
        }
        return new AbstractMap.SimpleEntry<ResourceLocation, List<ViewGroup<FluidView.Data>>>(resourceLocation, viewGroups);
    }

    public static ViewGroup<FluidView.Data> decodeGroup(NBTTagCompound groupNBT) {
        ViewGroup<NBTTagCompound> contentDecodedGroup = ViewGroup.decode(groupNBT);
        ArrayList<FluidView.Data> fluidDataList = new ArrayList<FluidView.Data>();
        for (NBTTagCompound fluidNBT : contentDecodedGroup.views) {
            fluidDataList.add(FluidView.Data.decode(fluidNBT));
        }
        return new ViewGroup<FluidView.Data>(fluidDataList, contentDecodedGroup);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.FLUID_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 5201;
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        return (accessor.showDetails() || !PluginsConfig.universal.fluidStorage.detailed) && accessor.getTarget() != null && !WDMlaCommonRegistration.instance().fluidStorageProviders.wrappedGet((Accessor)accessor).isEmpty();
    }

    public static class ForBlock
    extends FluidStorageProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();
    }

    public static class ForEntity
    extends FluidStorageProvider<EntityAccessor> {
        private static final ForEntity INSTANCE = new ForEntity();
    }

    public static enum Extension implements IServerExtensionProvider<FluidView.Data>,
    IClientExtensionProvider<FluidView.Data, FluidView>
    {
        INSTANCE;


        @Override
        public ResourceLocation getUid() {
            return Identifiers.FLUID_STORAGE_DEFAULT;
        }

        @Override
        public List<ClientViewGroup<FluidView>> getClientGroups(Accessor accessor, List<ViewGroup<FluidView.Data>> groups) {
            return ClientViewGroup.map(groups, FluidView::readDefault, null);
        }

        @Override
        @Nullable
        public List<ViewGroup<FluidView.Data>> getGroups(Accessor accessor) {
            return CommonProxy.wrapFluidStorage(accessor);
        }

        @Override
        public boolean shouldRequestData(Accessor accessor) {
            return true;
        }

        @Override
        public int getDefaultPriority() {
            return 9999;
        }
    }
}

