/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.hungeroverhaul;

import com.gtnewhorizons.wdmla.api.Mods;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.plugin.hungeroverhaul.HungerOverhaulPlugin;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import iguanaman.hungeroverhaul.util.IguanaEventHook;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public enum HoeResultProvider implements IBlockComponentProvider
{
    INSTANCE;

    private Class<?> mattockClass;
    private Method isWaterNearby;

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
        if (IguanaConfig.modifyHoeUse && this.isHoldingHoe(accessor.getPlayer().field_71071_by.func_70448_g())) {
            Block block = accessor.getBlock();
            if ((block == Blocks.field_150346_d || block == Blocks.field_150349_c) && this.isWaterNearby(accessor)) {
                tooltip.horizontal().child(ThemeHelper.INSTANCE.smallItem(new ItemStack(Blocks.field_150458_ak))).text(StatCollector.func_74838_a((String)"hud.msg.wdmla.near.water")).text(": ").child(ThemeHelper.INSTANCE.success(StatCollector.func_74838_a((String)"hud.msg.wdmla.yes")));
            } else if (block == Blocks.field_150349_c && !this.isWaterNearby(accessor)) {
                tooltip.horizontal().child(ThemeHelper.INSTANCE.smallItem(new ItemStack(Items.field_151014_N))).text(StatCollector.func_74838_a((String)"hud.msg.wdmla.near.water")).text(": ").child(ThemeHelper.INSTANCE.failure(StatCollector.func_74838_a((String)"hud.msg.wdmla.no")));
            } else {
                tooltip.horizontal().text(StatCollector.func_74838_a((String)"hud.msg.wdmla.cannot.hoe"));
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return HungerOverhaulPlugin.path("hoe_result");
    }

    private boolean isHoldingHoe(ItemStack mainHand) {
        if (mainHand == null) {
            return false;
        }
        if (mainHand.func_77973_b() instanceof ItemHoe) {
            return true;
        }
        if (Mods.TCONSTUCT.isLoaded()) {
            if (this.mattockClass == null) {
                try {
                    this.mattockClass = Class.forName("tconstruct.items.tools.Mattock");
                }
                catch (ClassNotFoundException e) {
                    WailaExceptionHandler.handleErr(e, this.getClass().getName(), null);
                }
            }
            return this.mattockClass.isInstance(mainHand.func_77973_b());
        }
        return false;
    }

    private boolean isWaterNearby(BlockAccessor accessor) {
        try {
            if (this.isWaterNearby == null) {
                this.isWaterNearby = IguanaEventHook.class.getDeclaredMethod("isWaterNearby", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.isWaterNearby.setAccessible(true);
            }
            return (Boolean)this.isWaterNearby.invoke((Object)new IguanaEventHook(), accessor.getWorld(), accessor.getHitResult().field_72311_b, accessor.getHitResult().field_72312_c, accessor.getHitResult().field_72309_d);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignore) {
            return false;
        }
    }
}

