/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.harvestability;

import com.gtnewhorizons.wdmla.api.harvestability.EffectiveTool;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityInfo;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityTestPhase;
import com.gtnewhorizons.wdmla.api.provider.HarvestHandler;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.plugin.harvestability.BlockHelper;
import com.gtnewhorizons.wdmla.plugin.harvestability.HarvestabilityIdentifiers;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;

public enum VanillaHarvestToolHandler implements HarvestHandler
{
    INSTANCE;

    private static final HashMap<EffectiveTool, ItemStack> testTools;
    public static final EffectiveTool TOOL_PICKAXE;
    public static final EffectiveTool TOOL_SHOVEL;
    public static final EffectiveTool TOOL_AXE;
    public static final EffectiveTool TOOL_SWORD;

    @Override
    public boolean testHarvest(HarvestabilityInfo info, HarvestabilityTestPhase phase, EntityPlayer player, Block block, int meta, MovingObjectPosition position) {
        if (phase == HarvestabilityTestPhase.EFFECTIVE_TOOL_NAME) {
            if (!info.getEffectiveTool().isValid()) {
                float hardness = block.func_149712_f(player.field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d);
                if (hardness > 0.0f) {
                    for (Map.Entry<EffectiveTool, ItemStack> testToolEntry : testTools.entrySet()) {
                        ItemStack testTool = testToolEntry.getValue();
                        if (!(testTool.func_150997_a(block) >= ((ItemTool)testTool.func_77973_b()).func_150913_i().func_77998_b())) continue;
                        info.setEffectiveTool(testToolEntry.getKey());
                        break;
                    }
                }
            } else {
                for (Map.Entry<EffectiveTool, ItemStack> testTool : testTools.entrySet()) {
                    if (!info.getEffectiveTool().isSameTool(testTool.getKey())) continue;
                    info.setEffectiveTool(testTool.getKey());
                }
                if (info.getEffectiveTool().isSameTool(TOOL_SWORD)) {
                    info.setEffectiveTool(TOOL_SWORD);
                }
            }
        } else if (phase == HarvestabilityTestPhase.ADDITIONAL_TOOLS_ICON) {
            HarvestabilityInfo.AdditionalToolInfo canSilktouch;
            HarvestabilityInfo.AdditionalToolInfo canShear;
            if (PluginsConfig.harvestability.icon.showShearabilityIcon && (canShear = BlockHelper.getShearability(player, block, meta, position)) != null) {
                info.registerAdditionalToolInfo(canShear);
            }
            if (PluginsConfig.harvestability.icon.showSilkTouchabilityIcon && (canSilktouch = BlockHelper.getSilktouchAbility(player, block, meta, position)) != null) {
                info.registerAdditionalToolInfo(canSilktouch);
            }
        }
        return true;
    }

    @Override
    public ResourceLocation getUid() {
        return HarvestabilityIdentifiers.VANILLA;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    static {
        testTools = new HashMap();
        TOOL_PICKAXE = new EffectiveTool("pickaxe", Arrays.asList(new ItemStack(Items.field_151039_o), new ItemStack(Items.field_151050_s), new ItemStack(Items.field_151035_b), new ItemStack(Items.field_151046_w)));
        TOOL_SHOVEL = new EffectiveTool("shovel", Arrays.asList(new ItemStack(Items.field_151038_n)));
        TOOL_AXE = new EffectiveTool("axe", Arrays.asList(new ItemStack(Items.field_151053_p)));
        TOOL_SWORD = new EffectiveTool("sword", Arrays.asList(new ItemStack(Items.field_151041_m)));
        testTools.put(TOOL_PICKAXE, new ItemStack(Items.field_151039_o));
        testTools.put(TOOL_SHOVEL, new ItemStack(Items.field_151038_n));
        testTools.put(TOOL_AXE, new ItemStack(Items.field_151053_p));
    }
}

